function [ Mesh ] = Set_Derivative( Mesh )
    N=Mesh.N;
    dz=Mesh.dz;
    dzdy=Mesh.dzdy;
    ddzdyy=Mesh.ddzdyy;
    
    if Mesh.cheby
        D1_diag=zeros(N,1);
        C = ones(N,1); C(1)=2; C(N)=2;
        z = Mesh.z;
        
        for i=2:N-1
            D1_diag(i)=-z(i)/2/(1-z(i)^2);    
        end
        D1_diag(1)=(2*(N-1)^2+1)/6;
        D1_diag(N)=-D1_diag(1);
        D1=diag(D1_diag);
        
        for i=1:N
        for j=1:N
        if i~=j
            D1(i,j)=C(i)/C(j)*(-1)^(i+j)/(z(i)-z(j));
        end
        end
        end
        D2=D1*D1;
    else
        % 4-th order FD
        D1=sparse(N,N);
        D2=sparse(N,N);

        D1(1:2,1:5)=[-25/12,  48/12, -36/12, 16/12, -3/12;...
                      -3/12, -10/12,  18/12, -6/12,  1/12];

        D2(2,1:6)=[10/12, -15/12, -4/12, 14/12, -6/12, 1/12];
        D2(1,1:8)=[469/90, -223/10, 879/20, -949/18, 41, -201/10, 1019/180, -7/10];


        for i=3:N-2
            D1(i,[i-2,i-1,i+1,i+2])=[1/12, -8/12, 8/12, -1/12];  %#ok<*SPRIX>
            D2(i,i-2:i+2)=[-1/12, 16/12, -30/12, 16/12, -1/12];
        end

        D1(N-1:N,N-4:N)=[-1/12,   6/12, -18/12,  10/12,  3/12;...
                          3/12, -16/12,  36/12, -48/12, 25/12];

        D2(N-1,N-5:N)=[1/12, -6/12, 14/12, -4/12, -15/12, 10/12];
        D2(N,N-7:N)=[-7/10, 1019/180, -201/10, 41, -949/18, 879/20, -223/10, 469/90];
    end
    
    Dy  = D1/dz.*dzdy;
    DDy = D2/(dz)^2.*(dzdy.^2)+D1/dz.*ddzdyy;
    
%     DDy(1,:)=0;
%     DDy(N,:)=0;
    
    Mesh.Dy=Dy;
    Mesh.DDy=DDy;
    
%TEST     
%     f=sin(MESH.y);
%     f(:,2)=MESH.Dy*f(:,1);
%     f(:,3)=MESH.DDy*f(:,1);
%     plot(MESH.y,f)


end

