function [Residual] = NPSE_renew_alf_Chang(Baseflow, xi,Mesh,Faixi,Faixi1)


dx    = Mesh.dx;
Ny    = Mesh.N;

E      = zeros(Ny,1);
E_all  = 0;
dE_all = 0;

ux   = zeros(Ny,1);
vx   = zeros(Ny,1);
wx   = zeros(Ny,1);
dE   = zeros(Ny,1);

Den  = Baseflow.Den(:,xi);   

y    = Mesh.y;

for i=1:Ny
    u       = Faixi (5*(i-1)+2);
    v       = Faixi (5*(i-1)+3); 
    w       = Faixi (5*(i-1)+4); 
    u1      = Faixi1(5*(i-1)+2);
    v1      = Faixi1(5*(i-1)+3);
    w1      = Faixi1(5*(i-1)+4);
    
    E(i)    = Den(i)*(abs(u)^2+abs(v)^2+abs(w)^2);
    ux(i)   = (u-u1)/dx;
    vx(i)   = (v-v1)/dx;
    wx(i)   = (w-w1)/dx;
    
    dE(i)   = Den(i)*(conj(u)*ux(i)+conj(v)*vx(i)+conj(w)*wx(i));

    if i>=2
        E_all  = E_all+(E(i)+E(i-1))*(y(i)-y(i-1))/2;
        dE_all = dE_all+(dE(i)+dE(i-1))*(y(i)-y(i-1))/2;   
    end

end

Residual=dE_all/E_all;


end