library(minpack.lm)

fit_curve <- function(dt, fit = c("S", "G", "L", "E"), total = F, t_exp = NA) {
  print(fit)
  if (!"Total" %in% colnames(dt)) {total = F}
  if (total) {d.tot <- select(dt, Year, Total)}
  max.year <- max(dt$Year)
    min.year <- min(dt$Year)
    max.value <- max(dt$Value)
    t.exp <- ifelse(is.na(t_exp), min.year, t_exp)
    
    dt1 <- dt %>% mutate(Value0 = lag(Value), Delta = Value - Value0) %>%
      na.omit %>%
      filter(Delta == max(Delta))
    max.delta <- dt1$Year[1]
    
    result <- data.frame()
    if ("S" %in% fit) {
      #Logistic fit
      xt <- max.delta
      catch = tryCatch({
        n1 <- nlsLM(Value ~ asym/(1 +  exp((xtime - Year) * k)),
                          start=list(asym = max.value, xtime = xt, k = 0.5), data = dt,
                          control = nls.lm.control(maxiter = 500))
              
        #Parsing logistic results
        asym <- coef(n1)["asym"]
        xtime <- coef(n1)["xtime"]
        k <- coef(n1)["k"]
        delta <- log(81)/k
        maturity <- 1/(1 +  exp((xtime - max.year) * k))
        speed <- exp(k * (max.year - xtime))/( 1 + exp(k * (max.year - xtime)))^2 * 4
        speed <- ifelse(xtime >= max.year, speed, - speed)
        g = asym * k/4
        rss <- n1$m$deviance()
        if (total) {
          xtime.int <- round(xtime)
          if (xtime.int <= max.year) {
            dm <- filter(d.tot, Year == xtime.int)
          } else {
            dm <- filter(d.tot, Year == max.year)
          }
                      
                      
          if (nrow(dm) > 0) {
            size <- dm$Total[1]
          } else {
            size <- NA
          }
          res <- data.frame(Fit = "S", K = k,  L = asym, TMax = xtime,
                          G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                          Speed = speed, Size = size, RSS = rss, Good = 1)
        } else {
          res <- data.frame(Fit = "S", K = k,  L = asym, TMax = xtime,
                            G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
        }
      } , error = function(e) {
        print(str_c('Error!', " S"))
        print(e)
        if (total) {
          res <- data.frame(Fit = "S", K = 0,  L = 0, TMax = 0,
                          G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
        } else {
          res <- data.frame(Fit = "S", K = 0,  L = 0, TMax = 0,
                            G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
        }
        return(res)
      }, finally = {
        
      }
      )
      res <- catch
      result <- result %>% rbind(res)
    } 
    
    if ("G" %in% fit) {
      xt <- max.delta
      #Gompertz fit
      catch = tryCatch({
        n2 <- nlsLM(Value ~ asym * exp(-  exp((xtime - Year) * k)),
                    start=list(asym = max.value, xtime = xt, k = 0.5), data = dt,
                    control = nls.lm.control(maxiter = 1000))
        
        #Parsing Gompertz results   
        asym <- coef(n2)["asym"]
        k <- coef(n2)["k"]
        xtime <- coef(n2)["xtime"]
        delta <- log(log(0.1)/log(0.9))/k
        g = asym * k / exp(1)
        rss <- n2$m$deviance()
        maturity <- exp(- exp(k * (xtime - max.year)))
        speed <- exp(-exp(- k * (max.year - xtime))) * exp(- k * (max.year - xtime)) * exp(1)
        speed <- ifelse(xtime >= max.year, speed, - speed)
        if (total) {
          xtime.int <- round(xtime)
          if (xtime.int <= max.year) {
            dm <- filter(d.tot, Year == xtime.int)
          } else {
            dm <- filter(d.tot, Year == max.year)
          }
          if (nrow(dm) > 0) {
            size <- dm$Total[1]
          } else {
            size <- NA
          }
          res <- data.frame(Fit = "G", K = k,  L = asym, TMax = xtime,
                            G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                            Speed = speed, Size = size, RSS = rss, Good = 1)
        } else {
          res <- data.frame(Fit = "G", K = k,  L = asym, TMax = xtime,
                            G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
        }
      } , error = function(e) {
        print(str_c('Error!', " G"))
        print(e)
        if (total) {
          res <- data.frame(Fit = "G", K = 0,  L = 0, TMax = 0,
                            G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
        } else {
          res <- data.frame(Fit = "G", K = 0,  L = 0, TMax = 0,
                            G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
        }
        return(res)
      }, finally = {
        
      }
      )
      res <- catch
      result <- result %>% rbind(res)
    } 
    
    if ("L" %in% fit) {
      #Logistic-linear fit
      xt <- max.delta
      catch = tryCatch({
        n3 <- nlsLM(Value ~ ifelse(Year <= xtime, asym/(1 +  exp((xtime - Year) * k)),
                                   asym/2 + asym * k /4 * (Year - xtime)),
                    start=list(asym = max.value, xtime = xt, k = 0.5), data = dt,
                    control = nls.lm.control(maxiter = 500))
        
        #Parsing logistic results
        asym <- coef(n3)["asym"]
        xtime <- coef(n3)["xtime"]
        k <- coef(n3)["k"]
        maturity <- 1/(1 +  exp((xtime - max.year) * k))
        delta <- log(81)/k
        speed <- ifelse(xtime >= max.year, exp(k * (max.year - xtime))/( 1 + exp(k * (max.year - xtime)))^2 * 4,
                        1)
        g = asym * k/4
        rss <- n3$m$deviance()
        if (total) {
          xtime.int <- round(xtime)
          if (xtime.int <= max.year) {
            dm <- filter(d.tot, Year == xtime.int)
          } else {
            dm <- filter(d.tot, Year == max.year)
          }
          if (nrow(dm) > 0) {
            size <- dm$Total[1]
          } else {
            size <- NA
          }
          res <- data.frame(Fit = "L", K = k,  L = asym, TMax = xtime,
                            G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                            Speed = speed, Size = size, RSS = rss, Good = 1)
        } else {
          res <- data.frame(Fit = "L", K = k,  L = asym, TMax = xtime,
                            G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
        }
      } , error = function(e) {
        print(str_c('Error!', " L"))
        print(e)
        if (total) {
          res <- data.frame(Fit = "L", K = 0,  L = 0, TMax = 0,
                            G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
        } else {
          res <- data.frame(Fit = "L", K = 0,  L = 0, TMax = 0,
                            G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
        }
        return(res)
      }, finally = {
        
      }
      )
      res <- catch
      result <- result %>% rbind(res)
    }
    if ("L1" %in% fit) {
      #Logistic-linear fit
      xt <- max.delta
      catch = tryCatch({
        n3 <- nlsLM(Value ~ ifelse(Year <= xtime, 0,
                                   k * (Year - xtime)),
                    start=list(xtime = xt, k = max.value / 10), data = dt,
                    control = nls.lm.control(maxiter = 500))
        
        #Parsing logistic results
        asym <- 0
        xtime <- coef(n3)["xtime"]
        k <- coef(n3)["k"]
        maturity <- 0
        delta <- 0
        speed <- 0
        g = k
        rss <- n3$m$deviance()
        if (total) {
          xtime.int <- round(xtime)
          if (xtime.int <= max.year) {
            dm <- filter(d.tot, Year == xtime.int)
          } else {
            dm <- filter(d.tot, Year == max.year)
          }
          if (nrow(dm) > 0) {
            size <- dm$Total[1]
          } else {
            size <- NA
          }
          res <- data.frame(Fit = "L1", K = k,  L = asym, TMax = xtime,
                            G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                            Speed = speed, Size = size, RSS = rss, Good = 1)
        } else {
          res <- data.frame(Fit = "L1", K = k,  L = asym, TMax = xtime,
                            G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
        }
      } , error = function(e) {
        print(str_c('Error!', " L"))
        print(e)
        if (total) {
          res <- data.frame(Fit = "L1", K = 0,  L = 0, TMax = 0,
                            G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
        } else {
          res <- data.frame(Fit = "L1", K = 0,  L = 0, TMax = 0,
                            G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
        }
        return(res)
      }, finally = {
        
      }
      )
      res <- catch
      result <- result %>% rbind(res)
    }
    if ("E" %in% fit) {
      #Logistic fit
      catch = tryCatch({
        n4 <- nlsLM(Value ~ asym * exp((Year - t.exp) * k),
                    start=list(asym = max.value, k = 0.5), data = dt,
                    control = nls.lm.control(maxiter = 500))
        
        #Parsing logistic results
        asym <- coef(n4)["asym"]
        xtime <- coef(n4)["xtime"]
        k <- coef(n4)["k"]
        rss <- n4$m$deviance()
        if (total) {
          res <- data.frame(Fit = "E", K = k,  L = asym, TMax = t.exp,
                            G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = rss, Good = 1)
        } else {
          res <- data.frame(Fit = "E", K = k,  L = asym, TMax = t.exp,
                          G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = rss, Good = 1)
        }
      } , error = function(e) {
        print(str_c('Error!', " L"))
        print(e)
        res <- data.frame(Fit = "E", K = 0,  L = 0, TMax = 0,
                          G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
        return(res)
      }, finally = {
        
      }
      )
      res <- catch
      result <- result %>% rbind(res)
    } 
    return(result)
}


fit_curve_test <- function(dt, fit = c("S", "G", "L", "E"), total = F, t_exp = NA) {
  print(fit)
  if (!"Total" %in% colnames(dt)) {total = F}
  if (total) {d.tot <- select(dt, Year, Total)}
  max.year <- max(dt$Year)
  min.year <- min(dt$Year)
  max.value <- max(dt$Value)
  t.exp <- ifelse(is.na(t_exp), min.year, t_exp)
  dt1 <- dt %>% mutate(Value0 = lag(Value), Delta = Value - Value0) %>%
    na.omit %>%
    filter(Delta == max(Delta))
  max.delta <- dt1$Year[1]
  
  result <- data.frame()
  if ("S" %in% fit) {
    #Logistic fit
    xt <- max.delta
    catch = tryCatch({
      n1 <- nlsLM(Value ~ asym/(1 +  exp((xtime - Year) * k)),
                  start=list(asym = max.value, xtime = xt, k = 0.5), data = dt,
                  control = nls.lm.control(maxiter = 500))
      
      #Parsing logistic results
      asym <- coef(n1)["asym"]
      xtime <- coef(n1)["xtime"]
      k <- coef(n1)["k"]
      delta <- log(81)/k
      maturity <- 1/(1 +  exp((xtime - max.year) * k))
      speed <- exp(k * (max.year - xtime))/( 1 + exp(k * (max.year - xtime)))^2 * 4
      speed <- ifelse(xtime >= max.year, speed, - speed)
      g = asym * k/4
      rss <- n1$m$deviance()
      if (total) {
        xtime.int <- round(xtime)
        if (xtime.int <= max.year) {
          dm <- filter(d.tot, Year == xtime.int)
        } else {
          dm <- filter(d.tot, Year == max.year)
        }
        
        
        if (nrow(dm) > 0) {
          size <- dm$Total[1]
        } else {
          size <- NA
        }
        res <- data.frame(Fit = "S", K = k,  L = asym, TMax = xtime,
                          G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                          Speed = speed, Size = size, RSS = rss, Good = 1)
      } else {
        res <- data.frame(Fit = "S", K = k,  L = asym, TMax = xtime,
                          G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
      }
    } , error = function(e) {
      print(str_c('Error!', " S"))
      print(e)
      if (total) {
        res <- data.frame(Fit = "S", K = 0,  L = 0, TMax = 0,
                          G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
      } else {
        res <- data.frame(Fit = "S", K = 0,  L = 0, TMax = 0,
                          G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
      }
      return(res)
    }, finally = {
      
    }
    )
    res <- catch
    result <- result %>% rbind(res)
  } 
  
  if ("G" %in% fit) {
    xt <- max.delta
    #Gompertz fit
    catch = tryCatch({
      n2 <- nlsLM(Value ~ asym * exp(-  exp((xtime - Year) * k)),
                  start=list(asym = max.value * 3, xtime = xt, k = 0.5), data = dt,
                  control = nls.lm.control(maxiter = 1000))
      
      #Parsing Gompertz results   
      asym <- coef(n2)["asym"]
      k <- coef(n2)["k"]
      xtime <- coef(n2)["xtime"]
      delta <- log(log(0.1)/log(0.9))/k
      g = asym * k / exp(1)
      rss <- n2$m$deviance()
      maturity <- exp(- exp(k * (xtime - max.year)))
      speed <- exp(-exp(- k * (max.year - xtime))) * exp(- k * (max.year - xtime)) * exp(1)
      speed <- ifelse(xtime >= max.year, speed, - speed)
      if (total) {
        xtime.int <- round(xtime)
        if (xtime.int <= max.year) {
          dm <- filter(d.tot, Year == xtime.int)
        } else {
          dm <- filter(d.tot, Year == max.year)
        }
        if (nrow(dm) > 0) {
          size <- dm$Total[1]
        } else {
          size <- NA
        }
        res <- data.frame(Fit = "G", K = k,  L = asym, TMax = xtime,
                          G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                          Speed = speed, Size = size, RSS = rss, Good = 1)
      } else {
        res <- data.frame(Fit = "G", K = k,  L = asym, TMax = xtime,
                          G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
      }
    } , error = function(e) {
      print(str_c('Error!', " G"))
      print(e)
      if (total) {
        res <- data.frame(Fit = "G", K = 0,  L = 0, TMax = 0,
                          G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
      } else {
        res <- data.frame(Fit = "G", K = 0,  L = 0, TMax = 0,
                          G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
      }
      return(res)
    }, finally = {
      
    }
    )
    res <- catch
    result <- result %>% rbind(res)
  } 
  
  if ("L" %in% fit) {
    #Logistic-linear fit
    xt <- max.delta
    catch = tryCatch({
      n3 <- nlsLM(Value ~ ifelse(Year <= xtime, asym/(1 +  exp((xtime - Year) * k)),
                                 asym/2 + asym * k /4 * (Year - xtime)),
                  start=list(asym = max.value, xtime = xt, k = 0.5), data = dt,
                  control = nls.lm.control(maxiter = 500))
      
      #Parsing logistic results
      asym <- coef(n3)["asym"]
      xtime <- coef(n3)["xtime"]
      k <- coef(n3)["k"]
      maturity <- 1/(1 +  exp((xtime - max.year) * k))
      delta <- log(81)/k
      speed <- ifelse(xtime >= max.year, exp(k * (max.year - xtime))/( 1 + exp(k * (max.year - xtime)))^2 * 4,
                      1)
      g = asym * k/4
      rss <- n3$m$deviance()
      if (total) {
        xtime.int <- round(xtime)
        if (xtime.int <= max.year) {
          dm <- filter(d.tot, Year == xtime.int)
        } else {
          dm <- filter(d.tot, Year == max.year)
        }
        if (nrow(dm) > 0) {
          size <- dm$Total[1]
        } else {
          size <- NA
        }
        res <- data.frame(Fit = "L", K = k,  L = asym, TMax = xtime,
                          G = g, G.Rel = g/size, dT = delta, Maturity = maturity, 
                          Speed = speed, Size = size, RSS = rss, Good = 1)
      } else {
        res <- data.frame(Fit = "L", K = k,  L = asym, TMax = xtime,
                          G = g, dT = delta, Maturity = maturity, Speed = speed, RSS = rss, Good = 1)
      }
    } , error = function(e) {
      print(str_c('Error!', " L"))
      print(e)
      if (total) {
        res <- data.frame(Fit = "L", K = 0,  L = 0, TMax = 0,
                          G = 0, G.Rel = 0, dT = 0, Maturity = 0, Speed = 0, Size = 0, RSS = 0, Good = 0)
      } else {
        res <- data.frame(Fit = "L", K = 0,  L = 0, TMax = 0,
                          G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
      }
      return(res)
    }, finally = {
      
    }
    )
    res <- catch
    result <- result %>% rbind(res)
  }
  if ("E" %in% fit) {
    #Logistic fit
    catch = tryCatch({
      n4 <- nlsLM(Value ~ asym * exp((Year - t.exp) * k),
                  start=list(asym = max.value, k = 0.5), data = dt,
                  control = nls.lm.control(maxiter = 500))
      
      #Parsing logistic results
      asym <- coef(n4)["asym"]
      xtime <- coef(n4)["xtime"]
      k <- coef(n4)["k"]
      rss <- n4$m$deviance()
      res <- data.frame(Fit = "E", K = k,  L = asym, TMax = t.exp,
                        G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = rss, Good = 1)
    } , error = function(e) {
      print(str_c('Error!', " L"))
      print(e)
      res <- data.frame(Fit = "E", K = 0,  L = 0, TMax = 0,
                        G = 0, dT = 0, Maturity = 0, Speed = 0, RSS = 0, Good = 0)
      return(res)
    }, finally = {
      
    }
    )
    res <- catch
    result <- result %>% rbind(res)
  } 
  return(result)
}


get_rx <- function(df, n = 3, max = T, debug = F, last = F) {
  if ("Fuel" %in% colnames(df)) {
    fuel <- T
  } else {
    fuel <- F
  }
  n.r <- str_c("R", n)
  n.rel <- str_c("R", n, ".Rel")
  n.size <- str_c("R", n, ".Size")
  n.period <- str_c("R", n, ".Period")
  
  if (fuel) {
    df0 <- df %>%
      mutate(Year = Year + n) %>%
      select(Country, Fuel, Year, Value0 = Value, Total0 = Total )
    
    df1 <- df %>% inner_join(df0) %>%
      mutate(RX = (Value - Value0) / n, 
             RX.Rel = (Value - Value0) * 2 / (Total + Total0) / n,
             RX.Size = (Total + Total0)/2,
             RX.Period = str_c((Year - n), "-", Year))
    if (last) {
      df2 <- df1 %>% group_by(Country, Fuel) %>%
        slice_max(Year, with_ties = F) %>%
        ungroup %>%
        select(Country, Fuel, Value, Total, Value0, Total0, RX, RX.Rel, RX.Size, RX.Period)
    } else {
      df2 <- df1 %>% group_by(Country, Fuel) %>%
        slice_max(RX.Rel, with_ties = F) %>%
        ungroup %>%
        select(Country, Fuel, Value, Total, Value0, Total0, RX, RX.Rel, RX.Size, RX.Period)
    }

  } else {
    df0 <- df %>%
      mutate(Year = Year + n) %>%
      select(Country, Year, Value0 = Value, Total0 = Total )
    
    df1 <- df %>% inner_join(df0) %>%
      mutate(RX = (Value - Value0) / n, 
             RX.Rel = (Value - Value0) * 2 / (Total + Total0) / n,
             RX.Size = (Total + Total0)/2,
             RX.Period = str_c((Year - n), "-", Year))
    if (last) {
      df2 <- df1 %>% group_by(Country, Fuel) %>%
        slice_max(Year, with_ties = F) %>%
        ungroup %>%
        select(Country, Value, Total, Value0, Total0, RX, RX.Rel, RX.Size, RX.Period)
    } else {
      df2 <- df1 %>% group_by(Country, Fuel) %>%
        slice_max(RX.Rel, with_ties = F) %>%
        ungroup %>%
        select(Country, Value, Total, Value0, Total0, RX, RX.Rel, RX.Size, RX.Period)
    }
    
  }
  
  df3 <- df2  %>%
    rename(!!n.r := RX, !!n.rel := RX.Rel, !!n.size := RX.Size, !!n.period := RX.Period)
  
  if (!debug) {
    df3 <- df3 %>% select(- Value, - Value0, - Total, - Total0)
  }
  return(df3)
}

make_wide_table <- function(fit, rx = NA) {
  fit.s <- fit %>% filter(Fit == "S") %>%
    select(Country, Fuel, TO.Year, TMax.S = TMax, G.S = G, G.Rel.S = G.Rel, Size.S = Size, 
           dT.S = dT, Mat.S = Maturity, Speed.S = Speed, RSS.S = RSS)
  
  fit.g <- fit %>% filter(Fit == "G") %>%
    select(Country, Fuel, TMax.G = TMax, G.G = G, G.Rel.G = G.Rel, Size.G = Size, dT.G = dT, Mat.G = Maturity, 
           Speed.G = Speed, RSS.G = RSS)
  
  fit2 <- fit.s %>% inner_join(fit.g) %>%
    mutate(Status = ifelse(Mat.S < 0.5 | (Speed.G < 0.75 & Speed.G >= 0 ), "Acc.", NA),
           Status = ifelse(is.na(Status) & Mat.S < 0.9, "Stable", Status),
           Status = ifelse(is.na(Status) , "Stagn.", Status),
           Status = ifelse(Status != "Acc." & Fuel == "Wind" & dT.S < 4, "Short dT", Status),
           Status = ifelse(Status != "Acc." & Fuel == "SolarPV" & dT.S < 3, "Short dT", Status),
           RSS.S2G = RSS.S/RSS.G,
           G.Mean = (G.Rel.S + G.Rel.G)/2,
           Size.Mean = (Size.S + Size.G) / 2
          ) 
  f.status <- fit2 %>% select(Country, Fuel, Status)
  
  fit3 <- fit2 %>%  
    mutate(G.Final = ifelse(Status %in% c("Stable", "Stagn."), G.Mean, NA),
           Size = ifelse(Status %in% c("Stable", "Stagn."), Size.Mean, NA),
    ) 
  
  
  if (is.data.frame(rx)) {
    pref0 <- grep(".Rel", colnames(rx), value = T)
    pref <- str_split(pref0, "\\.")[[1]][1]
    rx.size <- str_c(pref, ".Size")
    rx.rel <- str_c(pref, ".Rel")
    
    rx1 <- rx %>% rename(RX.Rel := !!rx.rel, RX.Size := !!rx.size) %>%
      select(Country, Fuel, RX.Rel, RX.Size)
    fit4 <- fit3 %>% inner_join(rx1) %>%
      mutate(G.Final = ifelse(Status == "Acc.", RX.Rel, G.Final),
             Size = ifelse(Status == "Acc.", RX.Size, Size)) %>%
      select(- RX.Rel, RX.Size)
    
  } else {
    fit4 <- fit3
  }
  
  fit5 <- fit4 %>% select(Country, Fuel, TO.Year, TMax.S, G.S, G.Rel.S, Size.S, dT.S, Mat.S, Speed.S, 
                          TMax.G, G.G, G.Rel.G, Size.G, dT.G, Mat.G, Speed.G, RSS.S2G, G.Final, Size, Status) %>%
  return(fit5)
  
}


make_wide_table_k <- function(fit, rx = NA) {
  fit.s <- fit %>% filter(Fit == "S") %>%
    select(Country, Fuel, TO.Year, K.S = K, L.S = L, TMax.S = TMax, G.S = G, G.Rel.S = G.Rel, Size.S = Size, 
           dT.S = dT, Mat.S = Maturity, Speed.S = Speed, RSS.S = RSS)
  
  fit.g <- fit %>% filter(Fit == "G") %>%
    select(Country, Fuel,  K.G = K, L.G = L, TMax.G = TMax, G.G = G, G.Rel.G = G.Rel, Size.G = Size, dT.G = dT, Mat.G = Maturity, 
           Speed.G = Speed, RSS.G = RSS)
  
  fit2 <- fit.s %>% inner_join(fit.g) %>%
    mutate(Status = ifelse(Mat.S < 0.5 | (Speed.G < 0.75 & Speed.G >= 0 ), "Acc.", NA),
           Status = ifelse(is.na(Status) & Mat.S < 0.9, "Stable", Status),
           Status = ifelse(is.na(Status) , "Stagn.", Status),
           Status = ifelse(Status != "Acc." & Fuel == "Wind" & dT.S < 4, "Short dT", Status),
           Status = ifelse(Status != "Acc." & Fuel == "SolarPV" & dT.S < 3, "Short dT", Status),
           RSS.S2G = RSS.S/RSS.G,
           G.Mean = (G.Rel.S + G.Rel.G)/2,
           Size.Mean = (Size.S + Size.G) / 2
    ) 
  f.status <- fit2 %>% select(Country, Fuel, Status)
  
  fit3 <- fit2 %>%  
    mutate(G.Final = ifelse(Status %in% c("Stable", "Stagn."), G.Mean, NA),
           Size = ifelse(Status %in% c("Stable", "Stagn."), Size.Mean, NA),
    ) 
  
  
  if (is.data.frame(rx)) {
    pref0 <- grep(".Rel", colnames(rx), value = T)
    pref <- str_split(pref0, "\\.")[[1]][1]
    rx.size <- str_c(pref, ".Size")
    rx.rel <- str_c(pref, ".Rel")
    
    rx1 <- rx %>% rename(RX.Rel := !!rx.rel, RX.Size := !!rx.size) %>%
      select(Country, Fuel, RX.Rel, RX.Size)
    fit4 <- fit3 %>% inner_join(rx1) %>%
      mutate(G.Final = ifelse(Status == "Acc.", RX.Rel, G.Final),
             Size = ifelse(Status == "Acc.", RX.Size, Size)) %>%
      select(- RX.Rel, RX.Size)
    
  } else {
    fit4 <- fit3
  }
  
  fit5 <- fit4 %>% select(Country, Fuel, TO.Year, K.S, L.S, TMax.S, G.S, G.Rel.S, Size.S, dT.S, Mat.S, Speed.S, 
                          K.G, L.G, TMax.G, G.G, G.Rel.G, Size.G, dT.G, Mat.G, Speed.G, RSS.S2G, G.Final, Size, Status) %>%
    return(fit5)
  
}