suppressPackageStartupMessages({
  required_packages <- c(
    "tidyverse", "ggplot2", "ggstar", "patchwork"
  )
  
  for (pkg in required_packages) {
    if (!requireNamespace(pkg, quietly = TRUE)) {
      install.packages(pkg)
    }
    library(pkg, character.only = TRUE)
  }
})

'%!in%' <- function(x,y)!('%in%'(x,y))

global_data <- read_csv('data/input/global_solar_onshore_wind.csv')

global_wind <- global_data %>% filter(Technology=="Onshore wind")
global_solar <- global_data %>% filter(Technology=="Solar PV")

ipcc_summary <- read_csv('data/input/ipcc_ranges.csv')

ipcc_summary$Warming <- factor(ipcc_summary$Warming , levels = c("<1.5ºC, no/limited overshoot", 
                                                                 "<1.5ºC, high overshoot", "Likely <2ºC", "<2ºC"))


warming_clrs <- c("<1.5ºC, no/limited overshoot" = '#3EBCD2', "<1.5ºC, high overshoot"='#4B86B8', "Likely <2ºC"='#F9E196', "<2ºC"= '#F2B16E')


proj_data <-read_csv('data/input/probabilistic_projections.csv')

solar_proj <- proj_data %>% filter(Technology=="Solar PV")

wind_proj <- proj_data %>% filter(Technology=="Onshore wind")

ipcc_solar <-ipcc_summary %>% filter(Tech=="Solar PV", Year<=2050)
solar_2030_target <- tibble(Year=2030, Share=0.19, Data="Global Pledge on Renewables, COP28")

ipcc_vs_proj_solar <- ggplot(ipcc_solar, aes(x=Year, y=median))+
  geom_ribbon(data = solar_proj, aes(ymin=p05, ymax=p95), alpha=0.1, show.legend = FALSE, fill='#379A8B')+
  geom_ribbon(data = solar_proj, aes(ymin=p25, ymax=p75), alpha=0.2, show.legend = FALSE, fill='#379A8B')+
  geom_line(data = solar_proj, alpha=0.5, linewidth=0.5, color='#379A8B')+
  geom_point(data=global_solar, aes(x=Year, y=Share, color=Data), alpha=0.6, size=1.5, shape=16)+
  scale_color_manual(values = c('Historical data'='black'), name=NULL)+
  ggnewscale::new_scale_color()+
  geom_pointrange(aes(ymin=q1, ymax=q3, color=Warming), position = position_dodge(width = 3), size=0.4, show.legend = FALSE)+
  scale_color_manual(values = warming_clrs, guide="legend", name="End-of-century warming\n(IPCC AR6 scenarios)")+
  guides(color=guide_legend(override.aes = list(alpha=1), ncol=1, byrow=TRUE, title.position="top"))+
  geom_star(data = solar_2030_target, aes(x=Year, y=Share, starshape=Data), size=2, alpha=0.9, fill='white')+
  scale_starshape_manual(values = c('Global Pledge on Renewables, COP28'=1), name=NULL)+
  guides(starshape=guide_legend(override.aes = list(alpha=1), byrow=TRUE, ncol=1, title.position="top"))+
  scale_alpha_continuous(range = c(0, 1)) +
  coord_cartesian(ylim = c(0,0.6), xlim = c(2020,2052))+
  scale_x_continuous(breaks = c(2020, 2025, 2030, 2035, 2040, 2045, 2050))+
  scale_y_continuous(labels = scales::percent)+
  theme_bw()+
  theme(panel.grid.minor = element_blank(), panel.grid.major.x = element_blank(), panel.grid.major.y = element_line(linewidth = 0.2),
        legend.position = "bottom",
        title = element_text(face="bold", size=8),
        plot.title = element_text(hjust=0.5),
        plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines"),
        legend.key.size = unit(8, 'pt'), #change legend key size
        legend.key.height = unit(3, 'pt'), #change legend key height
        legend.key.width = unit(6, 'pt'), #change legend key width
        legend.title = element_text(size=7), #change legend title font size
        legend.text = element_text(size=7))+
  labs(x=NULL, y=NULL, title="Solar PV")

ipcc_vs_proj_solar

ipcc_wind <-ipcc_summary %>% filter(Tech=="Wind", Year<=2050)

wind_2030_target <- tibble(Year=2030, Share=0.16, Data="Global Pledge on Renewables, COP28")


ipcc_vs_proj_wind <- ggplot(ipcc_wind, aes(x=Year, y=median))+
  geom_ribbon(data = wind_proj, aes(ymin=p05, ymax=p95), alpha=0.1, show.legend = FALSE, fill='#379A8B')+
  geom_ribbon(data = wind_proj, aes(ymin=p25, ymax=p75), alpha=0.2, show.legend = FALSE, fill='#379A8B')+
  geom_line(data = wind_proj, alpha=0.5, linewidth=0.5, color='#379A8B')+
  geom_point(data=global_wind, aes(x=Year, y=Share, color=Data), alpha=0.6, size=1.5, shape=16)+
  scale_color_manual(values = c('Historical data'='black'), name=NULL)+
  ggnewscale::new_scale_color()+
  geom_pointrange(aes(ymin=q1, ymax=q3, color=Warming), position = position_dodge(width = 3), size=0.4)+
  scale_color_manual(values = warming_clrs, guide="legend", name="End-of-century warming\n(IPCC AR6 scenarios)")+
  guides(color=guide_legend(override.aes = list(alpha=1), ncol=1, byrow=TRUE, title.position="top"))+
  geom_star(data = wind_2030_target, aes(x=Year, y=Share, starshape=Data), size=2, alpha=0.9, fill='white')+
  scale_starshape_manual(values = c('Global Pledge on Renewables, COP28'=1), name=NULL)+
  guides(starshape=guide_legend(override.aes = list(alpha=1), byrow=TRUE, ncol=1, title.position="top"))+
  scale_alpha_continuous(range = c(0, 1)) +
  coord_cartesian(ylim = c(0,0.6), xlim = c(2020,2052))+
  scale_x_continuous(breaks = c(2020, 2025, 2030, 2035, 2040, 2045, 2050))+
  scale_y_continuous(labels = scales::percent)+
  theme_bw()+
  theme(panel.grid.minor = element_blank(), panel.grid.major.x = element_blank(), panel.grid.major.y = element_line(linewidth = 0.2),
        legend.position = "bottom",
        title = element_text(face="bold", size=8),
        plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines"),
        plot.title = element_text(hjust=0.5),
        legend.key.size = unit(8, 'pt'), #change legend key size
        legend.key.height = unit(3, 'pt'), #change legend key height
        legend.key.width = unit(6, 'pt'), #change legend key width
        legend.title = element_text(size=7), #change legend title font size
        legend.text = element_text(size=7))+
  labs(x=NULL, y="Share of electricity generation", title="Onshore wind")

ipcc_vs_proj_wind

p1 <- (ipcc_vs_proj_wind|ipcc_vs_proj_solar) + plot_layout(guides = "collect") & 
  theme(legend.position = "bottom", plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines"))

p1


#################################################################################

counterfactual_trajectories <- read_csv('data/input/counterfactual_trajectories.csv')

solar_counterfactuals <- counterfactual_trajectories %>% filter(Technology=="Solar PV")

wind_counterfactuals <- counterfactual_trajectories %>% filter(Technology=="Onshore wind")

counter_clrs <- c('Early acceleration, solar'= 'pink',
                  'Early acceleration, onshore wind' = '#a6d854',
                  'Late acceleration, solar' = '#fc8d62',
                  'Late acceleration, onshore wind'='#e78ac3')

ipcc_vs_counter_solar <- ggplot()+
  geom_ribbon(data = solar_proj, aes(x=Year, ymin=p05, ymax=p95), alpha=0.1, show.legend = FALSE, fill='#379A8B')+
  geom_ribbon(data = solar_proj, aes(x=Year, ymin=p25, ymax=p75), alpha=0.2, show.legend = FALSE, fill='#379A8B')+
  geom_point(data=global_solar, aes(x=Year, y=Share), alpha=0.6, size=1.5, shape=16, show.legend = FALSE)+
  geom_line(data = solar_counterfactuals, aes(x=Year, y=Deployment, color=Scenario), linewidth=0.6, linetype=6)+
  geom_line(data = wind_counterfactuals, aes(x=Year, y=Deployment, color=Scenario), linewidth=0.6, linetype=6, alpha=0)+
  scale_color_manual(values = counter_clrs, drop = FALSE, name="Scenario")+
  guides(color=guide_legend(override.aes = list(alpha=1), ncol=1, byrow=TRUE, title.position="top"))+
  geom_pointrange(data = ipcc_solar %>% filter(Warming=="<1.5ºC, no/limited overshoot"),
                  aes(x=Year, y=median, ymin=q1, ymax=q3), color='#3EBCD2', size=0.4, show.legend = FALSE)+
  scale_alpha_continuous(range = c(0, 1)) +
  geom_star(data = solar_2030_target, aes(x=Year, y=Share, starshape=Data), size=2, alpha=0.9, fill='white', show.legend = FALSE)+
  scale_starshape_manual(values = c('Global Pledge on Renewables, COP28'=1), name=NULL)+
  guides(starshape=guide_legend(override.aes = list(alpha=1), byrow=TRUE, nrow=1, title.position="top"))+
  coord_cartesian(ylim = c(0,0.6), xlim = c(2020,2050))+
  scale_x_continuous(breaks = c(2020, 2025, 2030, 2035, 2040, 2045, 2050))+
  scale_y_continuous(labels = scales::percent)+
  theme_bw()+
  theme(panel.grid.minor = element_blank(), panel.grid.major.x = element_blank(), panel.grid.major.y = element_line(linewidth = 0.2),
        legend.position = "bottom",
        title = element_text(face="bold", size=8),
        plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines"),
        legend.key.size = unit(12, 'pt'), #change legend key size
        legend.key.height = unit(10, 'pt'), #change legend key height
        legend.key.width = unit(10, 'pt'), #change legend key width
        legend.title = element_text(size=7), #change legend title font size
        legend.text = element_text(size=7))+
  labs(x=NULL, y=NULL, title=NULL)

ipcc_vs_counter_solar


ipcc_vs_counter_wind <- ggplot()+
  geom_ribbon(data = wind_proj, aes(x=Year, ymin=p05, ymax=p95), alpha=0.1, show.legend = FALSE, fill='#379A8B')+
  geom_ribbon(data = wind_proj, aes(x=Year, ymin=p25, ymax=p75), alpha=0.2, show.legend = FALSE, fill='#379A8B')+
  geom_point(data=global_wind, aes(x=Year, y=Share), alpha=0.6, size=1.5, shape=16, show.legend = FALSE)+
  ggnewscale::new_scale_color()+
  geom_line(data = wind_counterfactuals, aes(x=Year, y=Deployment, color=Scenario), linewidth=0.6, linetype=6, show.legend = FALSE)+
  geom_line(data = solar_counterfactuals, aes(x=Year, y=Deployment, color=Scenario), linewidth=0.6, linetype=6, alpha=0, show.legend = FALSE)+
  scale_color_manual(values = counter_clrs, drop = FALSE , name="Scenario")+
  guides(color=guide_legend(override.aes = list(alpha=1), nrow=1, byrow=TRUE, title.position="left"))+
  geom_pointrange(data = ipcc_wind %>% filter(Warming=="<1.5ºC, no/limited overshoot"),
                  aes(x=Year, y=median, ymin=q1, ymax=q3), color='#3EBCD2', size=0.4, show.legend = FALSE)+
  scale_alpha_continuous(range = c(0, 1)) +
  geom_star(data = wind_2030_target, aes(x=Year, y=Share, starshape=Data), size=2, alpha=0.9, fill='white', show.legend = FALSE)+
  scale_starshape_manual(values = c('Global Pledge on Renewables, COP28'=1), name=NULL)+
  guides(starshape=guide_legend(override.aes = list(alpha=1), byrow=TRUE, nrow=1, title.position="top"))+
  coord_cartesian(ylim = c(0,0.6), xlim = c(2020,2050))+
  scale_x_continuous(breaks = c(2020, 2025, 2030, 2035, 2040, 2045, 2050))+
  scale_y_continuous(labels = scales::percent)+
  theme_bw()+
  theme(panel.grid.minor = element_blank(), panel.grid.major.x = element_blank(), panel.grid.major.y = element_line(linewidth = 0.2),
        legend.position = "bottom",
        title = element_text(face="bold", size=8),
        plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines"),
        legend.key.size = unit(12, 'pt'), #change legend key size
        legend.key.height = unit(10, 'pt'), #change legend key height
        legend.key.width = unit(10, 'pt'), #change legend key width
        legend.title = element_text(size=7), #change legend title font size
        legend.text = element_text(size=7))+
  labs(x=NULL, y="Share of electricity generation", title=NULL)

ipcc_vs_counter_wind

p2 <- (ipcc_vs_counter_wind|ipcc_vs_counter_solar) + plot_layout(guides = "collect") & 
  theme(legend.position = "bottom", plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines"))


combined <- (ipcc_vs_proj_wind|ipcc_vs_proj_solar)/(ipcc_vs_counter_wind|ipcc_vs_counter_solar) + 
  plot_layout(guides = "collect") & 
  theme(legend.position = "bottom", plot.margin = unit(c(0.5, 0.5, 0.5, 0.5), "lines")) 

combined




