import bw2data as bd
import bw2calc as bc
from bw2data import databases
import pandas as pd

def create_exchange(act, db_name, mode, loc, mode_activity_dict, transport_distance_dict):
    code   = mode_activity_dict[mode]
    amount = transport_distance_dict[loc]['{} [km]'.format(mode)]/1000 #km to km for 1 kg in [ton kilometer]

    exc_dict = dict(input=(db_name, code),
                    output=(act['database'], act['code']),
                    amount=amount,
                    type='technosphere'
                   )
    return exc_dict

def get_background_database_name(act, databases, model='remind'):
    db_name = act['database']
    name    = act['name']
    try:
        scenario= db_name.replace('steel_prod_','')
        year    = name[-4:]
        background_db_name = '{0} - {1} - {2}'.format(model, scenario.replace('_{}'.format(year),''), year)
    except:
        db_name = 'ecoinvent 3.9 cutoff'
        print('New background database not found for {0}. Take {1} as default.'.format(s, db_name))

    if background_db_name not in databases:
        print(background_db_name)
    assert background_db_name in databases
    return background_db_name

def remove_technosphere(act):
    for exc in act.technosphere():
        exc.delete()
    act.save()

def write_transport_exchanges_to_act(act, mode_activity_dict, transport_distance_dict, loc_dict, databases, model='remind'):
    remove_technosphere(act)
    db_name = get_background_database_name(act, databases, model)

    print(act)
    print(db_name)
    print('-----------------------------------\n')
    
    for mode in mode_activity_dict.keys():
        loc = loc_dict[act['location']]
        exc_dict = create_exchange(act, db_name, mode, loc, mode_activity_dict, transport_distance_dict)
        act.new_exchange(**exc_dict).save()
    act.save()
    return act

def get_characterization_factors(series):
    series = series.dropna()
    cfs = list(zip([eval(idx) for idx in series.index],series))
    return cfs

def load_characterization_factors(method_tuple):

    method = bd.Method(method_tuple)
    cfs   = method.load()
    unit  = method.metadata['unit']
    descr = method.metadata['description']
    cf_df = pd.DataFrame(cfs, columns=['biosphere_flow',method_tuple]).set_index('biosphere_flow')
    return cf_df, unit, descr

def write_method(method_tuple, unit, description, cfs):
    bd.Method(method_tuple).register()
    met = bd.Method(method_tuple)
    met.metadata['unit'] = unit
    met.metadata['description'] = description
    #met.validate(cfs)
    met.write(cfs)

def get_model_ssp_year_name_rp(act):
    name  = act['name']
    rp    = act['reference product']
    model = name.split(' SSP')[0].split()[len(name.split(' SSP')[0].split())-1].lower()
    ssp   = 'SSP'+name.split(' SSP')[1].split(',')[0]
    year  = int(name[len(name)-4:])
    slag_mode = get_slag_mode(name)
    process   = get_process(name)
    return name, rp, model, ssp, year, slag_mode, process

def get_ext_year(met,name_year):
    try:
        return int(met[len(met)-1].split(', ')[1])
    except:
        return int(name_year)

def get_slag_mode(name):
    if 'optimistic' in name:
        return 'optimistic'
    elif 'pessimistic' in name:
        return 'pessimistic'
    else:
        return 'base'

def get_process(name):
    if 'converter' in name or 'primary' in name:
        return 'primary'
    elif 'electric' in name or 'secondary' in name:
        return 'secondary'
    else:
        raise Exception('Cannot assign primary or secondary', name)

def print_recursive_calculation(activity, lcia_method, lca_obj=None, total_score=None, amount=1, level=0, max_level=1, cutoff=1e-3, score_dict={}, exclude_keywords=[]):
        
    if lca_obj is None:
        lca_obj = bc.LCA({activity: amount}, lcia_method)
        lca_obj.lci()
        lca_obj.lcia()
        total_score = lca_obj.score
    elif total_score is None:
        raise ValueError
    else:
        lca_obj.redo_lcia({activity: amount})
        if abs(lca_obj.score) <= abs(total_score * cutoff):
            return

    
    further = True
    if not any([keyword in activity['name'] for keyword in exclude_keywords]):
        if activity['reference product'] in score_dict.keys():
            score_dict[activity['reference product']] += lca_obj.score
        else:
            score_dict[activity['reference product']] = lca_obj.score
        further = False
    elif level==0:
        score_dict[activity['name']] = lca_obj.score
            
    print("{}{:4.3f} ({:06.6f}): {:.70}".format("  " * level, lca_obj.score / total_score, lca_obj.score, str(activity)))

    if level < max_level and further:
        for exc in activity.technosphere():
            print_recursive_calculation(
                activity=exc.input, 
                lcia_method=lcia_method, 
                lca_obj=lca_obj, 
                total_score=total_score, 
                amount=amount * exc['amount'], 
                level=level + 1, 
                max_level=max_level, 
                cutoff=cutoff,
                score_dict=score_dict,
                exclude_keywords=exclude_keywords
            )
    return score_dict