function[mnScV,mxScV,...
         savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
         savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x,...
         xxv,xnv,xmv,xdv,nxv,nnv,nmv,ndv]...
         = mkPolyLineAll(mnSLATc,mnSLONc,mxSLATc,mxSLONc,SLAT,SLON,dic,ScV,SpV,...
                         pmLim,pxLim,drwEchCirc,elmOutArea,setOver,nCirlat,nCirlon,xCirlat,xCirlon,dspDat,dspDat_clr)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << min >>
arclenT = distance('gc',mnSLATc,mnSLONc,SLAT,SLON);
clear mtSLAT mtSLON
mtSLAT=SLAT(arclenT<=dic/2);
mtSLON=SLON(arclenT<=dic/2);
%--------------------------------------------------------------------------
nmtScV=ScV(arclenT<=dic/2);
cnScV=zeros(size(ScV));
cnScVn=zeros(size(ScV));
%--------------------------------------------------------------------------
iu=0;
%---------------------------
iuus55=0;
latUUs55=[];
lonUUs55=[];
%---------------------------
iuus60=0;
latUUs60=[];
lonUUs60=[];
%---------------------------
iuus65=0;
latUUs65=[];
lonUUs65=[];
%---------------------------
iuus70=0;
latUUs70=[];
lonUUs70=[];
%%
for i=1:length(mtSLAT)
    [tCirlat,tCirlon] = scircle1(mtSLAT(i),mtSLON(i),dic/2);
    
    if nmtScV(i)<=pmLim
        %------------------------------------------------------------------
        switch drwEchCirc
            case 'yes'
                if ~isempty(tCirlat)
                    gh15=plot3m(tCirlat,tCirlon,9000,'y-','linewidth',0.3);
                    gh15.Color(4) = 0.10;
                end
        end
        %------------------------------------------------------------------
        if nmtScV(i)<=-0.70
            [latUUs70,lonUUs70,iuus70]=mkPolyLine(latUUs70,lonUUs70,tCirlat,tCirlon,iuus70);
        end
        %------------------------------------------------------------------
        if nmtScV(i)<=-0.65
            [latUUs65,lonUUs65,iuus65]=mkPolyLine(latUUs65,lonUUs65,tCirlat,tCirlon,iuus65);
        end
        %------------------------------------------------------------------
        if nmtScV(i)<=-0.60
            [latUUs60,lonUUs60,iuus60]=mkPolyLine(latUUs60,lonUUs60,tCirlat,tCirlon,iuus60);
        end
        %------------------------------------------------------------------
        if nmtScV(i)<=-0.55
            [latUUs55,lonUUs55,iuus55]=mkPolyLine(latUUs55,lonUUs55,tCirlat,tCirlon,iuus55);
        end
        %------------------------------------------------------------------
        % p50
        if iu==0
            [latU,lonU]=polybool('union',tCirlat,tCirlon,tCirlat,tCirlon);
        else
            [latUt,lonUt]=polybool('union',latU,lonU,tCirlat,tCirlon);
            clear latU lonU
            latU=latUt;
            lonU=lonUt;
        end
        iu=iu+1;
        %------------------------------------------------------------------
        clear SLATt SLONt ScVt mnScV
        SLATt=SLAT;
        SLONt=SLON;
        ScVt=ScV;
        %------------------------------------------------------------------
        in=inpolygon(SLAT,SLON,tCirlat,tCirlon);
        switch elmOutArea
            case 'yes'
                ScVt(~in)=0;
        end
        ScVt(in)=nmtScV(i);
        %------------------------------------------------------------------
        switch setOver
            case 'Mean'
                cnScV=cnScV+ScVt;
            case 'MxMn'
                cnScVn=nanmin(cnScVn,ScVt);
        end
    end
end
%%
% p60
if ~isempty(latUUs60)
    gh852=plot3m(latUUs60,lonUUs60,10000,'b-','linewidth',6.0);
    gh852.Color(4) = 0.40;
end
%--------------------------------------------------------------------------
% p70
if ~isempty(latUUs70)
    gh854=plot3m(latUUs70,lonUUs70,10000,'b-','linewidth',8.0);
    gh854.Color(4) = 0.40;
end
%--------------------------------------------------------------------------
% min
[iix,jjx]=find(ScV==nanmin(ScV(ScV<=pmLim)));
textm(nanmin(nCirlat)+1,nanmean(nCirlon)-12,11000,...
    ['\rho_{min}=' num2str(nanmin(ScV(ScV<=pmLim)),'%+3.2f') ', pval=' num2str(SpV(iix,jjx),'%.1E')],...
    'color','k','fontsize',13,'FontName','d2coding');
%--------------------------------------------------------------------------
% t50
textm(13,nanmin(lonU)+2,11000,['\rho\leq' num2str(-0.50,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
%--------------------------------------------------------------------------
% t60
textm(nanmin(abs(latUUs60))+15,nanmin(lonUUs60)+7,11000,['\rho\leq' num2str(-0.60,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
%--------------------------------------------------------------------------
% t70
if ~isempty(latUUs70)
    %%textm(nanmin(latUUs70)+2,nanmean(lonUUs70),11000,['\rho\leq' num2str(-0.70,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
    textm(nanmin(latUUs70)-2,nanmean(lonUUs70),11000,['\rho\leq' num2str(-0.70,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
end
%% < sav CC<=-0.7 >
savLAT70n=latUUs70;
savLON70n=lonUUs70;
savLAT60n=latUUs60;
savLON60n=lonUUs60;
savLAT50n=latU;
savLON50n=lonU;
%% 
switch setOver
    case 'Mean'
        mnScV=cnScV./length(mtSLAT);
    case 'MxMn'
        mnScV=cnScVn;
end
%%
%**************************************************************************
% p50
if ~isempty(latU)
    gh6=plot3m(latU,lonU,10000,'b-','linewidth',4.0);
    gh6.Color(4) = 0.40;
end
%**************************************************************************
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << max >>
arclenT = distance('gc',mxSLATc,mxSLONc,SLAT,SLON);
clear mtSLAT mtSLON
mtSLAT=SLAT(arclenT<=dic/2);
mtSLON=SLON(arclenT<=dic/2);
%--------------------------------------------------------------------------
xmtScV=ScV(arclenT<=dic/2);
cxScV=zeros(size(ScV));
cxScVx=zeros(size(ScV));
%--------------------------------------------------------------------------
iu=0;
%---------------------------
iuus55=0;
latUUs55=[];
lonUUs55=[];
%---------------------------
iuus60=0;
latUUs60=[];
lonUUs60=[];
%---------------------------
iuus65=0;
latUUs65=[];
lonUUs65=[];
%---------------------------
iuus70=0;
latUUs70=[];
lonUUs70=[];
%---------------------------
iuus75=0;
latUUs75=[];
lonUUs75=[];

for i=1:length(mtSLAT)
    [tCirlat,tCirlon] = scircle1(mtSLAT(i),mtSLON(i),dic/2);
    
    if xmtScV(i)>=pxLim
        %------------------------------------------------------------------
        switch drwEchCirc
            case 'yes'
                if ~isempty(tCirlat)
                    gh16=plot3m(tCirlat,tCirlon,9000,'y-','linewidth',0.3);
                    gh16.Color(4) = 0.10;
                end
        end
        %------------------------------------------------------------------
        if xmtScV(i)>=0.70
            [latUUs70,lonUUs70,iuus70]=mkPolyLine(latUUs70,lonUUs70,tCirlat,tCirlon,iuus70);
        end
        %------------------------------------------------------------------
        if xmtScV(i)>=0.65
            [latUUs65,lonUUs65,iuus65]=mkPolyLine(latUUs65,lonUUs65,tCirlat,tCirlon,iuus65);
        end
        %------------------------------------------------------------------
        if xmtScV(i)>=0.60
            [latUUs60,lonUUs60,iuus60]=mkPolyLine(latUUs60,lonUUs60,tCirlat,tCirlon,iuus60);
        end
        %------------------------------------------------------------------
        if xmtScV(i)>=0.55
            [latUUs55,lonUUs55,iuus55]=mkPolyLine(latUUs55,lonUUs55,tCirlat,tCirlon,iuus55);
        end
        %------------------------------------------------------------------
        % p50
        if iu==0
            [latU,lonU]=polybool('union',tCirlat,tCirlon,tCirlat,tCirlon);
        else
            [latUt,lonUt]=polybool('union',latU,lonU,tCirlat,tCirlon);
            clear latU lonU
            latU=latUt;
            lonU=lonUt;
        end
        iu=iu+1;
        %------------------------------------------------------------------
        clear SLATt SLONt ScVt mxScV
        SLATt=SLAT;
        SLONt=SLON;
        ScVt=ScV;
        %------------------------------------------------------------------
        in=inpolygon(SLAT,SLON,tCirlat,tCirlon);
        switch elmOutArea
            case 'yes'
                ScVt(~in)=0;
        end
        ScVt(in)=xmtScV(i);
        %------------------------------------------------------------------
        switch setOver
            case 'Mean'
                cxScV=cxScV+ScVt;
            case 'MxMn'
                cxScVx=nanmax(cxScVx,ScVt);
        end
    end
end
%%
% p60
if ~isempty(latUUs60)
    gh862=plot3m(latUUs60,lonUUs60,10000,'r-','linewidth',6.0);
    gh862.Color(4) = 0.40;
end
%--------------------------------------------------------------------------
% p70
if ~isempty(latUUs70)
    gh864=plot3m(latUUs70,lonUUs70,10000,'r-','linewidth',8.0);
    gh864.Color(4) = 0.40;
end
%--------------------------------------------------------------------------
% max
[iix,jjx]=find(ScV==nanmax(ScV(ScV>=pxLim)));
textm(nanmin(xCirlat)+2,nanmean(xCirlon)-10,11000,...
    ['\rho_{max}=' num2str(nanmax(ScV(ScV>=pxLim)),'%+3.2f') ', pval=' num2str(SpV(iix,jjx),'%.1E')],...
    'color','k','fontsize',13,'FontName','d2coding');
%--------------------------------------------------------------------------
% t50
textm(8,nanmin(lonU)+9,11000,['\rho\geq' num2str(0.50,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
%--------------------------------------------------------------------------
% t60
textm(nanmin(abs(latUUs60))-4,nanmin(lonUUs60)+15,11000,['\rho\geq' num2str(0.60,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
%--------------------------------------------------------------------------
% t70
if ~isempty(latUUs70)
    textm(nanmean(latUUs70)-42,nanmin(lonUUs70)+25,11000,['\rho\geq' num2str(0.70,'%+3.1f')],'color','k','fontsize',13,'FontName','d2coding');
end
%% < sav CC>=0.7 >
savLAT70x=latUUs70;
savLON70x=lonUUs70;
savLAT60x=latUUs60;
savLON60x=lonUUs60;
savLAT50x=latU;
savLON50x=lonU;
%%
switch setOver
    case 'Mean'
        mxScV=cxScV./length(mtSLAT)*2;
    case 'MxMn'
        mxScV=cxScVx;
end
%%
%**************************************************************************
% p50
if ~isempty(latU)
    gh7=plot3m(latU,lonU,10000,'r-','linewidth',4.0);
    gh7.Color(4) = 0.40;
end
%**************************************************************************

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% 
switch dspDat
    case 'Area'
        mgScV=mnScV+mxScV;
        switch dspDat_clr
            case 'yes'
                gh11=surfm(SLAT-dil/2,SLON-dil/2,mgScV);
                alpha(gh11,.1)   % 0.8
        end
        mnScVz=mnScV;
        mxScVz=mxScV;
        mnScVz(mnScVz==0)=nan;
        mxScVz(mxScVz==0)=nan;
        xxv=nanmax(nanmax(mxScVz));
        xnv=nanmin(nanmin(mxScVz));
        xmv=nanmean(nanmean(mxScVz));
        xdv=nanmedian(nanmedian(reshape(mxScVz,size(mxScVz,1)*size(mxScVz,2),1)));
        nxv=nanmax(nanmax(mnScVz));
        nnv=nanmin(nanmin(mnScVz));
        nmv=nanmean(nanmean(mnScVz));
        ndv=nanmedian(nanmedian(reshape(mnScVz,size(mnScVz,1)*size(mnScVz,2),1)));
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

end
