%DxvA=[Dxv1u,Dxv3u,Dxv5u];
%VxvA=[Vxv1u,Vxv3u,Vxv5u];
% corrYN='uncorrect';
function []=dspCrossC2(DxvA,VxvA,corrYN,savDir,selPeriod,Rxy,lgB,lgT)
% <3 Plot U (uncorrect) >
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
box on
%-------------------------
grid on
ax = gca;
ax.GridColor = [.2 .2 .2];
ax.GridLineStyle = '--';
ax.GridAlpha = 0.8;
%-------------------------
set(ax,'TickDir','out')
set(ax,'TickDir','in')
%-------------------------
hold on
set(ax,'fontsize',18)
%--------------------------------------------------------------------------
%cDB={'k-','r-','b-','g-','m-','c-','k--','r--','b--','g--','m--','c--'};
lDB={'-','-','-','-','-','-','--','--','--','--','--','--'};
cDB={'k','r','b',rgbS('Goldenrod'),'m','c','k','r','b','g','m','c'};
if Rxy<2
    wDB=[4,2,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5,1.5];
else
    wDB=[5,2,2,2,2,2,2,2,2,2,2,2];
end
for i=1:size(DxvA,2)
    pltTyp='two';
    switch pltTyp
        case 'line'
            pxc1{i}=plot(DxvA(:,i),VxvA(:,i),'LineStyle',lDB{i},'Color',cDB{i+1},'linewidth',wDB(i),'markerfacecolor','white');
            pxc1{i}.Color(4)=.8;
        case 'bar'
            pxc1{i}=bar(DxvA(:,i),VxvA(:,i),cDB{i+1},'barwidth',1.0,'EdgeColor',cDB{i+1},'LineWidth',2);
            set(pxc1{i},'facealpha',.3)
        case 'two'
            if i==1
                pxc1{i}=bar(DxvA(:,i),VxvA(:,i),cDB{i+1},'barwidth',1.0,'EdgeColor',cDB{i+1},'LineWidth',2);
                set(pxc1{i},'facealpha',.3)
            else
                pxc1{i}=plot(DxvA(:,i),VxvA(:,i),'LineStyle',lDB{i},'Color',cDB{i+1},'linewidth',wDB(i),'markerfacecolor','white');
                pxc1{i}.Color(4)=.8;
            end
    end
end
%{
pxc1=plot(Dxv1u,Vxv1u,'k-','linewidth',5);
pxc3=plot(Dxv3u,Vxv3u,'r-','linewidth',5);
pxc5=plot(Dxv5u,-Vxv5u,'b-.','linewidth',5);
pxc1.Color(4)=.6;
pxc3.Color(4)=.6;
pxc5.Color(4)=.6;
%}
%--------------------------------------------------------------------------
for ik=1:length(DxvA)
    if rem(DxvA(ik,1),16)==0
            %plot(DxvA(ik,1),VxvA(ik,1)+0.1,'*','color','k','markersize',8);
            plot(DxvA(ik,1),0.7,'*','color','k','markersize',8);
    end
end
%--------------------------------------------------------------------------
if strcmp(lgB,'NVOL(W)_USDX')
    lgT={lgT,lgT,lgT,lgT,lgT,lgT,lgT,lgT};
else
    lgT={'PDO','-SOI','PZI','-TMX','PRE','OHC','SLA','CO2'};
end
%--------------------------------------------------------------------------
ix0=find(DxvA(:,1)==0);
for i=1:size(DxvA,2)
    if i<size(DxvA,2)
        if strcmp(lgB,'NVOL(W)_USDX')
            text(ax,-43+(i-1)*19.7*(2/Rxy),0.89,['\rho_{' [lgB(1:7) ' vs ' lgT{1}] '}=' num2str(VxvA(ix0,i),'%3.2f') ', '],'color',rgbS('black'),'fontsize',14,'FontName','d2coding');
        else
            text(ax,-43+(i-1)*10.7*(2/Rxy),0.89,['\rho_{' lgT{i} '}=' num2str(VxvA(ix0,i),'%3.2f') ', '],'color',rgbS('black'),'fontsize',14,'FontName','d2coding');
        end
    else
        if strcmp(lgB,'NVOL(W)_USDX')
            text(ax,-43+(i-1)*19.7*(2/Rxy),0.89,['\rho_{' [lgB(9:end) ' vs ' lgT{1}] '}=' num2str(VxvA(ix0,i),'%3.2f')],'color',rgbS('black'),'fontsize',14,'FontName','d2coding');
        else
            text(ax,-43+(i-1)*10.7*(2/Rxy),0.89,['\rho_{' lgT{i} '}=' num2str(VxvA(ix0,i),'%3.2f')],'color',rgbS('black'),'fontsize',14,'FontName','d2coding');
        end
    end
end

%--------------------------------------------------------------------------
set(ax,'xtick',[-48:8:48])
set(ax,'ytick',[-0.8:0.2:0.8])
xlim([-45 45])
ylim([-0.8 0.8])
%--------------------------------------------------------------------------
%lgB='NVOL(W)';
if strcmp(lgB,'NVOL(W)')
lgA={[lgB ' (\rho_{max}) vs ' lgT{1}],...
     [lgB ' (\rho_{max}) vs ' lgT{2}],...
     [lgB ' (\rho_{max}) vs ' lgT{3}],...
     [lgB ' (\rho_{max}) vs ' lgT{4}],...
     [lgB ' (\rho_{max}) vs ' lgT{5}],...
     [lgB ' (\rho_{max}) vs ' lgT{6}],...
     [lgB ' (\rho_{max}) vs ' lgT{7}],...
     [lgB ' (\rho_{max}) vs ' lgT{8}]};
elseif strcmp(lgB,'NVOL(E)')
lgA={[lgB ' (\rho_{min}) vs ' lgT{1}],...
     [lgB ' (\rho_{min}) vs ' lgT{2}],...
     [lgB ' (\rho_{min}) vs ' lgT{3}],...
     [lgB ' (\rho_{min}) vs ' lgT{4}],...
     [lgB ' (\rho_{min}) vs ' lgT{5}],...
     [lgB ' (\rho_{min}) vs ' lgT{6}],...
     [lgB ' (\rho_{min}) vs ' lgT{7}],...
     [lgB ' (\rho_{min}) vs ' lgT{8}]};
elseif strcmp(lgB,'NVOL(W)_USDX')
lgA={[lgB(1:7) ' (\rho_{max}) vs ' lgT{1}],...
     [lgB(9:end) ' vs ' lgT{1}]};
else
lgA={[lgB ' vs ' lgT{1}],...
     [lgB ' vs ' lgT{2}],...
     [lgB ' vs ' lgT{3}],...
     [lgB ' vs ' lgT{4}],...
     [lgB ' vs ' lgT{5}],...
     [lgB ' vs ' lgT{6}],...
     [lgB ' vs ' lgT{7}],...
     [lgB ' vs ' lgT{8}]};
end
%legend([pxc1{1},pxc1{2},pxc1{3}],lgA{1:size(DxvA,2)},'FontSize',12)
if Rxy<2
    if strcmp(lgB,'NVOL(W)_USDX')
    legend(lgA(1:size(DxvA,2)),'FontSize',14,'Location','southeast','NumColumns',1)
    else
    legend(lgA(1:size(DxvA,2)),'FontSize',14,'Location','southeast','NumColumns',2)
    end
else
    if strcmp(lgB,'NVOL(W)_USDX')
    legend(lgA(1:size(DxvA,2)),'FontSize',14,'Location','southeast','NumColumns',1)
    else
    legend(lgA(1:size(DxvA,2)),'FontSize',14,'Location','southeast','NumColumns',3)
    end
end
xlabel('Lag (year)');
ylabel('Cross correlation coefficient');
%--------------------------------------------------------------------------
pbaspect(ax,[Rxy 1 1])
%--------------------------------------------------------------------------
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes
ax1 = axes('Position',ax1_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');
ax1.XColor = 'k';
ax1.YColor = 'k';
hold on; box on; %grid on
set(ax1,'fontsize',18)
set(ax1,'TickDir','in')
set(ax1,'TickDir','out')
set(ax1,'xtick',[-48:8:48])
set(ax1,'ytick',[-0.8:0.2:0.8])
set(ax1,'xticklabel',[])
set(ax1,'yticklabel',[])
xlim([-45 45])
ylim([-0.8 0.8])
%--------------------------------------------------------------------------
pbaspect(ax1,[Rxy 1 1])
%--------------------------------------------------------------------------
if strcmp(corrYN,'correct_sz')
    if strcmp(lgB,'NVOL(W)')
        ftg='3(b)';
    elseif strcmp(lgB,'USDX')
        ftg='3(d)';
    elseif strcmp(lgB,'NVOL(W)_USDX')
        if strcmp(lgT,'-SOI')
        ftg='S7(c)';
        else
        ftg='3(c)';
        end
    end        
elseif strcmp(corrYN,'uncorrect_sz')
    if strcmp(lgB,'NVOL(W)')
        ftg='3(a)';
    elseif strcmp(lgB,'USDX')
        ftg='3(c)';
    elseif strcmp(lgB,'NVOL(W)_USDX')
        if strcmp(lgT,'-SOI')
        ftg='S7(b)';
        else
        ftg='3(b)';
        end
    end        
end
%--------------------------------------------------------------------------
set(gcf,'units','centimeters','position',[0 0 15*Rxy 16],...
    'paperposition',[0 0 15*Rxy 16]);
print(gcf,'-dpng','-r800',[savDir 'Fig.' ftg '.png'])
close(gcf)
end