function [savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
 savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x,...
 xxv,xnv,xmv,xdv,nxv,nnv,nmv,ndv]...
 =drwWMAP(GLoc,minLATm,maxLATm,SLAT,SLON,dil,ScV,SpV,mapP,drwEL,minLON,...
 mnSLAT,mnSLON,Nshpx,mxSLAT,mxSLON,Pshpx,... 
 dic,Pshp,Nshp,Pshpf,Nshpf,...
 sstXYlS,sstXYyS,...
 Vshp,mkredgclr,mkrfceclr,...
 mnSLATc,mnSLONc,pmLim,mxSLATc,mxSLONc,pxLim,drwEchCirc,elmOutArea,setOver,srtY,...
 savTXT,dspDat,landColor,oceanColor,dspDat_clr,cntTyp,setCmap)

%%
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.4]);
%%
subplot_tight(1,1,1,[0.05,0.05])
%%
switch GLoc
    case 'ALL'
        mLL=[10 370];
        FLL=[10 370]; 
    case 'WEST'
        mLL=[10 190];
        FLL=[10 190];
    case 'EAST'
        mLL=[190 370];
        FLL=[190 370];
end
%--------------------------------------------------------------------------
axesm(mapP,'grid','on',...    
      'maplatlimit',[minLATm maxLATm],'maplonlimit',mLL,...
      'FLatLimit',[minLATm maxLATm],'FLonLimit',FLL,...
      'FLineWidth',6,'fontsize',11); 
%--------------------------------------------------------------------------
tightmap;  
framem
%--------------------------------------------------------------------------
xLoc = -3.21e5;
yLoc = 2.00e6;
scaleruler on
setm(handlem('scaleruler1'), ...
    'Units', 'km', 'RulerStyle', 'patches',  ...
    'XLoc', xLoc, 'YLoc', yLoc,'MajorTick',0:1000:2000,'TickMode','manual');
%%
switch dspDat
    case 'CPnt'
        gh1=surfm(SLAT-dil/2,SLON-dil/2,ScV);                        
        alpha(gh1,0.95)
end
%%
setm(gca, 'MlabelLocation', 20, 'PlabelLocation',20,...
          'MLabelParallel','north', ...
          'MeridianLabel','on', 'ParallelLabel','on',...
          'MlineLocation',20, 'PlineLocation',20)
hold on; 
%%
v= ver('MATLAB'); 
if v.Release=="(R2020b)"
    load coastlines;
    lat=coastlat;
    long=coastlon;
else
    load coast;
end
p01=geoshow(lat,long,'DisplayType','polygon','facecolor',landColor); % upperleft
setm(gca, 'FFaceColor', oceanColor)
%%
drwELarea_F(drwEL,GLoc,'yes');
%%
if ~isempty(mnSLAT)
    p30=plot3m(mnSLAT,mnSLON,12000, Nshpx,'color','k','markersize',8,'linewidth',2);
    p30.Color(4) = 0.70;
end
%--------------------------------------------------------------------------
if ~isempty(mxSLAT)
    p31=plot3m(mxSLAT,mxSLON,12000, Pshpx,'color','k','markersize',8,'linewidth',2);
    p31.Color(4) = 0.70;
end
%--------------------------------------------------------------------------
% max area
[nCirlat,nCirlon] = scircle1(mnSLAT,mnSLON,dic/2);
if ~isempty(nCirlat)
    %gh4=plot3m(nCirlat,nCirlon,12000,'k-','linewidth',10);
    gh4=plot3m(nCirlat,nCirlon,12000,'k--','linewidth',5);
    gh4.Color(4) = 0.40;
end
%--------------------------------------------------------------------------
[xCirlat,xCirlon] = scircle1(mxSLAT,mxSLON,dic/2);
if ~isempty(xCirlat)
    %gh5=plot3m(xCirlat,xCirlon,12000,'k-','linewidth',10);
    gh5=plot3m(xCirlat,xCirlon,12000,'k--','linewidth',5);
    gh5.Color(4) = 0.40;
end
%--------------------------------------------------------------------------

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
[mnScV,mxScV,...
 savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
 savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x,...
         xxv,xnv,xmv,xdv,nxv,nnv,nmv,ndv]...
 = mkPolyLineAll(mnSLATc,mnSLONc,mxSLATc,mxSLONc,SLAT,SLON,dic,ScV,SpV,...
                 pmLim,pxLim,drwEchCirc,elmOutArea,setOver,nCirlat,nCirlon,xCirlat,xCirlon,dspDat,dspDat_clr);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%%
switch cntTyp
    case 'eql'
        plot3m(SLAT(ScV>=pxLim),SLON(ScV>=pxLim),10000, Pshp,'color','r','markersize',2.3*dil*Pshpf,'linewidth',0.5);
        plot3m(SLAT(ScV<=pmLim),SLON(ScV<=pmLim),10000, Nshp,'color','b','markersize',2.3*dil*Nshpf,'linewidth',0.5);
    case 'wgt'
        %------------------------------------------------------------------
        if ~isempty(SLAT(ScV>=0.50 & ScV<0.55))
            plot3m(SLAT(ScV>=0.50 & ScV<0.55),SLON(ScV>=0.50 & ScV<0.55),10000, Pshp,'color','r','markersize',1.4*dil*Pshpf,'linewidth',0.5);
        end
        if ~isempty(SLAT(ScV>=0.60 & ScV<0.65))
            plot3m(SLAT(ScV>=0.60 & ScV<0.65),SLON(ScV>=0.60 & ScV<0.65),10000, Pshp,'color','r','markersize',1.7*dil*Pshpf,'linewidth',1.2);
        end
        if ~isempty(SLAT(ScV>=0.70))
            plot3m(SLAT(ScV>=0.70),SLON(ScV>=0.70),10000, Pshp,'color','r','markersize',2.1*dil*Pshpf,'linewidth',1.8);
        end
        %------------------------------------------------------------------
        if ~isempty(SLAT(ScV>-0.55 & ScV<=-0.50))
            plot3m(SLAT(ScV>-0.55 & ScV<=-0.50),SLON(ScV>-0.55 & ScV<=-0.50),10000, Nshp,'color','b','markersize',1.4*dil*Nshpf,'linewidth',0.5);
        end
        if ~isempty(SLAT(ScV>-0.65 & ScV<=-0.60))
            plot3m(SLAT(ScV>-0.65 & ScV<=-0.60),SLON(ScV>-0.65 & ScV<=-0.60),10000, Nshp,'color','b','markersize',1.7*dil*Nshpf,'linewidth',1.2);
        end
        if ~isempty(SLAT(ScV<=-0.70))
            plot3m(SLAT(ScV<=-0.70),SLON(ScV<=-0.70),10000, Nshp,'color','b','markersize',2.1*dil*Nshpf,'linewidth',1.8);
        end
        %{
        %------------------------------------------------------------------
        if ~isempty(SLAT(round(ScV,1)>=0.50 & round(ScV,1)<0.60))
            plot3m(SLAT(round(ScV,1)>=0.50 & round(ScV,1)<0.60),SLON(round(ScV,1)>=0.50 & round(ScV,1)<0.60),10000, Pshp,'color','r','markersize',1.4*dil*Pshpf,'linewidth',0.5);
        end
        if ~isempty(SLAT(round(ScV,1)>=0.60 & round(ScV,1)<0.70))
            plot3m(SLAT(round(ScV,1)>=0.60 & round(ScV,1)<0.70),SLON(round(ScV,1)>=0.60 & round(ScV,1)<0.70),10000, Pshp,'color','r','markersize',1.7*dil*Pshpf,'linewidth',1.2);
        end
        if ~isempty(SLAT(round(ScV,1)>=0.70))
            plot3m(SLAT(round(ScV,1)>=0.70),SLON(round(ScV,1)>=0.70),10000, Pshp,'color','r','markersize',2.1*dil*Pshpf,'linewidth',1.8);
        end
        %------------------------------------------------------------------
        if ~isempty(SLAT(round(ScV,1)>-0.60 & round(ScV,1)<=-0.50))
            plot3m(SLAT(round(ScV,1)>-0.60 & round(ScV,1)<=-0.50),SLON(round(ScV,1)>-0.60 & round(ScV,1)<=-0.50),10000, Nshp,'color','b','markersize',1.4*dil*Nshpf,'linewidth',0.5);
        end
        if ~isempty(SLAT(round(ScV,1)>-0.70 & round(ScV,1)<=-0.60))
            plot3m(SLAT(round(ScV,1)>-0.70 & round(ScV,1)<=-0.60),SLON(round(ScV,1)>-0.70 & round(ScV,1)<=-0.60),10000, Nshp,'color','b','markersize',1.7*dil*Nshpf,'linewidth',1.2);
        end
        if ~isempty(SLAT(round(ScV,1)<=-0.70))
            plot3m(SLAT(round(ScV,1)<=-0.70),SLON(round(ScV,1)<=-0.70),10000, Nshp,'color','b','markersize',2.1*dil*Nshpf,'linewidth',1.8);
        end
        %}
end
%--------------------------------------------------------------------------
cntPlus='HiCCarea';
switch cntPlus
    case 'Global'
    case 'HiCCarea'
        % only sel circle area
        xGA=sum(SLAT(mxScV>=pxLim).*mxScV(mxScV>=pxLim))/sum(mxScV(mxScV>=pxLim))
        xGO=sum(SLON(mxScV>=pxLim).*mxScV(mxScV>=pxLim))/sum(mxScV(mxScV>=pxLim))
        nGA=sum(SLAT(mnScV<=pmLim).*mnScV(mnScV<=pmLim))/sum(mnScV(mnScV<=pmLim))
        nGO=sum(SLON(mnScV<=pmLim).*mnScV(mnScV<=pmLim))/sum(mnScV(mnScV<=pmLim))
end
%--------------------------------------------------------------
if ~isempty(nGA)
    gh200=plot3m(nGA,nGO,12000, Nshpx,'color','b','markersize',14,'linewidth',3);
    gh200.Color(4) = 0.30;
end
if ~isempty(xGA)
    gh211=plot3m(xGA,xGO,12000, Pshpx,'color','r','markersize',14,'linewidth',3);
    gh211.Color(4) = 0.30;
end
%%
switch setCmap
    case 'jet'
        colormap(jet(32))
    case 'RnB'
        %------------------------------------
        Red=flipud(brewermap(8,'*Reds'));
        Blu=brewermap(8,'*Blues');
        RB=[Blu;Red];
        colormap(RB)
end
%%
drwCbar='no';
switch drwCbar
    case 'yes'
        t=colorbar('southoutside');
        a=get(t);
        a=a.Position;
        set(t,'Position',[a(1) a(2)-0.1 0.50 0.01]);
        %--------------------------------------------------
        caxis([-0.8 0.8])
        set(t,'fontsize',10);
        xlabel(t,'Correlation coefficient','fontsize',10)
end
%%
MGA01=[0,0,0];
MGO01=[0,0,0];
%+++++++++++
MGA02=[10,10,10];
MGO02=[0,0,0];
%+++++++++++
MGA03=[5,5,5];
MGO03=[-1,-1,-1];
%+++++++++++
MGA04=[23,16,16];
MGO04=[3+5,9,9];
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MGA05=[17.5,17.5-5,17.5-5];
MGO05=[2,2-81-30,2+3+22];
%+++++++++++
MGA06=[14,14-5,14-5];
MGO06=[-1,-1-81-30,-1+3+22];
%+++++++++++
MGA07=[8.5,8.5-3,8.5-3];
MGO07=[2,2-81-30,2+3+22];
%+++++++++++
MGA08=[5,5-2,5-2];
MGO08=[-1,-1-81-30,-1+3+22];
%+++++++++++
MGA09=[23,23-7,16];
MGO09=[3+47+5,3+47-65-81-30+5,3+47+52+12+22];
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MBX1=[-190,-260,-130];
MBX2=[-145,-215,-88];
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
bLA1=[0,0,0];
bLA2=[19,14,14];
bLA3=[19,14,14];
bLA4=[0,0,0];
bLA5=[0,0,0];
%+++++++++++
bLO1=[3-5,1-5,-5+1];
bLO2=[3-5,1-5,-5+1];
bLO3=[50-5,52-5,-5+52];
bLO4=[50-5,52-5,-5+52];
bLO5=[3-5,1-5,-5+1];
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
aLA1=[0,0,0];
aLA2=[19,19-5,19-5];
aLA3=[19,19-5,19-5];
aLA4=[0,0,0];
aLA5=[0,0,0];
%+++++++++++
aLO1=[3+47-10,-23-5-81-30,102+22];
aLO2=[3+47-10,-23-5-81-30,102+22];
aLO3=[35+47-10,-23+30-5-81-30,132+22];
aLO4=[35+47-10,-23+30-5-81-30,132+22];
aLO5=[3+47-10,-23-5-81-30,102];
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
switch GLoc
    case 'ALL'
        drwMARK(sstXYlS,sstXYyS,srtY,Vshp,mkredgclr,mkrfceclr,minLATm,Nshp,dil,Nshpf,Pshp,Pshpf,minLON,...
            MGA01(1),MGO01(1),MGA02(1),MGO02(1),MGA03(1),MGO03(1),MGA04(1),MGO04(1),MGA05(1),MGO05(1),MGA06(1),MGO06(1),MGA07(1),MGO07(1),MGA08(1),MGO08(1),MGA09(1),MGO09(1),MBX1(1),MBX2(1),...
            bLA1(1),bLA2(1),bLA3(1),bLA4(1),bLA5(1),bLO1(1),bLO2(1),bLO3(1),bLO4(1),bLO5(1),...
            aLA1(1),aLA2(1),aLA3(1),aLA4(1),aLA5(1),aLO1(1),aLO2(1),aLO3(1),aLO4(1),aLO5(1),...
            nCirlat,nCirlon,xCirlat,xCirlon,...
            savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
            savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x)
    case 'WEST'
        drwMARK(sstXYlS,sstXYyS,srtY,Vshp,mkredgclr,mkrfceclr,minLATm,Nshp,dil,Nshpf,Pshp,Pshpf,minLON,...
            MGA01(2),MGO01(2),MGA02(2),MGO02(2),MGA03(2),MGO03(2),MGA04(2),MGO04(2),MGA05(2),MGO05(2),MGA06(2),MGO06(2),MGA07(2),MGO07(2),MGA08(2),MGO08(2),MGA09(2),MGO09(2),MBX1(2),MBX2(2),...
            bLA1(2),bLA2(2),bLA3(2),bLA4(2),bLA5(2),bLO1(2),bLO2(2),bLO3(2),bLO4(2),bLO5(2),...
            aLA1(2),aLA2(2),aLA3(2),aLA4(2),aLA5(2),aLO1(2),aLO2(2),aLO3(2),aLO4(2),aLO5(2),...
            nCirlat,nCirlon,xCirlat,xCirlon,...
            savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
            savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x)
    case 'EAST'
        drwMARK(sstXYlS,sstXYyS,srtY,Vshp,mkredgclr,mkrfceclr,minLATm,Nshp,dil,Nshpf,Pshp,Pshpf,minLON,...
            MGA01(3),MGO01(3),MGA02(3),MGO02(3),MGA03(3),MGO03(3),MGA04(3),MGO04(3),MGA05(3),MGO05(3),MGA06(3),MGO06(3),MGA07(3),MGO07(3),MGA08(3),MGO08(3),MGA09(3),MGO09(3),MBX1(3),MBX2(3),...
            bLA1(3),bLA2(3),bLA3(3),bLA4(3),bLA5(3),bLO1(3),bLO2(3),bLO3(3),bLO4(3),bLO5(3),...
            aLA1(3),aLA2(3),aLA3(3),aLA4(3),aLA5(3),aLO1(3),aLO2(3),aLO3(3),aLO4(3),aLO5(3),...
            nCirlat,nCirlon,xCirlat,xCirlon,...
            savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
            savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x)
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

whitebg(gcf,'w');
%--------------------------------------------------------------------------
set(gcf,'units','centimeters','position',[0 0 51 20],...
    'paperposition',[0 0 51 20]);
print(gcf,'-dpng','-r600',savTXT)
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%


