function []=drwLineBoxLAGR_21(xmdUDn,xmdNVn,mnVV,mdPDO,lgPDO,dspEL,Tname,savDir,TimeLag)
%% << detrend ma3 norm lag-1 3cp box >>
YRR=[1968:2018];
%%
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
%%
subplot_tight(1,1,1,[0.07,0.07])
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes
%-----------------------------------------------
hold on; box on; %grid on
set(ax2,'fontsize',12)
%%
%--------------------------------------------------------------------------
set(ax2,'TickDir','out')
%----------------------------------------------------
xlabel(ax2,['Year_{USDX}']);
ylabel(ax2,['Detrended USDX']);
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[-3.5 3.5]+0.5;
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
%axis(ax2,[1967 2020 yna(1) yna(2)])
%xlim(ax2,[1967 2020])
switch TimeLag
    case 'yr1'
        axis(ax2,[1968 2021 yna(1) yna(2)])
        xlim(ax2,[1968 2021])
    case 'yr0'
        axis(ax2,[1967 2020 yna(1) yna(2)])
        xlim(ax2,[1967 2020])
end
%--------------------------------------------------------------------------
pbaspect([2.5 1 1])
%%
%%
% <NVOL>
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes
ax1 = axes('Position',ax1_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');
ax1.XColor = 'k';
ax1.YColor = 'k';
%--------------------------------------------------------------------------
hold on; box on; %grid on
set(ax1,'fontsize',12)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
% <NVOL>
h31011=bar(ax1,YRR',xmdNVn,'FaceColor',rgbS('Red'),'EdgeColor','none','barwidth',1.0,'linewidth',0.7);
set(h31011,'facealpha',.5)
% USDX
switch TimeLag
    case 'yr1'
        yUD=YRR+1;
    case 'yr0'
        yUD=YRR;
end
p13012=bar(ax2,yUD',xmdUDn,'FaceColor',rgbS('Navy'),'EdgeColor','none','barwidth',1.0,'linewidth',0.7);
set(p13012,'facealpha',.3)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
set(ax1,'TickDir','in')
%--------------------------------------------------------------------------
xna=yna;
%--------------------------------------------------------------------------
%%
switch dspEL
    case {'yes','yes2014'}
        %--------------------------------------------------------------------------
        % < El nino >
        sx1=[1982 1982 1984 1984 1982];
        sy1=[-4 4 4 -4 -4];
        p123=fill(ax1,sx1,sy1,'m');
        set(p123,'facealpha',.5)
        %--------------------------------------
        hh21 = hatchfill(p123, 'single', 45, 3);
        set([p123], 'LineStyle', 'none')  % Remove outline
        set(hh21, 'Color', 'm')           % Change the cross hatch to white
        %------------------------------------------------------------
        sx2=[1997 1997 1999 1999 1997];
        sy2=[-4 4 4 -4 -4];
        p223=fill(ax1,sx2,sy2,'m');
        set(p223,'facealpha',.3)
        %--------------------------------------
        hh22 = hatchfill(p223, 'single', 45, 3);
        set([p223], 'LineStyle', 'none')  % Remove outline
        set(hh22, 'Color', 'm')           % Change the cross hatch to white
        %------------------------------------------------------------
        switch dspEL
            case 'yes2014'
                sx3=[2014 2014 2017 2017 2014];
            otherwise
                sx3=[2015 2015 2017 2017 2015];
        end
sy3=[-4 4 4 -4 -4];
p323=fill(ax1,sx3,sy3,'m');
set(p323,'facealpha',.3)
%--------------------------------------
hh23 = hatchfill(p323, 'single', 45, 3);
set([p323], 'LineStyle', 'none')  % Remove outline
set(hh23, 'Color', 'm')           % Change the cross hatch to white
%--------------------------------------------------------------------------
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
% <PDO>
%--------------------------------------------------------------------------
ex4=YRR';
ey4=mdPDO';
%----------------------------------------------------------
% org
%dspPDOtyp='bar';
dspPDOtyp='line';
switch dspPDOtyp
    case 'bar'
        h310=bar(ax1,ex4,ey4,'FaceColor',rgbS('Navy'),'barwidth',0.5,'linewidth',0.5);
        set(h310,'facealpha',.3)
    case 'line'
        h310=plot(ax1,ex4,ey4,'-o','color',rgbS('Black'),'linewidth',1,'markersize',4,'markerfacecolor','w');
        h310.Color(4)=0.7;
end

set(ax1,'TickDir','in')
xlabel(ax1,['Year_{NVOL & ' lgPDO '}']);
ylabel(ax1,['Detrended NVOL & ' lgPDO]);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
dsp1986='no';
switch dsp1986
    case 'yes'
        % <1986-1992>
        % vertical
        hl3=plot([1986 1986],[0 4],'Color',rgbS('black'),'LineStyle','--','linewidth',0.5);
        hl3.Color(4)=0.7;
        hl3=plot([1992 1992],[0 4],'Color',rgbS('black'),'LineStyle','--','linewidth',0.5);
        hl3.Color(4)=0.7;
        % horizontal
        p4554124=plot(ax1,[1986:1992],3*ones(size([1986:1992])),'-','color',rgbS('black'),'linewidth',0.5);
        p4554124.Color(4)=0.5;
        p4554124=plot(ax1,[1986]+0.3,3*ones(size(1986)),'<','color',rgbS('black'),'linewidth',0.5);
        p4554124=plot(ax1,[1992]-0.3,3*ones(size(1992)),'>','color',rgbS('black'),'linewidth',0.5);
        % volvano
        p4554124=plot(ax1,[1985],3*ones(size(1985)),'*','color',rgbS('black'),'markersize',10);
        p4554124=text(ax1,[1985]-6.5,2.7*ones(size(1985)),'Nevado del Ruiz (VEI3)','color',rgbS('black'),'fontsize',8,'FontName','d2coding');
end
%--------------------------------------------------------------------------
% <1992-2003>
% vertical
hl3=plot([1992 1992],[0 4],'Color',rgbS('black'),'LineStyle','--','linewidth',0.5);
hl3.Color(4)=0.7;
hl3=plot([2003 2003],[0 4],'Color',rgbS('black'),'LineStyle','--','linewidth',0.5);
hl3.Color(4)=0.7;
% horizontal
p4554124=plot(ax1,[1992:2003],1.9*ones(size([1992:2003])),'-','color',rgbS('black'),'linewidth',0.5);
p4554124.Color(4)=0.5;
p4554124=plot(ax1,[1992]+0.3,1.9*ones(size(1992)),'<','color',rgbS('black'),'linewidth',0.5);
p4554124=plot(ax1,[2003]-0.3,1.9*ones(size(2003)),'>','color',rgbS('black'),'linewidth',0.5);
% volvano
%{
p4554124=plot(ax1,[1991],3*ones(size(1991)),'*','color',rgbS('black'),'markersize',10);
p4554124=text(ax1,[1991]-4.5,2.7*ones(size(1991)),'Pinatubo (VEI6)','color',rgbS('black'),'fontsize',8,'FontName','d2coding');
%}
%%
% < 1992-2003 >
idx92=find(YRR==1992);
idx03=find(YRR==2003);
%--------------------------------------------------------------------------
% < NVOL vs PDO >
[cVV,pVV]=corr(xmdNVn(idx92:idx03),ey4(idx92:idx03)')
%p4554124b=text(ax1,[1992]+0.1,2.9*ones(size(1992)),['\rho_{NVOL vs ' lgPDO '_{1992~2003}}=' num2str(cVV,'%+3.2f') '_{(' num2str(pVV,'%3.3f') ')}'],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
p4554124b=text(ax1,[1992]+0.1,2.9*ones(size(1992)),['\rho_{NVOL vs ' lgPDO '_{1992~2003}}=' num2str(cVV,'%+3.2f')],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
%% <1992-2003>
% < CC all applying reverse of 1992-2003 >
ey4r=ey4;
ey4r(idx92:idx03)=-ey4(idx92:idx03);
[cVV1,pVV1]=corr(xmdNVn,ey4')      % NVOL vs POD
[cVV1r,pVV1r]=corr(xmdNVn,ey4r')    % NVOL vs PODr
%------------------------------------------------
% < CC all exclude the 1992-2003 > 
idxEX9203=[1:idx92-1,idx03+1:length(YRR)];
ey4x=ey4(idxEX9203);
[cVV1x,pVV1x]=corr(xmdNVn(idxEX9203),ey4x')                         % NVOL vs POD
%--------------------------------------------------------------------------
% < All >
%pa3=text(ax1,[1967]+0.5,2.9*ones(size(1967)),['\rho_{NVOL vs ' lgPDO '^{a}} =' num2str(cVV1,'%+3.2f') '_{(' num2str(pVV1,'%3.3f') ')}'],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
pa3=text(ax1,[1967]+0.5,3.4*ones(size(1967)),['\rho_{NVOL vs ' lgPDO '^{1967~2020}} =' num2str(cVV1,'%+3.2f')],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
%------------------------------------------------
% < ~1991 & 2004~ > 
%pa3x=text(ax1,[1981]-1.0,2.9*ones(size(1981)),['\rho_{NVOL vs ' lgPDO '^{x}} =' num2str(cVV1x,'%+3.2f') '_{(' num2str(pVV1x,'%3.3f') ')}'],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
%------------------------------------------------
% < All (1992-2003 reversed) >
%pa4=text(ax1,[2005]-0.5,2.9*ones(size(2005)),['\rho_{NVOL vs ' lgPDO '^{r}} =' num2str(cVV1r,'%+3.2f') '_{(' num2str(pVV1r,'%3.3f') ')}'],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
pa4=text(ax1,[1967]+0.5,2.9*ones(size(1967)),['\rho_{NVOL vs ' lgPDO '^{1967~2020 (reversed 1992~2003)}} =' num2str(cVV1r,'%+3.2f')],'color',rgbS('black'),'fontsize',11.5,'FontName','d2coding');
%%
axis(ax1,[1967 2020 xna(1) xna(2)])
xlim(ax1,[1967 2020])
%--------------------------------------------------------------------------
pbaspect([2.5 1 1])
%%
legend([h31011,p13012,h310],{'NVOL(W)','USDX',lgPDO},'location','southeast','NumColumns',5)
%%
set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir Tname '.png'])
close(gcf)
%%




