function []=drwLineBoxLAGR(xmdUDn,xmdNVn,mnVV,dspDat,dic,dspEL,Tname,pltFCurve,TimeLag,savDir,useYR)
%% << detrend ma3 norm lag-1 3cp box >>
%-----------------------------------------------
switch useYR
    case 'use18'
        YRR=[1968:2016];
    case 'use19'
        YRR=[1968:2017];
end
%%
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,1,1,[0.07,0.07])
%--------------------------------------------------------------------------
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes

hold on; box on; grid on
set(ax2,'fontsize',12)
%--------------------------------------------------------------------------
% < USDX >
switch TimeLag
    case 'yr1'
        yUD=YRR+1;
    case 'yr0'
        yUD=YRR;
end
p453=bar(ax2,yUD',xmdUDn,'k','barwidth',1.0);
set(p453,'facealpha',.5)

%%
switch pltFCurve
    case 'peak'
        [up,lo] = envelope(xmdUDn,14,'peak');
        p455=plot(ax2,yUD,up,'k--','linewidth',0.7);
        p456=plot(ax2,yUD,lo,'k--','linewidth',0.7);
    case 'anal'
        [up,lo] = envelope(xmdUDn,16,'analytic');
        p455=plot(ax2,yUD,up,'k--','linewidth',0.7);
        p456=plot(ax2,yUD,lo,'k--','linewidth',0.7);
    case 'rms'
        [up,lo] = envelope(xmdUDn,16,'rms');
        p455=plot(ax2,yUD,up,'k--','linewidth',0.7);
        p456=plot(ax2,yUD,lo,'k--','linewidth',0.7);
end
%%

%--------------------------------------------------------------------------
set(ax2,'TickDir','out')

xlabel(ax2,'Year_{USDX}');
ylabel(ax2,'Detrended USDX');
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[-3.5 3.5];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
switch TimeLag
    case 'yr1'
        axis(ax2,[1968 2020 yna(1) yna(2)])
        xlim(ax2,[1968 2020])
    case 'yr0'
        axis(ax2,[1967 2019 yna(1) yna(2)])
        xlim(ax2,[1967 2019])
end

pbaspect([2.5 1 1])
%%
% NVOL
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes

ax1 = axes('Position',ax1_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');
ax1.XColor = 'r';
ax1.YColor = 'r';

hold on; box on; grid on
set(ax1,'fontsize',12)

%--------------------------------------------------------------------------
% < NVOL(W) >
p451=plot(ax1,YRR,xmdNVn,'r-','linewidth',10.0);
p451.Color(4) = 0.50;
p452=plot(ax1,YRR,xmdNVn,'y-^','markeredgecolor','r','markerfacecolor','y','linewidth',0.7,'markersize',3);
%--------------------------------------------------------------------------
% < NVOL(E) >
p460=plot(ax1,YRR,mnVV,'b-','linewidth',10.0);
p460.Color(4) = 0.50;
p461=plot(ax1,YRR,mnVV,'y-v','markeredgecolor','b','markerfacecolor','y','linewidth',0.7,'markersize',3);
p4611=plot(ax1,YRR,-mnVV,'k-v','markeredgecolor','k','markerfacecolor','w','linewidth',1.0,'markersize',3);
%--------------------------------------------------------------------------

set(ax1,'TickDir','in')

xlabel(ax1,'Year_{NVOL}');
ylabel(ax1,'Detrended NVOL');

%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xna=[-3.5 3.5];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

%%
switch dspEL
    case {'yes','yes2014'}
%--------------------------------------------------------------------------
% < El nino >
sx1=[1982 1982 1984 1984 1982];
sy1=[-4 4 4 -4 -4];
p123=fill(ax1,sx1,sy1,'m');
set(p123,'facealpha',.8)
%--------------------------------------
hh21 = hatchfill(p123, 'single', 45, 3);
set([p123], 'LineStyle', 'none') % Remove outline
set(hh21, 'Color', 'm')           % Change the cross hatch to white
%------------------------------------------------------------
sx2=[1997 1997 1999 1999 1997];
sy2=[-4 4 4 -4 -4];
p223=fill(ax1,sx2,sy2,'m');
set(p223,'facealpha',.8)
%--------------------------------------
hh22 = hatchfill(p223, 'single', 45, 3);
set([p223], 'LineStyle', 'none') % Remove outline
set(hh22, 'Color', 'm')           % Change the cross hatch to white
%------------------------------------------------------------
switch dspEL
    case 'yes2014'
        sx3=[2014 2014 2017 2017 2014];
    otherwise
        sx3=[2015 2015 2017 2017 2015];
end
sy3=[-4 4 4 -4 -4];
p323=fill(ax1,sx3,sy3,'m');
set(p323,'facealpha',.8)
%--------------------------------------
hh23 = hatchfill(p323, 'single', 45, 3);
set([p323], 'LineStyle', 'none') % Remove outline
set(hh23, 'Color', 'm')           % Change the cross hatch to white
%--------------------------------------------------------------------------
end
%%

axis(ax1,[1967 2019 xna(1) xna(2)])
xlim(ax1,[1967 2019])

pbaspect([2.5 1 1])
%%

%%
switch dspEL
    case {'yes','yes2014'}
        legend([p451,p460,p4611,p453,hh23],{'NVOL(W)','NVOL(E)','-NVOL(E)','USDX','Elnino',},'location','southeast','NumColumns',5)
    otherwise
        legend([p451,p460,p4611,p453],{'NVOL(W)','NVOL(E)','-NVOL(E)','USDX'},'location','southeast','NumColumns',5)
end

set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir Tname '.png'])
close(gcf)
