%function []=drwCCP(nxVV,nxv,cUSDX,nxTyp,appNormz,addDens,preLAG)
function []=drwCCP2(nxVV,nxv,cUSDX,cVPr,mdPDOr,nxTyp,appNormz,addDens,yLbl,selPeriod)
box on
grid on
hold on
%--------------------------------------------------------------------------
switch nxTyp
    case 'min'
        nxClr='b';
        pcClr=[.7 .7 1];
    case 'max'
        nxClr='r';
        pcClr=[1 .7 .7];
end
cUSDXt=cUSDX;
%--------------------------------------------------------------------------
switch addDens
    case 'yes'
        data1 = nxVV';   % max or min
        data2 = cUSDXt';
        drwContf(data1,data2)
end
%--------------------------------------------------------------------------
if ~isempty(nxVV)
    p401 = plot(nxVV,cUSDXt,[nxClr 'o'],'MarkerSize',5,'LineWidth',1.5,'MarkerFaceColor',nxClr);
    p401.Color(4) = 0.50;
    p4011 = plot(nxVV,mdPDOr,['k' '+'],'MarkerSize',7,'LineWidth',2.0,'MarkerFaceColor','k');
    p4011.Color(4) = 0.50;
end
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
switch nxTyp
    case 'min'
        switch appNormz
            case 'yes'
                xxa=[-3 3.5];
                yxa=[-3 3.5];
            case 'yes2'
                xxa=[-3.5 3.5];
                yxa=[-3.5 3.5];
            otherwise
                xxa=[-200 200];
                yxa=[-30 40];
        end
    case 'max'
        switch appNormz
            case 'yes'
                xxa=[-3 3.5];
                yxa=[-3 3.5];
            case 'yes2'
                xxa=[-3 4];
                yxa=[-3 4];
            otherwise
                xxa=[-2000 2000];
                yxa=[-30 40];
        end
end
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
line(xxa,yxa,'Color','k','LineStyle','--','LineWidth',0.5);
f=fit(nxVV,cUSDXt,'poly1');
fr=fit(nxVV,mdPDOr,'poly1');
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
switch appNormz
    case {'yes','yes2'}
        Bxx=[xxa(1):0.1:xxa(2)]';
    otherwise
        Bxx=[xxa(1):100:xxa(2)]';
end
if ~isempty(Bxx)
    p402=plot(Bxx,f.p1*Bxx+f.p2,'Color',nxClr,'LineStyle','-','LineWidth',1.0);
    p402.Color(4) = 0.50;
    p4021=plot(Bxx,fr.p1*Bxx+fr.p2,'Color',nxClr,'LineStyle','-','LineWidth',1.0);
    p4021.Color(4) = 0.50;
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
[Bx,Ix] = sort(nxVV);
%yy=cUSDXt;
yy=mdPDOr;
By = yy(Ix);
[p,S] = polyfit(Bx,By,1);
%--------------------------------------------------------------------------
[y_fit,delta]=polyconf(p,Bxx,S,'alpha',0.05);
plot(Bxx,y_fit+delta,[nxClr '--'],Bxx,y_fit-delta,[nxClr '--'],'LineWidth',1.0)
%--------------------------------------------------------------------------
h21 = patch([Bxx' fliplr(Bxx')],[(y_fit-delta)' fliplr((y_fit+delta)')],pcClr);
set(h21,'EdgeColor','none');
alpha(h21,0.2);
%%
YR=1968:2017;
%idxOUT=~inpolygon(nxVV,cUSDXt,[Bxx' fliplr(Bxx')],[(y_fit-delta)' fliplr((y_fit+delta)')])
%{
if strcmp(yLbl,'PDO')
idxOUT=YR>=1992 & YR<=2003;
else
idxOUT=YR>=1986 & YR<=2003;
end
%}
switch selPeriod
    case 'All_8603'
        idxOUT=(YR>=1986 & YR<=2003);
    case 'All_9203'
        idxOUT=(YR>=1992 & YR<=2003);
    case 'PDO_9203_ELS_8603'
        if strcmp(yLbl,'PDO')
            idxOUT=(YR>=1992 & YR<=2003);
        else
            idxOUT=(YR>=1986 & YR<=2003);
        end
end
%%
for i=1:length(YR)
    if idxOUT(i)==1
    text(nxVV(i)+0.04,cUSDXt(i),num2str(YR(i),'%+4.0f'),'color','k','fontsize',10,'FontName','d2coding')
    end
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
text(xxa(1)*0.95,yxa(2)*1.05,['\rho=' num2str(nxv,'%+3.2f') ', ' '\rho_{c}=' num2str(cVPr,'%+3.2f')],'color','k','fontsize',16,'FontName','d2coding');
xlim(xxa)
ylim(yxa)
grid on
pbaspect([1 1 1])
%--------------------------------------------------------------------------
switch nxTyp
    case 'min'
        xlabel('Detrended NVOL(E)');
    case 'max'
        xlabel('Detrended NVOL(W)');
end
ylabel(['Detrended ' yLbl]);
%--------------------------------------------------------------------------
set(gca,'fontsize',16)

end
