%function []=drwCCP(nxVV,nxv,cUSDX,nxTyp,appNormz,addDens,preLAG)
function []=drwCCP(nxVV,nxv,cUSDX,nxTyp,appNormz,addDens)
box on
grid on
hold on
%--------------------------------------------------------------------------
switch nxTyp
    case 'min'
        nxClr='b';
        pcClr=[.7 .7 1];
    case 'max'
        nxClr='r';
        pcClr=[1 .7 .7];
end
cUSDXt=cUSDX;
%--------------------------------------------------------------------------
switch addDens
    case 'yes'
        data1 = nxVV';   % max or min
        data2 = cUSDXt';
        drwContf(data1,data2)
end
%--------------------------------------------------------------------------
if ~isempty(nxVV)
    p401 = plot(nxVV,cUSDXt,[nxClr 'o'],'MarkerSize',5,'LineWidth',1.5,'MarkerFaceColor',nxClr);
    p401.Color(4) = 0.50;
end
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
switch nxTyp
    case 'min'
        switch appNormz
            case 'yes'
                xxa=[-3 3.5];
                yxa=[-3 3.5];
            case 'yes2'
                xxa=[-3.5 3.5];
                yxa=[-3.5 3.5];
            otherwise
                xxa=[-200 200];
                yxa=[-30 40];
        end
    case 'max'
        switch appNormz
            case 'yes'
                xxa=[-3 3.5];
                yxa=[-3 3.5];
            case 'yes2'
                xxa=[-3 4];
                yxa=[-3 4];
            otherwise
                xxa=[-2000 2000];
                yxa=[-30 40];
        end
end
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
line(xxa,yxa,'Color','k','LineStyle','--','LineWidth',0.5);
f=fit(nxVV,cUSDXt,'poly1');
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
switch appNormz
    case {'yes','yes2'}
        Bxx=[xxa(1):0.1:xxa(2)]';
    otherwise
        Bxx=[xxa(1):100:xxa(2)]';
end
if ~isempty(Bxx)
    p402=plot(Bxx,f.p1*Bxx+f.p2,'Color',nxClr,'LineStyle','-','LineWidth',1.0);
    p402.Color(4) = 0.50;
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
[Bx,Ix] = sort(nxVV);
yy=cUSDXt;
By = yy(Ix);
[p,S] = polyfit(Bx,By,1);
%--------------------------------------------------------------------------
[y_fit,delta]=polyconf(p,Bxx,S,'alpha',0.05);
plot(Bxx,y_fit+delta,[nxClr '--'],Bxx,y_fit-delta,[nxClr '--'],'LineWidth',1.0)
%--------------------------------------------------------------------------
h21 = patch([Bxx' fliplr(Bxx')],[(y_fit-delta)' fliplr((y_fit+delta)')],pcClr);
set(h21,'EdgeColor','none');
alpha(h21,0.2);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
text(xxa(1)*0.95,yxa(2)*1.05,['\rho=' num2str(nxv,'%+3.2f')],'color','k','fontsize',16,'FontName','d2coding');
xlim(xxa)
ylim(yxa)
grid on
pbaspect([1 1 1])
%--------------------------------------------------------------------------
switch nxTyp
    case 'min'
        xlabel('Detrended NVOL(E)');
    case 'max'
        xlabel('Detrended NVOL(W)');
end
ylabel('Detrended USDX');
%--------------------------------------------------------------------------
set(gca,'fontsize',16)

end
