function [IVE,IUD,cmdVV,cUSDX,cmdVVA,cUSDXA,ScV,SpV,dt3PARA,dt3PARAd,SPtd,SPpv,iVVs,dtVs,dVV,mdVV,iDXs,dtDs,dDX,mdDX,USDX,...
          dic,dil,minLAT,minLATm,maxLAT,maxLATm,minLON,maxLON,...
          sstXYy,sstXYl,srtY,endY,sstXYyS,sstXYlS,SLAT,SLON,...
          cmdVVA_nolag6818,cUSDXA_nolag6818,VNS]...
          =calCCA(appNormz,TimeLag,ccTyp,Talpha,useYR,selUSDXtype)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
switch useYR
    case 'use19'
        %%
        % << USDX >> 1967:2020
        switch selUSDXtype
            case 'lastDAYyr'
                % < Close as of the last business day of the year >
                %USDX = xlsread('.\data_in\dx_f_y___Stooq_annual.xlsx','dx_f_y___Stooq.com','F5:F57');
                USDX = xlsread('.\data_in\dx_f_y___Stooq_annual.xlsx','dx_f_y___Stooq.com','I5:I58');
            case 'lastDAYmn'   % ***
                % < Yearly average of close as of the last business day of the month >
                %USDX = xlsread('.\data_in\dx_f_y___Stooq_annual.xlsx','dx_f_y___Stooq.com','J5:J57');
                USDX = xlsread('.\data_in\dx_f_y___Stooq_annual.xlsx','dx_f_y___Stooq.com','J5:J58');
        end
        %--------------------------------------------------------------------------
        % << NVOL >>
        % ~ 2019
        %sstXYy = xlsread('.\data_in\GVP_Eruption_Results_200228_ALL.xlsx','Eruption List','I3:I11174'); % year
        %sstXYl = xlsread('.\data_in\GVP_Eruption_Results_200228_ALL.xlsx','Eruption List','W3:X11174'); % location(lat,lon)
        %%---------------------------------------------------
        % ~ 2020
        % (all)
        sstXYy = xlsread('.\data_in\GVP_Eruption_Results_210514_ALL.xlsx','Eruption List','I3:I11205'); % year
        sstXYl = xlsread('.\data_in\GVP_Eruption_Results_210514_ALL.xlsx','Eruption List','W3:X11205'); % location(lat,lon)
        %%------------------------
        % (all)
        %sstXYy = xlsread('.\data_in\GVP_Eruption_Results_210514_ALL.xlsx','Eruption List','I3:I11209'); % year
        %sstXYl = xlsread('.\data_in\GVP_Eruption_Results_21051_ALL.xlsx','Eruption List','W3:X11209'); % location(lat,lon)
        %%------------------------
        %  (confirmed)
        %sstXYy = xlsread('.\data_in\GVP_Eruption_Results_210515_ALL_CF.xlsx','Eruption List','I3:I9928'); % year
        %sstXYl = xlsread('.\data_in\GVP_Eruption_Results_210515_ALL_CF.xlsx','Eruption List','W3:X9928'); % location(lat,lon)
        %--------------------------------------------------------------------------
        %--------------------------------------------------------------------------
        % << Volcano Number >>
        % ~ 2019
        %sstVN = xlsread('.\data_in\GVP_Eruption_Results_200228_ALL.xlsx','Eruption List','A3:A11174'); % Volcano Number
        %%---------------------------------------------------
        % ~ 2020
        % (all)
        sstVN = xlsread('.\data_in\GVP_Eruption_Results_210514_ALL.xlsx','Eruption List','A3:A11205'); % Volcano Number
        %%------------------------
        % (all)
        %sstVN = xlsread('.\data_in\GVP_Eruption_Results_210515_ALL.xlsx','Eruption List','A3:A11209'); % Volcano Number
        %%------------------------
        %  (confirmed)
        %sstVN = xlsread('.\data_in\GVP_Eruption_Results_210515_ALL_CF.xlsx','Eruption List','A3:A9928'); % Volcano Number
        %--------------------------------------------------------------------------
        %--------------------------------------------------------------------------
        % << VEI >>
        %sstVN = xlsread('.\data_in\GVP_Eruption_Results_200228_ALL.xlsx','Eruption List','F3:F11174'); % Volcano Number
end
%%
srtY=1967;
%endY=2019;
endY=2020;
idxY=find(sstXYy>=srtY & sstXYy<=endY);
%--------------------------------------------------------------------------
clear sstXYyS sstXYlS
sstXYyS=sstXYy(idxY,:);
sstXYlS=sstXYl(idxY,:);
%--------------------------------------------------------------------------
% << Volcano Number >>
clear sstVNS
sstVNS=sstVN(idxY,:);
%--------------------------------------------------------------------------
clear SYR SVV SLAT SLON dVV mdVV dDX mdDX ScV SpV cmdVVA cUSDXA dt3PARA iVVs dtVs iDXs dtDs SPtd SPpv
clear cmdVVA_nolag6818 cUSDXA_nolag6818
%--------------------------------------------------------------------------
dic=80;   
%--------------------------------------------------------------------------
dil=2;   
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% << cal >>
minLAT=-80;
maxLAT=80;
%------------
% << map >>
minLATm=-65;
maxLATm=65;
%--------------------------------------------------------------------------
% -179.97 ~ 179.58
minLON=-180;
maxLON=180;
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
ia=0;
for ilat=[minLAT:dil:0 0:dil:maxLAT]   
    ia=ia+1;
    io=0;
    %%
    for ilon=[minLON:dil:0 0:dil:maxLON] 
        io=io+1;
        arclen = distance('gc',[ilat,ilon],[sstXYlS(:,1),sstXYlS(:,2)]);
        idxLL=find(arclen<=dic/2);

        clear sstXYySS sstXYlSS
        sstXYySS=sstXYyS(idxLL,:);
        sstXYlSS=sstXYlS(idxLL,:);
        %------------------------------------------------------------------
        % << Volcano Number >>
        clear sstVNSS
        sstVNSS=sstVNS(idxLL,:);
        %------------------------------------------------------------------
        for iy=srtY:endY
            idxSS=find(sstXYySS==iy);
            SYR(iy-srtY+1,ia,io)=iy;
            %--------------------------------------------------------------
            SVV(iy-srtY+1,ia,io)=sum(sstXYySS==iy); % OK <***
            %--------------------------------------------------------------
            % << Volcano Number >>
            VNS{iy-srtY+1,ia,io}=sstVNSS(sstXYySS==iy);
            %--------------------------------------------------------------
            if iy==srtY
                SLAT(ia,io)=ilat;
                SLON(ia,io)=ilon;
            end
        end
        %%
        %------------------------------------------------------------------
        % org
        iVV=squeeze(SVV(:,ia,io));
        iYR=[1:length(iVV)]';
        %% < NVOL >
        %---------------------------------
        [iVV,dtV,dVVt,mdVVt,f]=fit_det_ma3(iYR,iVV);
        %------------------------------------------------------------------
        % save
        iVVs{ia,io}=iVV;    % org,       1967 ~ 2019 (ef: NV1967~2019 UD1967~2018 
        %iYRs=iYR;
        dtVs{ia,io}=dtV;    % fit curve, 1967 ~ 2019 (ef: NV1967~2019 UD1967~2018
        %----------------------------------
        dVV{ia,io}=dVVt;    % detrended, 1967 ~ 2019 (ef: NV1967~2019 UD1967~2018)   
        mdVV{ia,io}=mdVVt;  % ma3ed,     1967 ~ 2019 (ef: NV1968~2018 UD1968~2017)
        %------------------------------------------------------------------
        %% < USDX >
        if ia==1 & io==1
            iDX=USDX(:,1);   % all for ma and org
            %---------------------------------
            [iDX,dtD,dDXt,mdDXt,fd]=fit_det_ma3(iYR,iDX);
            %--------------------------------------------------------------
            iDXs=iDX;    % org,       1967 ~ 2019 (ef: NV1967~2019 UD1967~2018
            dtDs=dtD;    % fit curve, 1967 ~ 2019 (ef: NV1967~2019 UD1967~2018
            %----------------------------------
            dDX=dDXt;    % detrended, 1967 ~ 2019 (ef: NV1967~2019 UD1967~2018)
            mdDX=mdDXt;  % ma3ed,     1967 ~ 2019 (ef: NV1968~2018 UD1968~2017)
            %--------------------------------------------------------------
        end
        %------------------------------------------------------------------
        %%|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
        %%
switch useYR
    case 'use18'
        %------------------------------------------------------------------
        % mdVV : 1967~2019
        % USDX : 1967:2018
        % COMM : 1968~2017, mdVV(2:end-2), USDX(2:end-1) 
        %----------------------------------
        cmdVV=mdVVt(2:end-2);    % 1968~2017 ->      1968~2016
        cUSDX=USDX(2:end-1,4);   % 1968~2017 ->(lag) 1969~2017   
    case 'use19'
        %------------------------------------------------------------------
        % mdVV : 1967~2019
        % USDX : 1967:2019
        % COMM : 1968~2018, mdVV(2:end-1), USDX(2:end-1) 
        %----------------------------------
        cmdVV=mdVVt(2:end-1);    % 1968~2018 ->      1968~2017
        cUSDX=mdDXt(2:end-1);    % 1968~2018 ->(lag) 1969~2018   
end
        %------------------------------------------------------------------
        switch appNormz
            case {'yes','yes2'}
        % << normalize by z-score >>
        % N = normalize(A) returns the vectorwise z-score of the data in A with center 0 and standard deviation 1.
        cmdVV=normalize(cmdVV);  % 1968~2017/1968~2018 ->      1968~2016/1968~2017
        cUSDX=normalize(cUSDX);  % 1968~2017/1968~2018 ->(lag) 1969~2017/1969~2018 
        end
        %------------------------------------------------------------------
        switch TimeLag
            case 'yr1'
                IVE=cmdVV(1:end-1,1);   % 1968~2016/1968~2017
                IUD=cUSDX(2:end,1);     % 1969~2017/1969~2018
            case 'yr0'   
                IVE=cmdVV(1:end-1,1);   % 1968~2016/1968~2017
                IUD=cUSDX(1:end-1,1);   % 1968~2016/1968~2017
        end
        [cVt,pVt]=corr(IVE,IUD,'Type',ccTyp);
        %------------------------------------------------------------------
        cmdVVA{ia,io}=IVE;    % 1968~2016/1968~2017
        cUSDXA{ia,io}=IUD;    % 1969~2017(1968~2016)/1969~2018(1968~2017) 
        %----------------------
        % no lag
        cmdVVA_nolag6818{ia,io}=cmdVV;    % 1968~2017/1968~2018
        cUSDXA_nolag6818{ia,io}=cUSDX;    % 1968~2017/1968~2018 
        %------------------------------------------------------------------
        cV=cVt;
        pV=pVt;
        
        ScV(ia,io)=cV;
        SpV(ia,io)=pV;        
        %----------------------------------
        % Detrend polynomial parameters
        % NVOL
        dt3PARA{ia,io,1}=f.p1;
        dt3PARA{ia,io,2}=f.p2;
        dt3PARA{ia,io,3}=f.p3;
        dt3PARA{ia,io,4}=f.p4;
        %----------------------
        % USDX
        dt3PARAd{ia,io,1}=fd.p1;
        dt3PARAd{ia,io,2}=fd.p2;
        dt3PARAd{ia,io,3}=fd.p3;
        dt3PARAd{ia,io,4}=fd.p4;
        %------------------------------------------------------------------
        % Spearman's Rho Test
        [VV,IV]=sort(IVE);
        [VU,IU]=sort(IUD);
        Vd=IV-IU;
        [Td,p_value]=SpearmanRho(Vd,Talpha);
        SPtd(ia,io)=Td;
        SPpv(ia,io)=p_value;
        %------------------------------------------------------------------
    end
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%


end
