%% << max >>
filename='.\data_in\savMXNdataMX_Table.xlsx';
%--------------------------------------------------------------------------
% max
sheet='WA';
xlRange='D9:AM62';
ssxA = xlsread(filename,sheet,xlRange);
sheet='WO';
xlRange='D9:AM62';
ssxO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssxA);
ssxA1x=reshape(ssxA,sr*sc,1);
ssxO1x=reshape(ssxO,sr*sc,1);
%--------------------------------------------------------------------------
% min
sheet='EA';
xlRange='D9:V62';
ssnA = xlsread(filename,sheet,xlRange);
sheet='EO';
xlRange='D9:V62';
ssnO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssnA);
ssnA1x=reshape(ssnA,sr*sc,1);
ssnO1x=reshape(ssnO,sr*sc,1);
%% << 07 >>
filename='.\data_in\savMXNdata70_Table.xlsx';
%--------------------------------------------------------------------------
% max
sheet='WA';
xlRange='D9:AM62';
ssxA = xlsread(filename,sheet,xlRange);
sheet='WO';
xlRange='D9:AM62';
ssxO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssxA);
ssxA17=reshape(ssxA,sr*sc,1);
ssxO17=reshape(ssxO,sr*sc,1);
%--------------------------------------------------------------------------
% min
sheet='EA';
xlRange='D9:V62';
ssnA = xlsread(filename,sheet,xlRange);
sheet='EO';
xlRange='D9:V62';
ssnO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssnA);
ssnA17=reshape(ssnA,sr*sc,1);
ssnO17=reshape(ssnO,sr*sc,1);
%% << 06 >>
filename='.\data_in\savMXNdata60_Table.xlsx';
%--------------------------------------------------------------------------
% max
sheet='WA';
xlRange='D9:AM62';
ssxA = xlsread(filename,sheet,xlRange);
sheet='WO';
xlRange='D9:AM62';
ssxO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssxA);
ssxA16=reshape(ssxA,sr*sc,1);
ssxO16=reshape(ssxO,sr*sc,1);
%--------------------------------------------------------------------------
% min
sheet='EA';
xlRange='D9:V62';
ssnA = xlsread(filename,sheet,xlRange);
sheet='EO';
xlRange='D9:V62';
ssnO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssnA);
ssnA16=reshape(ssnA,sr*sc,1);
ssnO16=reshape(ssnO,sr*sc,1);
%% << 05 >>
filename='.\data_in\savMXNdata50_Table.xlsx';
%--------------------------------------------------------------------------
% max
sheet='WA';
xlRange='D9:AM62';
ssxA = xlsread(filename,sheet,xlRange);
sheet='WO';
xlRange='D9:AM62';
ssxO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssxA);
ssxA15=reshape(ssxA,sr*sc,1);
ssxO15=reshape(ssxO,sr*sc,1);
%--------------------------------------------------------------------------
% min
sheet='EA';
xlRange='D9:V62';
ssnA = xlsread(filename,sheet,xlRange);
sheet='EO';
xlRange='D9:V62';
ssnO = xlsread(filename,sheet,xlRange);
%--------------------------------------
[sr,sc]=size(ssnA);
ssnA15=reshape(ssnA,sr*sc,1);
ssnO15=reshape(ssnO,sr*sc,1);
%%
%%
clear cxA cx5 cx6 cx7 cxx
clear cnA cn5 cn6 cn7 cnn
%-------------------------
cx5=cell(size(ssxO15));
cx5(:)={'\rho>=0.5'};
cx6=cell(size(ssxO16));
cx6(:)={'\rho>=0.6'};
cx7=cell(size(ssxO17));
cx7(:)={'\rho>=0.7'};
cxx=cell(size(ssxO1x));
cxx(:)={'\rho_{max}'};
cxA=[cx5;cx6;cx7;cxx];
%-------------------------
cn5=cell(size(ssnO15));
cn5(:)={'\rho<=-0.5'};
cn6=cell(size(ssnO16));
cn6(:)={'\rho<=-0.6'};
cn7=cell(size(ssnO17));
cn7(:)={'\rho<=-0.7'};
cnn=cell(size(ssnO1x));
cnn(:)={'\rho_{min}'};
cnA=[cn5;cn6;cn7;cnn];
%-------------------------
%%
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%%
%% << max >>
%load coast; 
v= ver('MATLAB'); 
if v.Release=="(R2020b)"
    load coastlines;
    lat=coastlat;
    long=coastlon;
else
    load coast;
end
%--------------------------------------------------------------------------
Longitude=[ssxO15;ssxO16;ssxO17;ssxO1x];
Latitude=[ssxA15;ssxA16;ssxA17;ssxA1x];

setCENT='median';
switch setCENT
    case 'mean'
mx5Lon=nanmean(ssxO15);
mx5Lat=nanmean(ssxA15);
mx6Lon=nanmean(ssxO16);
mx6Lat=nanmean(ssxA16);
mx7Lon=nanmean(ssxO17);
mx7Lat=nanmean(ssxA17);
mxxLon=nanmean(ssxO1x);
mxxLat=nanmean(ssxA1x);
    case 'median'
mx5Lon=nanmedian(ssxO15);
mx5Lat=nanmedian(ssxA15);
mx6Lon=nanmedian(ssxO16);
mx6Lat=nanmedian(ssxA16);
mx7Lon=nanmedian(ssxO17);
mx7Lat=nanmedian(ssxA17);
mxxLon=nanmedian(ssxO1x);
mxxLat=nanmedian(ssxA1x);
end
mxLonA=[mx5Lon mx6Lon mx7Lon mxxLon];
mxLatA=[mx5Lat mx6Lat mx7Lat mxxLat];
%-----------------------------------
myColor=[rgbS('Green');...
         rgbS('RoyalBlue');...
         rgbS('DarkOrange');...
         rgbS('Crimson')];
%-----------------------------------
linWth=[2,4,6,8]; % 2,3,4,6
mrkSze=[15,15,15,15]; % 4,4,5,8    
%--------------------------------------------------------------------------
s1=scatterhist(Longitude,Latitude,'Group',cxA,'Kernel','overlay','Location','SouthEast',...
            'LineStyle',{'-','-','-','-'},...
            'LineWidth',linWth,...
            'Color',myColor,...
            'Marker','oooo',...
            'MarkerSize',mrkSze,...
            'legend','off',...
            'Direction','out');
%--------------------------------------------------------------------------
xlabel('Longitude (^{o}E)')
ylabel('Latitude (^{o}N)') 

set(s1(1),'XTick',[0:20:180]);
set(s1(1),'XTickLabel','');
set(s1(1),'XTickLabel',{'0','20','40','60','80','100','120','140','160','180'});

set(s1(1),'XLim',[0, 180]);
set(s1(1),'YLim',[-65, 65]);
%--------------------------------------------------------------------------
grid on
box on
hold on
%--------------------------------------------------------------------------
%************************************************************
dat15=[ssxO15,ssxA15];
dat16=[ssxO16,ssxA16];
dat17=[ssxO17,ssxA17];
dat1x=[ssxO1x,ssxA1x];
h15 = kscontour(dat15, 'Color', 'green','alpha',0.3);
h16 = kscontour(dat16, 'Color', 'blue','alpha',0.3);
h17 = kscontour(dat17, 'Color', 'orange','alpha',0.3);
h1x = kscontour(dat1x, 'Color', 'vermillion','alpha',0.3);
%------------------------------------------------------------
px5=plot(dat15(:,1),dat15(:,2),'o','markeredgecolor',rgbS('Green'),'markerfacecolor',rgbS('Green'),'markersize',12); hold on
px6=plot(dat16(:,1),dat16(:,2),'o','markeredgecolor',rgbS('RoyalBlue'),'markerfacecolor',rgbS('RoyalBlue'),'markersize',12);
px7=plot(dat17(:,1),dat17(:,2),'o','markeredgecolor',rgbS('DarkOrange'),'markerfacecolor',rgbS('DarkOrange'),'markersize',12);
pxx=plot(dat1x(:,1),dat1x(:,2),'o','markeredgecolor',rgbS('Crimson'),'markerfacecolor',rgbS('Crimson'),'markersize',12);
%************************************************************
p1=plot(long,lat,'color',rgbS('SlateGray'),'linewidth',1.0);
p1.Color(4)=0.9;
%--------------------------------------------------------------------------
plot(mxLonA(4),mxLatA(4),'kX','markersize',12,'linewidth',3);
%--------------------------------------------------------------------------
text(0*0.95,65*1.08,['[X] ' setCENT ' location of NVOL(W) (\rho_{max}), ' ...
    num2str(mxLonA(4),'%+3.1f') '^{o}E ' num2str(mxLatA(4),'%+3.1f') '^{o}N'],...
    'color','k','fontsize',12,'FontName','d2coding');
%--------------------------------------------------------------------------
%legend({cx5{1},cx6{1},cx7{1},cxx{1}},'FontSize',18,'FontName','d2coding')
legend([px5 px6 px7 pxx],{cx5{1},cx6{1},cx7{1},cxx{1}},'FontSize',18,'FontName','d2coding')
%--------------------------------------------------------------------------
set(gca,'fontsize',14)
whitebg(gcf,'w');
set(gcf,'Color','w');
%%
set(gcf,'units','centimeters','position',[0 0 20 20],...
    'paperposition',[0 0 20 20]);
print(gcf,'-dpng','-r800',['./fig_yr1/Fig.2(b)' '.png'])
close(gcf)
%% << min >>
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);

Longitude=[ssnO15;ssnO16;ssnO17;ssnO1x];
Latitude=[ssnA15;ssnA16;ssnA17;ssnA1x];
%---------------------------------------
switch setCENT
    case 'mean'
mn5Lon=nanmean(ssnO15);
mn5Lat=nanmean(ssnA15);
mn6Lon=nanmean(ssnO16);
mn6Lat=nanmean(ssnA16);
mn7Lon=nanmean(ssnO17);
mn7Lat=nanmean(ssnA17);
mnxLon=nanmean(ssnO1x);
mnxLat=nanmean(ssnA1x);
    case 'median'
mn5Lon=nanmedian(ssnO15);
mn5Lat=nanmedian(ssnA15);
mn6Lon=nanmedian(ssnO16);
mn6Lat=nanmedian(ssnA16);
mn7Lon=nanmedian(ssnO17);
mn7Lat=nanmedian(ssnA17);
mnxLon=nanmedian(ssnO1x);
mnxLat=nanmedian(ssnA1x);
end
mnLonA=[mn5Lon mn6Lon mn7Lon mnxLon];
mnLatA=[mn5Lat mn6Lat mn7Lat mnxLat];

[(180-mxLonA)+(180+mnLonA);(mxLatA)-(mnLatA)]'
%--------------------------------------------------------------------------
s2=scatterhist(Longitude,Latitude,'Group',cnA,'Kernel','overlay','Location','SouthWest',...
            'LineStyle',{'-','-','-','-'},...
            'LineWidth',linWth,...
            'Color',myColor,...
            'Marker','oooo',...
            'MarkerSize',mrkSze,...
            'legend','off',...
            'Direction','out');
%--------------------------------------------------------------------------
xlabel('Longitude (^{o}W)')
ylabel('Latitude (^{o}N)') 

set(s2(1),'XTick',[-180:20:0]);
set(s2(1),'XTickLabel','');
set(s2(1),'XTickLabel',{'180','160','140','120','100','80','60','40','20','0'});
set(s2(1),'XLim',[-180 0]);
set(s2(1),'YLim',[-65, 65]);
%--------------------------------------------------------------------------
grid on
box on
hold on
%************************************************************
dat15=[ssnO15,ssnA15];
dat16=[ssnO16,ssnA16];
dat17=[ssnO17,ssnA17];
dat1x=[ssnO1x,ssnA1x];
h15 = kscontour(dat15, 'Color', 'green','alpha',0.3);
h16 = kscontour(dat16, 'Color', 'blue','alpha',0.3);
h17 = kscontour(dat17, 'Color', 'orange','alpha',0.3);
h1x = kscontour(dat1x, 'Color', 'vermillion','alpha',0.3);
%------------------------------------------------------------
px5=plot(dat15(:,1),dat15(:,2),'o','markeredgecolor',rgbS('Green'),'markerfacecolor',rgbS('Green'),'markersize',12);
px6=plot(dat16(:,1),dat16(:,2),'o','markeredgecolor',rgbS('RoyalBlue'),'markerfacecolor',rgbS('RoyalBlue'),'markersize',12);
px7=plot(dat17(:,1),dat17(:,2),'o','markeredgecolor',rgbS('DarkOrange'),'markerfacecolor',rgbS('DarkOrange'),'markersize',12);
pxx=plot(dat1x(:,1),dat1x(:,2),'o','markeredgecolor',rgbS('Crimson'),'markerfacecolor',rgbS('Crimson'),'markersize',12);
%************************************************************
%--------------------------------------------------------------------------
p1=plot(long,lat,'color',rgbS('SlateGray'),'linewidth',1.0);
p1.Color(4)=0.9;
%--------------------------------------------------------------------------
plot(mnLonA(4),mnLatA(4),'kX','markersize',12,'linewidth',3);
%--------------------------------------------------------------------------
text(-180*1.00,65*1.08,['[X] ' setCENT ' location of NVOL(E) (\rho_{min}), ' ... 
    num2str(abs(mnLonA(4)),'%+3.1f') '^{o}W / ' num2str(mnLatA(4),'%+3.1f') '^{o}N'],...
    'color','k','fontsize',12,'FontName','d2coding');
%--------------------------------------------------------------------------
%legend({cn5{1},cn6{1},cn7{1},cnn{1}},'FontSize',18,'FontName','d2coding')
legend([px5 px6 px7 pxx],{cn5{1},cn6{1},cn7{1},cnn{1}},'FontSize',18,'FontName','d2coding')
%%
set(gca,'fontsize',14)
whitebg(gcf,'w');
set(gcf,'Color','w');
%%
set(gcf,'units','centimeters','position',[0 0 20 20],...
    'paperposition',[0 0 20 20]);
print(gcf,'-dpng','-r800',['./fig_yr1/Fig.2(d)' '.png'])
close(gcf)