close all
clear all

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
pmLim=-0.50;   
pxLim=0.50;    
%------------------------------
nCir=10;
%--------------------------------------------------------------------------
dspDat='Area'; % area
%-----------------------------
dspDat_clr='no';
%-----------------------------
setOver='MxMn';  % overlap max/min value
%--------------------------------------------------------------------------
setCmap='RnB';
%--------------------------------------------------------------------------
elmOutArea='yes';
%--------------------------------------------------------------------------
drwEchCirc='no';   % each yellow circle
%--------------------------------------------------------------------------
drwEL='yes';   % draw ELNINO
%--------------------------------------------------------------------------
cntTyp='wgt'; % +/x marker thick, eql/wgt 
%--------------------------------------------------------------------------
landColor=[.90 .85 .80];    
%-------------------------
oceanColor = [.80 .85 .90]; 
%-------------------------
mkrfceclr=rgbS('Goldenrod');            
mkredgclr='k';              
Vshp='o';
%-------------------------
Pshp='.';
Nshp='.';
Pshpf=0.01;
Nshpf=0.01;
%------------
Pshpx='+';
Nshpx='+';
%-------------------------
appNormz='yes2';
%-------------------------
ccTyp='Pearson';  % default
Talpha=0.05;
%-------------------------
TimeLag='yr1';   % default
switch TimeLag
    case 'yr1'
        savDir='./fig_yr1/';
        dspORG='yes';   % display process
    case 'yr0'
        savDir='./fig_yr0/';
        dspORG='no';   % display pr ocess
end
if ~exist(savDir,'dir'); mkdir(savDir); end
%%
setArea='circ';
%%
%--------------------------------------------------------------------------
useYR='use19';
selUSDXtype='lastDAYmn';   % Yearly average of close as of the last business day of the month
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
[IVE,IUD,cmdVV,cUSDX,cmdVVA,cUSDXA,ScV,SpV,dt3PARA,dt3PARAd,SPtd,SPpv,iVVs,dtVs,dVV,mdVV,iDXs,dtDs,dDX,mdDX,USDX,...
          dic,dil,minLAT,minLATm,maxLAT,maxLATm,minLON,maxLON,...
          sstXYy,sstXYl,srtY,endY,sstXYyS,sstXYlS,SLAT,SLON,...
          cmdVVA_nolag6818,cUSDXA_nolag6818,VNS]...
          =calCCA(appNormz,TimeLag,ccTyp,Talpha,useYR,selUSDXtype);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
[mnScV,mxScV,mnSLAT,mxSLAT,mnSLON,mxSLON,mnVV,mxVV,iny,inx,ixy,ixx]=fndMxMnVAL(ScV,SLAT,SLON,cmdVVA);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
xmdNVn_nolag6818=cmdVVA_nolag6818{ixy,ixx};
nmdNVn_nolag6818=cmdVVA_nolag6818{iny,inx};
xmdUDn_nolag6818=cUSDXA_nolag6818{ixy,ixx};
%--------------------------------------------------------------------------
[xNV,fxNV,xdNV,xmdNV,xmdNVn,xUD,fxUD,xdUD,xmdUD,xmdUDn]=maxCCVAL(ixy,ixx,iVVs,dtVs,dVV,mdVV,iDXs,dtDs,dDX,mdDX,cmdVVA,cUSDXA);
[nNV,fnNV,ndNV,nmdNV,nmdNVn,nUD,fnUD,ndUD,nmdUD,nmdUDn]=maxCCVAL(iny,inx,iVVs,dtVs,dVV,mdVV,iDXs,dtDs,dDX,mdDX,cmdVVA,cUSDXA);
clear d3xNV d3nNV d3UD
for ij=1:4
d3xNV(ij,1)=dt3PARA{ixy,ixx,ij};
d3nNV(ij,1)=dt3PARA{iny,inx,ij};
d3UD(ij,1)=dt3PARAd{ixy,ixx,ij};
end
%--------------------------------------------------------------------------
% << Volcano Number >>
for ii=1:size(VNS,1)
    ivx(ii)=length(VNS{ii,ixy,ixx});
    ivn(ii)=length(VNS{ii,iny,inx});
end
nivx=max(ivx);
nivn=max(ivn);
clear VNSx VNSn
VNSx={VNS{:,ixy,ixx}};
VNSn={VNS{:,iny,inx}};
clear VNSXX VNSNN VNSXXt VNSNNt
VNSXX=nan(size(VNS,1),nivx);
VNSNN=nan(size(VNS,1),nivn);
VNSXXt=nan(nivx,size(VNS,1));
VNSNNt=nan(nivn,size(VNS,1));
for ii=1:size(VNS,1)
    for iix=1:length(VNSx{ii})
        VNSXX(ii,iix)=VNSx{ii}(iix);
        VNSXXt(nivx-iix+1,ii)=VNSx{ii}(iix);
    end
    for iin=1:length(VNSn{ii})
        VNSNN(ii,iin)=VNSn{ii}(iin);
        VNSNNt(nivn-iin+1,ii)=VNSn{ii}(iin);
    end
end
clear VNSXXA VNSNNA VNSXXtA VNSNNtA
VNSXXA=[[srtY:endY]',VNSXX];
VNSNNA=[[srtY:endY]',VNSNN];
VNSXXtA=[VNSXXt;[srtY:endY]];
VNSNNtA=[VNSNNt;[srtY:endY]];
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata.xlsx'],VNSXXA,2,'C9')
xlswrite([savDir 'savMXNdata.xlsx'],VNSNNA,3,'C9')
xlswrite([savDir 'savMXNdata.xlsx'],VNSXXtA,4,'C9')
xlswrite([savDir 'savMXNdata.xlsx'],VNSNNtA,5,'C9')
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
[mnSLATc,mxSLATc,mnSLONc,mxSLONc,nsScV,xsScV]=calXNMVAL(minLAT,maxLAT,minLON,maxLON,SLAT,SLON,ScV,dic,dil);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% 
savTXT=[savDir 'Fig.1(a).png'];
GLoc='ALL';
mapP='robinson';
%--------------------------------------------------------------------------
[savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
 savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x,...
 xxv,xnv,xmv,xdv,nxv,nnv,nmv,ndv]...
 =drwWMAP(GLoc,minLATm,maxLATm,SLAT,SLON,dil,ScV,SpV,mapP,drwEL,minLON,...
 mnSLAT,mnSLON,Nshpx,mxSLAT,mxSLON,Pshpx,... 
 dic,Pshp,Nshp,Pshpf,Nshpf,...
 sstXYlS,sstXYyS,...
 Vshp,mkredgclr,mkrfceclr,...
 mnSLATc,mnSLONc,pmLim,mxSLATc,mxSLONc,pxLim,drwEchCirc,elmOutArea,setOver,srtY,...
 savTXT,dspDat,landColor,oceanColor,dspDat_clr,cntTyp,setCmap);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
mapPA={'flatplrq'};  
%--------------------------------------------------------------------------
for ipa=1:length(mapPA)
mapP=mapPA{ipa};    
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << WEST >>
savTXT=[savDir 'Fig.1(a)W.png'];
GLoc='WEST';
mapP='flatplrq';
%--------------------------------------------------------------------------
[savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
 savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x]...
 =drwWMAP(GLoc,minLATm,maxLATm,SLAT,SLON,dil,ScV,SpV,mapP,drwEL,minLON,...
 mnSLAT,mnSLON,Nshpx,mxSLAT,mxSLON,Pshpx,... 
 dic,Pshp,Nshp,Pshpf,Nshpf,...
 sstXYlS,sstXYyS,...
 Vshp,mkredgclr,mkrfceclr,...
 mnSLATc,mnSLONc,pmLim,mxSLATc,mxSLONc,pxLim,drwEchCirc,elmOutArea,setOver,srtY,...
 savTXT,dspDat,landColor,oceanColor,dspDat_clr,cntTyp,setCmap);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << EAST >>
savTXT=[savDir 'Fig.1(a)E.png'];
GLoc='EAST';
mapP='flatplrq';
%--------------------------------------------------------------------------
[savLAT70n,savLON70n,savLAT60n,savLON60n,savLAT50n,savLON50n,...
 savLAT70x,savLON70x,savLAT60x,savLON60x,savLAT50x,savLON50x]...
 =drwWMAP(GLoc,minLATm,maxLATm,SLAT,SLON,dil,ScV,SpV,mapP,drwEL,minLON,...
 mnSLAT,mnSLON,Nshpx,mxSLAT,mxSLON,Pshpx,... 
 dic,Pshp,Nshp,Pshpf,Nshpf,...
 sstXYlS,sstXYyS,...
 Vshp,mkredgclr,mkrfceclr,...
 mnSLATc,mnSLONc,pmLim,mxSLATc,mxSLONc,pxLim,drwEchCirc,elmOutArea,setOver,srtY,...
 savTXT,dspDat,landColor,oceanColor,dspDat_clr,cntTyp,setCmap);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << CC 1x1 >>
% < max >
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.6 scrsz(4)/1.1]);
%%
set(gca,'fontsize',14)
%--------------------------------------------------------------------------
drwCCP(mxVV,xxv,IUD,'max',appNormz,'no')
%%
set(gcf,'units','centimeters','position',[0 0 30 30],...
    'paperposition',[0 0 15 15]);
print(gcf,'-dpng','-r600',[savDir 'Fig.1(b).png'])
close(gcf)
%%
%% < min >
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.6 scrsz(4)/1.1]);
%%
set(gca,'fontsize',14)
%--------------------------------------------------------------------------
drwCCP(mnVV,nnv,IUD,'min',appNormz,'no')
%%
set(gcf,'units','centimeters','position',[0 0 15 15],...
    'paperposition',[0 0 15 15]);
print(gcf,'-dpng','-r600',[savDir 'Fig.1(d).png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << detrend ma3 norm lag-1 3cp box >>
drwLineBoxLAG(xmdUDn,xmdNVn,mnVV,dspDat,dic,'no','Fig.1(c)','no',TimeLag,savDir,useYR);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% <0.70>
inn=inpolygon(sstXYlS(:,1),sstXYlS(:,2),savLAT70n,savLON70n);
inx=inpolygon(sstXYlS(:,1),sstXYlS(:,2),savLAT70x,savLON70x);

clear sstXYySSn sstXYlSSn sstXYySSx sstXYlSSx
sstXYySSn=sstXYyS(inn,:);
sstXYlSSn=sstXYlS(inn,:);
sstXYySSx=sstXYyS(inx,:);
sstXYlSSx=sstXYlS(inx,:);

%%
% << Volcano Number >>
srtY=1967;
%endY=2019;
endY=2020;
idxY=find(sstXYy>=srtY & sstXYy<=endY);
%--------------------------------------------------------------------------
% << Volcano Number >>
%sstVN = xlsread('.\data_in\GVP_Eruption_Results_200228_ALL.xlsx','Eruption List','A3:A11174'); % Volcano Number
sstVN = xlsread('.\data_in\GVP_Eruption_Results_210514_ALL.xlsx','Eruption List','A3:A11205'); % Volcano Number
%--------------------------------------------------------------------------
% << Volcano Number >>
clear sstVNS %sstVNSn sstVNSx
sstVNS=sstVN(idxY,:);
%--------------------------------------------------------------------------
% << Volcano Number >>
clear VNSn VNSx sstVNSSn sstVNSSx
sstVNSSn=sstVNS(inn,:);
sstVNSSx=sstVNS(inx,:);
%%

for iy=srtY:endY
    idxSSn=find(sstXYySSn==iy);
    SYRn(iy-srtY+1,1)=iy;
    %----------------------------------------------------
    SVVn(iy-srtY+1,1)=sum(sstXYySSn==iy);   
    %----------------------------------------------------
    % << Volcano Number >>
    VNSn{iy-srtY+1,1}=sstVNSSn(sstXYySSn==iy);
    %----------------------------------------------------
    idxSSx=find(sstXYySSx==iy);
    SYRx(iy-srtY+1,1)=iy;
    %----------------------------------------------------
    SVVx(iy-srtY+1,1)=sum(sstXYySSx==iy);  % OK <***
    %----------------------------------------------------
    % << Volcano Number >>
    VNSx{iy-srtY+1,1}=sstVNSSx(sstXYySSx==iy);
end

%%
% << Volcano Number >>
for ii=1:size(VNS,1)
    ivx(ii)=length(VNSx{ii,1});
    ivn(ii)=length(VNSn{ii,1});
end
nivx=max(ivx);
nivn=max(ivn);
clear VNSXX VNSNN VNSXXt VNSNNt
VNSXX=nan(size(VNS,1),nivx);
VNSNN=nan(size(VNS,1),nivn);
VNSXXt=nan(nivx,size(VNS,1));
VNSNNt=nan(nivn,size(VNS,1));
for ii=1:size(VNS,1)
    for iix=1:length(VNSx{ii})
        VNSXX(ii,iix)=VNSx{ii}(iix);
        VNSXXt(nivx-iix+1,ii)=VNSx{ii}(iix);
    end
    for iin=1:length(VNSn{ii})
        VNSNN(ii,iin)=VNSn{ii}(iin);
        VNSNNt(nivn-iin+1,ii)=VNSn{ii}(iin);
    end
end
clear VNSXXA VNSNNA VNSXXtA VNSNNtA
VNSXXA=[[srtY:endY]',VNSXX];
VNSNNA=[[srtY:endY]',VNSNN];
VNSXXtA=[VNSXXt;[srtY:endY]];
VNSNNtA=[VNSNNt;[srtY:endY]];
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata70.xlsx'],VNSXXA,2,'C9')
xlswrite([savDir 'savMXNdata70.xlsx'],VNSNNA,3,'C9')
xlswrite([savDir 'savMXNdata70.xlsx'],VNSXXtA,4,'C9')
xlswrite([savDir 'savMXNdata70.xlsx'],VNSNNtA,5,'C9')
%%

%--------------------------------------------------------------------------
iVVn=squeeze(SVVn(:,1));
iYRn=[1:length(iVVn)]';
[iVVn,dtVn,dVVtn,mdVVtn,fvn70]=fit_det_ma3(iYRn,iVVn);
iVVx=squeeze(SVVx(:,1));
iYRx=[1:length(iVVx)]';
[iVVx,dtVx,dVVtx,mdVVtx,fvx70]=fit_det_ma3(iYRx,iVVx);
iDX=USDX(:,1);   % all for ma and org
iYR=[1:length(iDX)]';
[iDX,dtD,dDXt,mdDXt,fdx70]=fit_det_ma3(iYR,iDX);
switch useYR
    case 'use18'
        cmdVVn=mdVVtn(2:end-2);   % 1968~2018
        cmdVVx=mdVVtx(2:end-2);
        %**********************
        cUSDX=USDX(2:end-1,4);
        %**********************
    case 'use19'
        cmdVVn=mdVVtn(2:end-1);   % 1968~2019
        cmdVVx=mdVVtx(2:end-1);
        cUSDX=mdDXt(2:end-1);
end
%--------------------------------------------------------------------------
switch appNormz
    case {'yes','yes2'}
        % << normalize by z-score >>
        %N = normalize(A) returns the vectorwise z-score of the data in A with center 0 and standard deviation 1.
        cmdVVn=normalize(cmdVVn);
        cmdVVx=normalize(cmdVVx);
        cUSDX=normalize(cUSDX);
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
% USDX -1t
switch TimeLag
    case 'yr1'
        IVEn=cmdVVn(1:end-1,1);   % 1968~2016/1968~2017
        IUD=cUSDX(2:end,1);       % 1969~2017/1969~2018
        IVEx=cmdVVx(1:end-1,1);   % 1968~2016/1968~2017
    case 'yr0'
        IVEn=cmdVVn(1:end-1,1);   % 1968~2016/1968~2017
        IUD=cUSDX(1:end-1,1);     % 1968~2016/1968~2017
        IVEx=cmdVVx(1:end-1,1);   % 1968~2016/1968~2017
end
[cVtn,pVtn]=corr(IVEn,IUD,'Type',ccTyp);
[cVtx,pVtx]=corr(IVEx,IUD,'Type',ccTyp);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
xNVn70=iVVn;         % org
fxNVn70=dtVn;        % trend
xdNVn70=dVVtn;         % detrend
xmdNVn70=mdVVtn;       % ma3
xmdNVnn70=cmdVVn;   % norm, 1968~2016%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%-----------------
xNVx70=iVVx;         % org
fxNVx70=dtVx;        % trend
xdNVx70=dVVtx;         % detrend
xmdNVx70=mdVVtx;       % ma3
xmdNVnx70=cmdVVx;   % norm, 1968~2016%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% <0.70> : not print
%{
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.6 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,2,1,[0.05,0.05])
set(gca,'fontsize',14)
%%
drwCCP(IVEx,cVtx,IUD,'max',appNormz,'no')
%% << min >>
subplot_tight(1,2,2,[0.05,0.05])
set(gca,'fontsize',14)
%%
drwCCP(IVEn,cVtn,IUD,'min',appNormz,'no')
%%
set(gcf,'units','centimeters','position',[0 0 32 20],...
    'paperposition',[0 0 32 20]);
print(gcf,'-dpng','-r600',[savDir 'Fig.S7(a-b).png'])
close(gcf)
%%

%% << detrend ma3 norm lag-1 3cp box >>
drwLineBoxLAG(IUD,IVEx,IVEn,dspDat,dic,'no','Fig.S7(c)','no',TimeLag,savDir,useYR);
%}
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%






%% < case of rho >= 0.6 and rho >= 0.5 >
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% <0.60>
inn=inpolygon(sstXYlS(:,1),sstXYlS(:,2),savLAT60n,savLON60n);
inx=inpolygon(sstXYlS(:,1),sstXYlS(:,2),savLAT60x,savLON60x);

clear sstXYySSn sstXYlSSn sstXYySSx sstXYlSSx
sstXYySSn=sstXYyS(inn,:);
sstXYlSSn=sstXYlS(inn,:);
sstXYySSx=sstXYyS(inx,:);
sstXYlSSx=sstXYlS(inx,:);

%%
% << Volcano Number >>
clear VNSn VNSx sstVNSSn sstVNSSx
sstVNSSn=sstVNS(inn,:);
sstVNSSx=sstVNS(inx,:);
%%

for iy=srtY:endY
    idxSSn=find(sstXYySSn==iy);
    SYRn(iy-srtY+1,1)=iy;
    %----------------------------------------------------
    SVVn(iy-srtY+1,1)=sum(sstXYySSn==iy);  % OK <***
    %----------------------------------------------------
    % << Volcano Number >>
    VNSn{iy-srtY+1,1}=sstVNSSn(sstXYySSn==iy);
    %----------------------------------------------------
    idxSSx=find(sstXYySSx==iy);
    SYRx(iy-srtY+1,1)=iy;
    %----------------------------------------------------
    SVVx(iy-srtY+1,1)=sum(sstXYySSx==iy);  % OK <***
    %----------------------------------------------------
    % << Volcano Number >>
    VNSx{iy-srtY+1,1}=sstVNSSx(sstXYySSx==iy);
end

%%
% << Volcano Number >>
for ii=1:size(VNS,1)
    ivx(ii)=length(VNSx{ii,1});
    ivn(ii)=length(VNSn{ii,1});
end
nivx=max(ivx);
nivn=max(ivn);
clear VNSXX VNSNN VNSXXt VNSNNt
VNSXX=nan(size(VNS,1),nivx);
VNSNN=nan(size(VNS,1),nivn);
VNSXXt=nan(nivx,size(VNS,1));
VNSNNt=nan(nivn,size(VNS,1));
for ii=1:size(VNS,1)
    for iix=1:length(VNSx{ii})
        VNSXX(ii,iix)=VNSx{ii}(iix);
        VNSXXt(nivx-iix+1,ii)=VNSx{ii}(iix);
    end
    for iin=1:length(VNSn{ii})
        VNSNN(ii,iin)=VNSn{ii}(iin);
        VNSNNt(nivn-iin+1,ii)=VNSn{ii}(iin);
    end
end
clear VNSXXA VNSNNA VNSXXtA VNSNNtA
VNSXXA=[[srtY:endY]',VNSXX];
VNSNNA=[[srtY:endY]',VNSNN];
VNSXXtA=[VNSXXt;[srtY:endY]];
VNSNNtA=[VNSNNt;[srtY:endY]];
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata60.xlsx'],VNSXXA,2,'C9')
xlswrite([savDir 'savMXNdata60.xlsx'],VNSNNA,3,'C9')
xlswrite([savDir 'savMXNdata60.xlsx'],VNSXXtA,4,'C9')
xlswrite([savDir 'savMXNdata60.xlsx'],VNSNNtA,5,'C9')
%%

%--------------------------------------------------------------------------
iVVn=squeeze(SVVn(:,1));
iYRn=[1:length(iVVn)]';
[iVVn,dtVn,dVVtn,mdVVtn,fvn60]=fit_det_ma3(iYRn,iVVn);
iVVx=squeeze(SVVx(:,1));
iYRx=[1:length(iVVx)]';
[iVVx,dtVx,dVVtx,mdVVtx,fvx60]=fit_det_ma3(iYRx,iVVx);

iDX=USDX(:,1);   % all for ma and org
iYR=[1:length(iDX)]';
[iDX,dtD,dDXt,mdDXt,fdx60]=fit_det_ma3(iYR,iDX);

switch useYR
    case 'use18'
        cmdVVn=mdVVtn(2:end-2);   % 1968~2017
        cmdVVx=mdVVtx(2:end-2);
        %**********************
        cUSDX=USDX(2:end-1,4);
        %cUSDX=mdDXt(2:end-1);
        %**********************
    case 'use19'
        cmdVVn=mdVVtn(2:end-1);   % 1968~2018
        cmdVVx=mdVVtx(2:end-1);
        cUSDX=mdDXt(2:end-1);
end
%--------------------------------------------------------------------------
switch appNormz
    case {'yes','yes2'}
        % << normalize by z-score >>
        %N = normalize(A) returns the vectorwise z-score of the data in A with center 0 and standard deviation 1.
        cmdVVn=normalize(cmdVVn);
        cmdVVx=normalize(cmdVVx);
        cUSDX=normalize(cUSDX);
end
%%
% USDX -1t
%--------------------------------------------------------------------------
switch TimeLag
    case 'yr1'
        IVEn=cmdVVn(1:end-1,1);   % 1968~2016
        IUD=cUSDX(2:end,1);     % 1969~2017
        IVEx=cmdVVx(1:end-1,1);   % 1968~2016
    case 'yr0'
        IVEn=cmdVVn(1:end-1,1);   % 1968~2016
        IUD=cUSDX(1:end-1,1);   % 1968~2016
        IVEx=cmdVVx(1:end-1,1);   % 1968~2016
end
[cVtn,pVtn]=corr(IVEn,IUD,'Type',ccTyp);
[cVtx,pVtx]=corr(IVEx,IUD,'Type',ccTyp);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
xNVn60=iVVn;         % org
fxNVn60=dtVn;        % trend
xdNVn60=dVVtn;         % detrend
xmdNVn60=mdVVtn;       % ma3
xmdNVnn60=cmdVVn;   % norm, 1968~2016%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%-----------------
xNVx60=iVVx;         % org
fxNVx60=dtVx;        % trend
xdNVx60=dVVtx;         % detrend
xmdNVx60=mdVVtx;       % ma3
xmdNVnx60=cmdVVx;   % norm, 1968~2016%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

dspCC0506='no';
switch dspCC0506
    case 'yes'
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% <0.60>
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.6 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,2,1,[0.05,0.05])
set(gca,'fontsize',14)
%%
%drwCCP(IVEx,cVtx,IUD,'max',appNormz,'no','yes')
drwCCP(IVEx,cVtx,IUD,'max',appNormz,'no')
%% << min >>
subplot_tight(1,2,2,[0.05,0.05])
set(gca,'fontsize',14)
%%
%drwCCP(IVEn,cVtn,IUD,'min',appNormz,'no','yes')
drwCCP(IVEn,cVtn,IUD,'min',appNormz,'no')
%%
set(gcf,'units','centimeters','position',[0 0 32 20],...
    'paperposition',[0 0 32 20]);
print(gcf,'-dpng','-r600',[savDir 'Fig.S7(p0.6)c.png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% << detrend ma3 norm lag-1 3cp box >>
drwLineBoxLAG(IUD,IVEx,IVEn,dspDat,dic,'no','Fig.S7(p0.6)p','no',TimeLag,savDir,useYR);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
end


%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% <0.50>
inn=inpolygon(sstXYlS(:,1),sstXYlS(:,2),savLAT50n,savLON50n);
inx=inpolygon(sstXYlS(:,1),sstXYlS(:,2),savLAT50x,savLON50x);

clear sstXYySSn sstXYlSSn sstXYySSx sstXYlSSx
sstXYySSn=sstXYyS(inn,:);
sstXYlSSn=sstXYlS(inn,:);
sstXYySSx=sstXYyS(inx,:);
sstXYlSSx=sstXYlS(inx,:);

%%
% << Volcano Number >>
clear VNSn VNSx sstVNSSn sstVNSSx
sstVNSSn=sstVNS(inn,:);
sstVNSSx=sstVNS(inx,:);
%%


for iy=srtY:endY
    idxSSn=find(sstXYySSn==iy);
    SYRn(iy-srtY+1,1)=iy;
    %----------------------------------------------------
    SVVn(iy-srtY+1,1)=sum(sstXYySSn==iy);  % OK <***
    %----------------------------------------------------
    % << Volcano Number >>
    VNSn{iy-srtY+1,1}=sstVNSSn(sstXYySSn==iy);
    %----------------------------------------------------
    idxSSx=find(sstXYySSx==iy);
    SYRx(iy-srtY+1,1)=iy;
    %----------------------------------------------------
    SVVx(iy-srtY+1,1)=sum(sstXYySSx==iy);  % OK <***
    %----------------------------------------------------
    % << Volcano Number >>
    VNSx{iy-srtY+1,1}=sstVNSSx(sstXYySSx==iy);
end

%%
% << Volcano Number >>
for ii=1:size(VNS,1)
    ivx(ii)=length(VNSx{ii,1});
    ivn(ii)=length(VNSn{ii,1});
end
nivx=max(ivx);
nivn=max(ivn);

clear VNSXX VNSNN VNSXXt VNSNNt
VNSXX=nan(size(VNS,1),nivx);
VNSNN=nan(size(VNS,1),nivn);
VNSXXt=nan(nivx,size(VNS,1));
VNSNNt=nan(nivn,size(VNS,1));
for ii=1:size(VNS,1)
    for iix=1:length(VNSx{ii})
        VNSXX(ii,iix)=VNSx{ii}(iix);
        VNSXXt(nivx-iix+1,ii)=VNSx{ii}(iix);
    end
    for iin=1:length(VNSn{ii})
        VNSNN(ii,iin)=VNSn{ii}(iin);
        VNSNNt(nivn-iin+1,ii)=VNSn{ii}(iin);
    end
end
clear VNSXXA VNSNNA VNSXXtA VNSNNtA
VNSXXA=[[srtY:endY]',VNSXX];
VNSNNA=[[srtY:endY]',VNSNN];
VNSXXtA=[VNSXXt;[srtY:endY]];
VNSNNtA=[VNSNNt;[srtY:endY]];
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata50.xlsx'],VNSXXA,2,'C9')
xlswrite([savDir 'savMXNdata50.xlsx'],VNSNNA,3,'C9')
xlswrite([savDir 'savMXNdata50.xlsx'],VNSXXtA,4,'C9')
xlswrite([savDir 'savMXNdata50.xlsx'],VNSNNtA,5,'C9')
%%

%--------------------------------------------------------------------------
iVVn=squeeze(SVVn(:,1));
iYRn=[1:length(iVVn)]';
[iVVn,dtVn,dVVtn,mdVVtn,fvn50]=fit_det_ma3(iYRn,iVVn);

iVVx=squeeze(SVVx(:,1));
iYRx=[1:length(iVVx)]';
[iVVx,dtVx,dVVtx,mdVVtx,fvx50]=fit_det_ma3(iYRx,iVVx);

iDX=USDX(:,1);   % all for ma and org
iYR=[1:length(iDX)]';
[iDX,dtD,dDXt,mdDXt,fdx50]=fit_det_ma3(iYR,iDX);

switch useYR
    case 'use18'
        cmdVVn=mdVVtn(2:end-2);   % 1968~2017
        cmdVVx=mdVVtx(2:end-2);
        %**********************
        cUSDX=USDX(2:end-1,4);
        %cUSDX=mdDXt(2:end-1);
        %**********************
    case 'use19'
        cmdVVn=mdVVtn(2:end-1);   % 1968~2018
        cmdVVx=mdVVtx(2:end-1);
        cUSDX=mdDXt(2:end-1);
end
%--------------------------------------------------------------------------
switch appNormz
    case {'yes','yes2'}
        % << normalize by z-score >>
        %N = normalize(A) returns the vectorwise z-score of the data in A with center 0 and standard deviation 1.
        cmdVVn=normalize(cmdVVn);
        cmdVVx=normalize(cmdVVx);
        cUSDX=normalize(cUSDX);
end
%%
% USDX -1t
%--------------------------------------------------------------------------
switch TimeLag
    case 'yr1'
        IVEn=cmdVVn(1:end-1,1);   % 1968~2016
        IUD=cUSDX(2:end,1);     % 1969~2017
        IVEx=cmdVVx(1:end-1,1);   % 1968~2016
    case 'yr0'
        IVEn=cmdVVn(1:end-1,1);   % 1968~2016
        IUD=cUSDX(1:end-1,1);   % 1968~2016
        IVEx=cmdVVx(1:end-1,1);   % 1968~2016
end
[cVtn,pVtn]=corr(IVEn,IUD,'Type',ccTyp);
[cVtx,pVtx]=corr(IVEx,IUD,'Type',ccTyp);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
xNVn50=iVVn;         % org
fxNVn50=dtVn;        % trend
xdNVn50=dVVtn;         % detrend
xmdNVn50=mdVVtn;       % ma3
xmdNVnn50=cmdVVn;   % norm, 1968~2016%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%-----------------
xNVx50=iVVx;         % org
fxNVx50=dtVx;        % trend
xdNVx50=dVVtx;         % detrend
xmdNVx50=mdVVtx;       % ma3
xmdNVnx50=cmdVVx;   % norm, 1968~2016%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

switch dspCC0506
    case 'yes'
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% <0.50>
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.6 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,2,1,[0.05,0.05])
set(gca,'fontsize',14)
%%
drwCCP(IVEx,cVtx,IUD,'max',appNormz,'no')
%% << min >>
subplot_tight(1,2,2,[0.05,0.05])
set(gca,'fontsize',14)
%%
drwCCP(IVEn,cVtn,IUD,'min',appNormz,'no')
%%
set(gcf,'units','centimeters','position',[0 0 32 20],...
    'paperposition',[0 0 32 20]);
print(gcf,'-dpng','-r600',[savDir 'Fig.S7(p0.5)c.png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%

%% << detrend ma3 norm lag-1 3cp box >>
drwLineBoxLAG(IUD,IVEx,IVEn,dspDat,dic,'no','Fig.S7(p0.5)p','no',TimeLag,savDir,useYR);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
end






%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
switch dspORG
case 'yes'
 
    

%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << WEST SAMPLE2>>
%%
drwEchCirc='yes';
drwYval=0.70;
%%
% plot explain area
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.4]);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
subplot_tight(1,1,1,[0.05,0.05])
set(gca,'fontsize',16)
%%
axesm('flatplrq','grid','on',...    % equ-area
      'maplatlimit',[minLATm maxLATm],'maplonlimit',[10 190],...
      'FLatLimit',[minLATm maxLATm],'FLonLimit',[10 190],...
      'FLineWidth',6);  % Create a cylindrical equidistant map
%%
tightmap;  
framem
%%
xLoc = -3.21e5;
yLoc = 2.00e6;
scaleruler on
setm(handlem('scaleruler1'), ...
    'Units', 'km', 'RulerStyle', 'patches',  ...
    'XLoc', xLoc, 'YLoc', yLoc,'MajorTick',0:1000:2000,'TickMode','manual');
%% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
switch dspDat
    case 'CPnt'
        gh1=surfm(SLAT-dil/2,SLON-dil/2,ScV);                        
        alpha(gh1,0.95)
end
%% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
setm(gca, 'MlabelLocation', 20, 'PlabelLocation',20,...
          'MLabelParallel','north', ...
          'MeridianLabel','on', 'ParallelLabel','on',...
          'MlineLocation',20, 'PlineLocation',20)
set(gca,'fontsize',14)
v= ver('MATLAB'); 
if v.Release=="(R2020b)"
    load coastlines;
    lat=coastlat;
    long=coastlon;
else
    load coast;
end
hold on; 
%--------------------------------------------------------------------------
p01=geoshow(lat,long,'DisplayType','polygon','facecolor',landColor); % upperleft
setm(gca, 'FFaceColor', oceanColor)
%%
if ~isempty(mnSLAT)
    p30=plot3m(mnSLAT,mnSLON,12000, Nshpx,'color','k','markersize',14,'linewidth',3);
    p30.Color(4) = 0.70;
end
if ~isempty(mxSLAT)
    p31=plot3m(mxSLAT,mxSLON,12000, Pshpx,'color','k','markersize',14,'linewidth',2);
    p31.Color(4) = 0.70;
end
%%
switch setArea
    case 'circ'
        %%
        [nCirlat,nCirlon] = scircle1(mnSLAT,mnSLON,dic/2);
        %%
        if ~isempty(nCirlat)
            gh4=plot3m(nCirlat,nCirlon,10000,'k-','linewidth',10);
            gh4.Color(4) = 0.70;
        end
        [xCirlat,xCirlon] = scircle1(mxSLAT,mxSLON,dic/2);
        if ~isempty(xCirlat)
            gh5=plot3m(xCirlat,xCirlon,10000,'k-','linewidth',3);
            gh5.Color(4) = 0.40;
        end
        %%
        %------------------------------------------------------------------
        % area average
        switch dspDat
            case 'CPnt'
                %--------------------
                % min
                [nCirlatc,nCirlonc] = scircle1(mnSLATc,mnSLONc,dic/2);
                gh2=plot3m(nCirlatc,nCirlonc,10000,'k-','linewidth',6.0);
                %--------------------
                % max
                [xCirlatc,xCirlonc] = scircle1(mxSLATc,mxSLONc,dic/2);
                gh3=plot3m(xCirlatc,xCirlonc,10000,'k-','linewidth',6.0);
                gh2.Color(4) = 0.50;
                gh3.Color(4) = 0.50;
        end
        %------------------------------------------------------------------
        % min
        arclenT = distance('gc',mnSLATc,mnSLONc,SLAT,SLON);
        clear mtSLAT mtSLON
        mtSLAT=SLAT(arclenT<=dic/2);
        mtSLON=SLON(arclenT<=dic/2);
        %$$$$$$$$$$$$$$$$$$$$$$$$$$$
        nmtScV=ScV(arclenT<=dic/2);
        cnScV=zeros(size(ScV));
        cnScVn=zeros(size(ScV));
        %$$$$$$$$$$$$$$$$$$$$$$$$$$$
        iu=0;
        iuu=0;
        latUU=[];
        lonUU=[];
        %---------------------------
        iuus55=0;
        latUUs55=[];
        lonUUs55=[];
        %---------------------------
        iuus60=0;
        latUUs60=[];
        lonUUs60=[];
        %---------------------------
        iuus65=0;
        latUUs65=[];
        lonUUs65=[];
        %---------------------------
        iuus70=0;
        latUUs70=[];
        lonUUs70=[];
        for i=1:length(mtSLAT)
            [tCirlat,tCirlon] = scircle1(mtSLAT(i),mtSLON(i),dic/2);
            %$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            if nmtScV(i)<=pmLim
                switch drwEchCirc
                    case 'yes'
                        if nmtScV(i) <= -drwYval
                            if ~isempty(tCirlat)
                                gh15=plot3m(tCirlat,tCirlon,11000,'r-','linewidth',0.5);
                                gh15.Color(4) = 0.50;
                            end
                        end
                end
                %----------------------------------------------------------
                nt=sort(nmtScV); 
                if nmtScV(i)<=nt(nCir)
                end            
                %----------------------------------------------------------
                if nmtScV(i)<=-0.70
                    [latUUs70,lonUUs70,iuus70]=mkPolyLine(latUUs70,lonUUs70,tCirlat,tCirlon,iuus70);
                end
                if nmtScV(i)<=-0.65
                    [latUUs65,lonUUs65,iuus65]=mkPolyLine(latUUs65,lonUUs65,tCirlat,tCirlon,iuus65);
                end
                if nmtScV(i)<=-0.60
                    [latUUs60,lonUUs60,iuus60]=mkPolyLine(latUUs60,lonUUs60,tCirlat,tCirlon,iuus60);
                end
                if nmtScV(i)<=-0.55
                    [latUUs55,lonUUs55,iuus55]=mkPolyLine(latUUs55,lonUUs55,tCirlat,tCirlon,iuus55);
                end
            %$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            if iu==0
                [latU,lonU]=polybool('union',tCirlat,tCirlon,tCirlat,tCirlon);
            else
                [latUt,lonUt]=polybool('union',latU,lonU,tCirlat,tCirlon);
                clear latU lonU
                latU=latUt;
                lonU=lonUt;
            end
            iu=iu+1;
            %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            clear SLATt SLONt ScVt mnScV
            SLATt=SLAT;
            SLONt=SLON;
            ScVt=ScV;
            %@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
            in=inpolygon(SLAT,SLON,tCirlat,tCirlon);
            switch elmOutArea
                case 'yes'
                    ScVt(~in)=0;
            end
            ScVt(in)=nmtScV(i);
            %@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
            switch setOver
                case 'Mean'
                    cnScV=cnScV+ScVt;
                case 'MxMn'
                    cnScVn=nanmin(cnScVn,ScVt);
            end
            %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            end
        end
        %%
        if ~isempty(latUUs70)
            gh854=plot3m(latUUs70,lonUUs70,10000,'b-','linewidth',8.0);
            gh854.Color(4) = 0.40;
        end
        if ~isempty(latUUs70)
            textm(nanmin(latUUs70)+2,nanmean(lonUUs70),11000,['\rho\leq' num2str(-0.70,'%+3.1f')],'color','k','fontsize',12);
        end
        %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
        switch setOver
            case 'Mean'
                mnScV=cnScV./length(mtSLAT);
            case 'MxMn'
                mnScV=cnScVn;
        end
        %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
        % max
        arclenT = distance('gc',mxSLATc,mxSLONc,SLAT,SLON);
        clear mtSLAT mtSLON
        mtSLAT=SLAT(arclenT<=dic/2);
        mtSLON=SLON(arclenT<=dic/2);
        %$$$$$$$$$$$$$$$$$$$$$$$$$$$
        xmtScV=ScV(arclenT<=dic/2);
        cxScV=zeros(size(ScV));
        cxScVx=zeros(size(ScV));
        %$$$$$$$$$$$$$$$$$$$$$$$$$$$
        iu=0;
        iuu=0;
        latUU=[];
        lonUU=[];
        %---------------------------
        iuus55=0;
        latUUs55=[];
        lonUUs55=[];
        %---------------------------
        iuus60=0;
        latUUs60=[];
        lonUUs60=[];
        %---------------------------
        iuus65=0;
        latUUs65=[];
        lonUUs65=[];
        %---------------------------
        iuus70=0;
        latUUs70=[];
        lonUUs70=[];
        %---------------------------
        iuus75=0;
        latUUs75=[];
        lonUUs75=[];
        for i=1:length(mtSLAT)
            [tCirlat,tCirlon] = scircle1(mtSLAT(i),mtSLON(i),dic/2);
            %$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            if xmtScV(i)>=pxLim        
                switch drwEchCirc
                    case 'yes'
                        if xmtScV(i) >= drwYval
                            if ~isempty(tCirlat)
                                gh16=plot3m(tCirlat,tCirlon,11000,'r-','linewidth',0.7);
                                gh16.Color(4) = 0.50;
                            end
                        end
                end
                %----------------------------------------------------------
                xt=sort(xmtScV); 
                if xmtScV(i)>=xt(end-nCir+1)
                end
                %----------------------------------------------------------
                if xmtScV(i)>=0.70
                    [latUUs70,lonUUs70,iuus70]=mkPolyLine(latUUs70,lonUUs70,tCirlat,tCirlon,iuus70);
                end
                if xmtScV(i)>=0.65
                    [latUUs65,lonUUs65,iuus65]=mkPolyLine(latUUs65,lonUUs65,tCirlat,tCirlon,iuus65);
                end
                if xmtScV(i)>=0.60
                    [latUUs60,lonUUs60,iuus60]=mkPolyLine(latUUs60,lonUUs60,tCirlat,tCirlon,iuus60);
                end
                if xmtScV(i)>=0.55
                    [latUUs55,lonUUs55,iuus55]=mkPolyLine(latUUs55,lonUUs55,tCirlat,tCirlon,iuus55);
                end                
            %$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            if iu==0
                [latU,lonU]=polybool('union',tCirlat,tCirlon,tCirlat,tCirlon);
            else
                [latUt,lonUt]=polybool('union',latU,lonU,tCirlat,tCirlon);
                clear latU lonU
                latU=latUt;
                lonU=lonUt;
            end
            iu=iu+1;            
            %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            clear SLATt SLONt ScVt mxScV
            SLATt=SLAT;
            SLONt=SLON;
            ScVt=ScV;
            %@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
            in=inpolygon(SLAT,SLON,tCirlat,tCirlon);
            switch elmOutArea
                case 'yes'
                    ScVt(~in)=0;
            end
            ScVt(in)=xmtScV(i);
            %@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
            switch setOver
                case 'Mean'
                    cxScV=cxScV+ScVt;
                case 'MxMn'
                    cxScVx=nanmax(cxScVx,ScVt);
            end
            %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
            end
        end
        %%
        if ~isempty(latUUs70)
        gh864=plot3m(latUUs70,lonUUs70,10000,'r-','linewidth',8.0);
        gh864.Color(4) = 0.40;
        end
        %------------------------------------------------------------------
        % max
        [iix,jjx]=find(ScV==nanmax(ScV(ScV>=pxLim)));
        textm(nanmin(xCirlat)+1,nanmean(xCirlon)-5,11000,...
            ['\rho_{max}=' num2str(nanmax(ScV(ScV>=pxLim)),'%+3.2f') ', pval=' num2str(SpV(iix,jjx),'%.1E')],...
            'color','k','fontsize',12);
        if ~isempty(latUUs70)
            textm(nanmean(latUUs70)-35,nanmin(lonUUs70)+17,11000,['\rho\geq' num2str(0.70,'%+3.1f')],'color','k','fontsize',12);
        end
        %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
        switch setOver
            case 'Mean'
                mxScV=cxScV./length(mtSLAT)*2;
            case 'MxMn'
                mxScV=cxScVx;
        end
        %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
        switch dspDat
            case 'Area'
                %----------------------------------------------------------
                mgScV=mnScV+mxScV;
                %----------------------------------------------------------
                switch dspDat_clr
                    case 'yes'
                gh11=surfm(SLAT-dil/2,SLON-dil/2,mgScV);
                %----------------------------------------------------------
                alpha(gh11,.1)
                end
                %----------------------------------------------------------
                mnScVz=mnScV;
                mxScVz=mxScV;
                mnScVz(mnScVz==0)=nan;
                mxScVz(mxScVz==0)=nan;
                %-------------------------------
                xxv=nanmax(nanmax(mxScVz));
                xnv=nanmin(nanmin(mxScVz));
                xmv=nanmean(nanmean(mxScVz));
                xdv=nanmedian(nanmedian(reshape(mxScVz,size(mxScVz,1)*size(mxScVz,2),1)));
                %-------------------------------
                nxv=nanmax(nanmax(mnScVz));
                nnv=nanmin(nanmin(mnScVz));
                nmv=nanmean(nanmean(mnScVz));
                ndv=nanmedian(nanmedian(reshape(mnScVz,size(mnScVz,1)*size(mnScVz,2),1)));
                %----------------------------------------------------------
        end
        %% $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
end
%%
%--------------------------------------------------------------------------
switch cntTyp
    case 'eql'
        plot3m(SLAT(ScV>=pxLim),SLON(ScV>=pxLim),10000, Pshp,'color','r','markersize',2.3*dil*Pshpf,'linewidth',0.5);
        plot3m(SLAT(ScV<=pmLim),SLON(ScV<=pmLim),10000, Nshp,'color','b','markersize',2.3*dil*Nshpf,'linewidth',0.5);
    case 'wgt'
        if ~isempty(SLAT(ScV>=0.70))
            plot3m(SLAT(ScV>=0.70),SLON(ScV>=0.70),10000, Pshp,'color','r','markersize',2.1*dil*Pshpf,'linewidth',1.8,'MarkerFaceColor',[0.9,0.2,0.2]);
        end
end
%--------------------------------------------------------------------------
cntPlus='HiCCarea';
switch cntPlus
    case 'Global'
%--------------------------------------------------------------
    case 'HiCCarea'
% only sel circle area
xGA=sum(SLAT(mxScV>=pxLim).*mxScV(mxScV>=pxLim))/sum(mxScV(mxScV>=pxLim))
xGO=sum(SLON(mxScV>=pxLim).*mxScV(mxScV>=pxLim))/sum(mxScV(mxScV>=pxLim))
nGA=sum(SLAT(mnScV<=pmLim).*mnScV(mnScV<=pmLim))/sum(mnScV(mnScV<=pmLim))
nGO=sum(SLON(mnScV<=pmLim).*mnScV(mnScV<=pmLim))/sum(mnScV(mnScV<=pmLim))
end
gh20.Color(4) = 0.30;
gh21.Color(4) = 0.30;
%%
switch setCmap
    case 'jet'
        colormap(jet(32))
    case 'RnB'
        %------------------------------------
        Red=flipud(brewermap(8,'*Reds'));
        Blu=brewermap(8,'*Blues');
        RB=[Blu;Red];
        colormap(RB)
end
%%
drwCbar='no';
switch drwCbar
    case 'yes'
        t=colorbar('southoutside');
        a=get(t);
        a=a.Position;
        set(t,'Position',[a(1) a(2)-0.1 0.50 0.01]);
        %--------------------------------------------------
        caxis([-0.8 0.8])
        set(t,'fontsize',10);
        xlabel(t,'Correlation coefficient','fontsize',10)
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
vLato=sstXYlS(:,1);
vLono=sstXYlS(:,2);

vLato(sstXYyS<srtY)=[];
vLono(sstXYyS<srtY)=[];

vLono(isnan(vLato))=[];
vLato(isnan(vLato))=[];
vLato(isnan(vLono))=[];
vLono(isnan(vLono))=[];

[B,I]=sort(vLato);
vLats=B;
vLons=vLono(I);

[c1,ia1,ic1]=unique(vLats,'stable');
vLat=c1;
vLon=vLons(ia1);

% count eruptions at each points
cntPos1=ia1;
cntPos2=[ia1(2:end);length(vLats)];
cntPos=cntPos2-cntPos1;
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
tcntPos=cntPos;
tcntPos(tcntPos==0)=nan;
gh50=scatterm(vLat,vLon,tcntPos.^1.7,'Marker',Vshp,'MarkerEdgeColor',mkredgclr,'MarkerFaceColor',mkrfceclr);
gh50.Children.MarkerFaceAlpha = 5/8;
%%
ilat=[minLAT:dil:0 0:dil:maxLAT];
ilon=[minLON:dil:0 0:dil:maxLON];
[xlat,xlon]=meshgrid(ilat,ilon);
if ~isempty(xlat)
    gh910=plot3m(xlat,xlon,5000*ones(size(xlat)),'+','color',[0.7 0.7 0.7],'markersize',4,'linewidth',0.5);
end
%%
%--------------------------------------------------------------------------
sctLgnd=[5:5:45];
sctLAT=ones(size(sctLgnd))*minLATm;
sctLON=sctLgnd-260;
gh50=scatterm(sctLAT+10,sctLON,sctLgnd.^1.7,'Marker',Vshp,'MarkerEdgeColor',mkredgclr,'MarkerFaceColor',mkrfceclr);
%--------------------------------------------------------------------------
for i=1:length(sctLgnd)
    textm(sctLAT(i)+5,sctLON(i)-1,11000,num2str(sctLgnd(i),'%+2.0f'),'color','k','fontsize',9,'FontName','d2coding');
end
%--------------------------------------------------------------------------
textm(minLATm+16,sctLON(1)+9,11000,'NVOL (1967-2019 AD)','color','k','fontsize',10,'FontName','d2coding');
plot3m([minLATm minLATm+14 minLATm+14 minLATm minLATm],...
       [sctLON(1)+1 sctLON(1)+1 sctLON(1)+52 sctLON(1)+52 sctLON(1)+1]-5,11000, 'k-','linewidth',2.0);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
whitebg(gcf,'w');
%%
set(gcf,'units','centimeters','position',[0 0 51 20],...
    'paperposition',[0 0 51 20]);
print(gcf,'-dpng','-r800',[savDir 'Fig.S1.png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << (1) org >>
%-----------------------------------------------
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,1,1,[0.07,0.07])
%------------------------------------------
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes

ax1.XColor = 'r';
ax1.YColor = 'r';

hold on; box on; grid on
set(ax1,'fontsize',12)

if ~isempty(xNV)
%p450=plot(ax1,[1967:2019],xNV,'r^-.','markeredgecolor','r','markerfacecolor','w','linewidth',1.0,'markersize',4);
p450=plot(ax1,[1967:2020],xNV,'r^-.','markeredgecolor','r','markerfacecolor','w','linewidth',1.0,'markersize',4);
end

if ~isempty(fxNV)
%p451=plot(ax1,[1967:2019],fxNV,'r-','linewidth',4.0);
p451=plot(ax1,[1967:2020],fxNV,'r-','linewidth',4.0);
p451.Color(4) = 0.60;
end

set(ax1,'TickDir','out')

xlabel(ax1,'Year');
ylabel(ax1,'NVOL');

%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xna=[4 24];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

%axis(ax1,[1967 2019 xna(1) xna(2)])
%xlim(ax1,[1967 2019])
axis(ax1,[1967 2020 xna(1) xna(2)])
xlim(ax1,[1967 2020])

pbaspect([2.5 1 1])
%%
%--------------------------------------------------------------------------
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes
ax2 = axes('Position',ax2_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');

hold on; box on; grid on
set(ax2,'fontsize',12)
%**************************************************************************
switch useYR
    case 'use18'
        %iyro=[1967:2018]';
        iyro=[1967:2019]';
    case 'use19'
        %iyro=[1967:2019]';
        iyro=[1967:2020]';
end
%**************************************************************************
if ~isempty(xUD)
p452=plot(ax2,iyro,xUD,'ko-','markeredgecolor','k','markerfacecolor','w','linewidth',1.0,'markersize',4);
end

if ~isempty(fxUD)
p453=plot(ax2,iyro,fxUD,'k-','linewidth',4.0);
p453.Color(4) = 0.60;
end

xlabel(ax2,'Year');
ylabel(ax2,'USDX');
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[60 160];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
%axis(ax2,[1967 2019 yna(1) yna(2)])
%xlim(ax2,[1967 2019])
axis(ax2,[1967 2020 yna(1) yna(2)])
xlim(ax2,[1967 2020])
pbaspect([2.5 1 1])
%%
legend([p450,p451,p452,p453],{'NVOL','NVOL_{trend}','USDX','USDX_{trend}'})

set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir 'Fig.S2.png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% << (2) detrend >>
%-----------------------------------------------
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,1,1,[0.07,0.07])
%------------------------
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes

ax1.XColor = 'r';
ax1.YColor = 'r';

hold on; box on; grid on
set(ax1,'fontsize',12)

if ~isempty(xdNV)
%p450=plot(ax1,[1967:2019],xdNV,'r^-.','markeredgecolor','r','markerfacecolor','w','linewidth',1.0,'markersize',4);
p450=plot(ax1,[1967:2020],xdNV,'r^-.','markeredgecolor','r','markerfacecolor','w','linewidth',1.0,'markersize',4);
end

set(ax1,'TickDir','out')

xlabel(ax1,'Year');
ylabel(ax1,'Detrended NVOL');

%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xna=[-6 10];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

%axis(ax1,[1967 2019 xna(1) xna(2)])
%xlim(ax1,[1967 2019])
axis(ax1,[1967 2020 xna(1) xna(2)])
xlim(ax1,[1967 2020])

pbaspect([2.5 1 1])
%%
%--------------------------------------------------------------------------
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes
ax2 = axes('Position',ax2_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');

hold on; box on; grid on
set(ax2,'fontsize',12)

if ~isempty(xdUD)
p452=plot(ax2,iyro,xdUD,'ko-','markeredgecolor','k','markerfacecolor','w','linewidth',1.0,'markersize',4);
end

xlabel(ax2,'Year');
ylabel(ax2,'Detrended USDX');
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[-30 50];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
%axis(ax2,[1967 2019 yna(1) yna(2)])
%xlim(ax2,[1967 2019])
axis(ax2,[1967 2020 yna(1) yna(2)])
xlim(ax2,[1967 2020])
pbaspect([2.5 1 1])
%%
legend([p450,p452],{'NVOL_{detrend}','USDX_{detrend}'})

set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir 'Fig.S3.png'])
close(gcf)
%%



%% << (3) detrend ma3 >>
%-----------------------------------------------
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,1,1,[0.07,0.07])
%------------------------------------------
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes

ax1.XColor = 'r';
ax1.YColor = 'r';

hold on; box on; grid on
set(ax1,'fontsize',12)

if ~isempty(xdNV)
%p450=plot(ax1,[1967:2019],xdNV,'r^-.','markeredgecolor','r','markerfacecolor','w','linewidth',1.0,'markersize',4);
p450=plot(ax1,[1967:2020],xdNV,'r^-.','markeredgecolor','r','markerfacecolor','w','linewidth',1.0,'markersize',4);
end

if ~isempty(xmdNV)
%p451=plot(ax1,[1967:2019],xmdNV,'r-','linewidth',10.0);
%p451.Color(4) = 0.50;
%p4511=plot(ax1,[1967:2019],xmdNV,'^','markeredgecolor','y','markerfacecolor','r','linewidth',1.0,'markersize',3);
p451=plot(ax1,[1967:2020],xmdNV,'r-','linewidth',10.0);
p451.Color(4) = 0.50;
p4511=plot(ax1,[1967:2020],xmdNV,'^','markeredgecolor','y','markerfacecolor','r','linewidth',1.0,'markersize',3);
end

set(ax1,'TickDir','out')

xlabel(ax1,'Year');
ylabel(ax1,'Detrended NVOL');

%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xna=[-6 10];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

%axis(ax1,[1967 2019 xna(1) xna(2)])
%xlim(ax1,[1967 2019])
axis(ax1,[1967 2020 xna(1) xna(2)])
xlim(ax1,[1967 2020])

pbaspect([2.5 1 1])
%%
%--------------------------------------------------------------------------
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes
ax2 = axes('Position',ax2_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');

hold on; box on; grid on
set(ax2,'fontsize',12)

if ~isempty(xdUD)
p452=plot(ax2,iyro,xdUD,'ko-','markeredgecolor','k','markerfacecolor','w','linewidth',1.0,'markersize',4);
end

if ~isempty(xmdUD)
p453=plot(ax2,iyro,xmdUD,'b-','linewidth',10.0);
p453.Color(4) = 0.50;
p4531=plot(ax2,iyro,xmdUD,'o','markeredgecolor','y','markerfacecolor','b','linewidth',1.0,'markersize',3);
end

xlabel(ax2,'Year');
ylabel(ax2,'Detrended USDX');
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[-30 50];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
%axis(ax2,[1967 2019 yna(1) yna(2)])
%xlim(ax2,[1967 2019])
axis(ax2,[1967 2020 yna(1) yna(2)])
xlim(ax2,[1967 2020])
pbaspect([2.5 1 1])
%%
legend([p450,p451,p452,p453],{'NVOL_{detrend}','NVOL_{MA3}','USDX_{detrend}','USDX_{MA3}'},'Location','northwest')

set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir 'Fig.S4.png'])
close(gcf)
%%



%% << (4) detrend ma3 norm>>
%-----------------------------------------------
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,1,1,[0.07,0.07])
%------------------------------------------
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes

ax1.XColor = 'r';
ax1.YColor = 'r';

hold on; box on; grid on
set(ax1,'fontsize',12)

%**************************************************************************
switch useYR
    case 'use18'
        %iyro3=[1968:2016]';
        iyro3=[1968:2017]';
    case 'use19'
        %iyro3=[1968:2017]';
        iyro3=[1968:2018]';
end
%**************************************************************************

if ~isempty(xmdNVn)
p451=plot(ax1,iyro3,xmdNVn,'r-','linewidth',10.0);
p451.Color(4) = 0.50;
p4511=plot(ax1,iyro3,xmdNVn,'^','markeredgecolor','y','markerfacecolor','r','linewidth',1.0,'markersize',3);
end

set(ax1,'TickDir','out')

xlabel(ax1,'Year');
ylabel(ax1,'Detrended NVOL');

%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xna=[-3 3];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

%axis(ax1,[1967 2019 xna(1) xna(2)])
%xlim(ax1,[1967 2019])
axis(ax1,[1967 2020 xna(1) xna(2)])
xlim(ax1,[1967 2020])

pbaspect([2.5 1 1])
%%
%--------------------------------------------------------------------------
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes
ax2 = axes('Position',ax2_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');

hold on; box on; grid on
set(ax2,'fontsize',12)

if ~isempty(xmdUDn)
%**************************************************************************    
UDlag='yet';
switch UDlag
    case 'pre'
p453=plot(ax2,iyro3+1,xmdUDn,'b-','linewidth',10.0); 
p453.Color(4) = 0.50;
p4531=plot(ax2,iyro3+1,xmdUDn,'o','markeredgecolor','y','markerfacecolor','b','linewidth',1.0,'markersize',3);
    case 'yet'
%--------------------------------------------------------------------------
p453=plot(ax2,iyro3,cUSDX(1:end-1),'b-','linewidth',10.0); % 1968~2016/1968~2017*
p453.Color(4) = 0.50;
p4531=plot(ax2,iyro3,cUSDX(1:end-1),'o','markeredgecolor','y','markerfacecolor','b','linewidth',1.0,'markersize',3);
end
%**************************************************************************    
end

xlabel(ax2,'Year');
ylabel(ax2,'Detrended USDX');
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[-3 3];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
%axis(ax2,[1967 2019 yna(1) yna(2)])
%xlim(ax2,[1967 2019])
axis(ax2,[1967 2020 yna(1) yna(2)])
xlim(ax2,[1967 2020])
pbaspect([2.5 1 1])
%%
legend([p451,p453],{'NVOL_{z-score}','USDX_{z-score}'})

set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir 'Fig.S5.png'])
close(gcf)
%%



%% << (5) detrend ma3 norm lag-1 >>
%-----------------------------------------------
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%% << max >>
subplot_tight(1,1,1,[0.07,0.07])
%------------------------------------------
ax1 = gca; % current axes
ax1_pos = ax1.Position; % position of first axes

ax1.XColor = 'r';
ax1.YColor = 'r';

hold on; box on; grid on
set(ax1,'fontsize',12)

if ~isempty(xmdNVn)
p451=plot(ax1,iyro3,xmdNVn,'r-','linewidth',10.0);
p451.Color(4) = 0.50;
p4511=plot(ax1,iyro3,xmdNVn,'^','markeredgecolor','y','markerfacecolor','r','linewidth',1.0,'markersize',3);
end

set(ax1,'TickDir','out')

xlabel(ax1,'Year');
ylabel(ax1,'Detrended NVOL');

%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
xna=[-3 3];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

%axis(ax1,[1967 2019 xna(1) xna(2)])
%xlim(ax1,[1967 2019])
axis(ax1,[1967 2020 xna(1) xna(2)])
xlim(ax1,[1967 2020])

pbaspect([2.5 1 1])
%%
%--------------------------------------------------------------------------
ax2 = gca; % current axes
ax2_pos = ax2.Position; % position of first axes
ax2 = axes('Position',ax2_pos,...
    'XAxisLocation','top',...
    'YAxisLocation','right',...
    'Color','none',...
    'box','off');

hold on; box on; grid on
set(ax2,'fontsize',12)

switch TimeLag
    case 'yr1'
        %******************************************************************
        yUDg=iyro3+1;
        %******************************************************************
    case 'yr0'
        yUDg=iyro3;
end
if ~isempty(xmdUDn)
%**************************************************************************
switch UDlag
case 'pre'
p453=plot(ax2,yUDg',xmdUDn,'b-','linewidth',10.0);
p453.Color(4) = 0.50;
p4531=plot(ax2,yUDg',xmdUDn,'o','markeredgecolor','y','markerfacecolor','b','linewidth',1.0,'markersize',3);
    case 'yet'
p453=plot(ax2,iyro3',cUSDX(1:end-1),'b-','linewidth',10.0); % 1968~2016/1968~2017*
p453.Color(4) = 0.50;
p4531=plot(ax2,iyro3',cUSDX(1:end-1),'o','markeredgecolor','y','markerfacecolor','b','linewidth',1.0,'markersize',3);
end
%**************************************************************************
end

xlabel(ax2,'Year');
ylabel(ax2,'Detrended USDX');
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
yna=[-3 3];
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
%axis(ax2,[1968 2020 yna(1) yna(2)])
%xlim(ax2,[1968 2020])
axis(ax2,[1968 2021 yna(1) yna(2)])
xlim(ax2,[1968 2021])
pbaspect([2.5 1 1])
%%
legend([p451,p453],{'NVOL_{z-score}','USDX_{z-score}'})

set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r800',[savDir 'Fig.S6.png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << save excel >>
Thead={'Year','Raw', 'Trend', 'Detrend', 'MA3', 'z-score',...
              'Raw', 'Trend', 'Detrend', 'MA3', 'z-score',...
              'Raw', 'Trend', 'Detrend', 'MA3', 'z-score'};
% Trend, Detrend, MA3, z-score,
%savDat=[[1967:2019]',...
savDat=[[1967:2020]',...
    xNV,fxNV,xdNV,[nan;xmdNV(2:end-1,1);nan],[nan;xmdNVn_nolag6818;nan],...
    nNV,fnNV,ndNV,[nan;nmdNV(2:end-1,1);nan],[nan;nmdNVn_nolag6818;nan],...
    xUD,fxUD,xdUD,[nan;xmdUD(2:end-1,1);nan],[nan;xmdUDn_nolag6818;nan]];
%--------------------------------------------------------------------------
dat_cel=num2cell(savDat);     
savDatT=[Thead;dat_cel];
xlswrite([savDir 'savMXNdata.xlsx'],savDatT,1,'C8')
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata.xlsx'],d3xNV,1,'E3')
xlswrite([savDir 'savMXNdata.xlsx'],d3nNV,1,'J3')
xlswrite([savDir 'savMXNdata.xlsx'],d3UD,1,'O3')
%% <0.70>
%savDat70=[[1967:2019]',...
savDat70=[[1967:2020]',...
xNVx70,fxNVx70,xdNVx70,[nan;xmdNVx70(2:end-1,1);nan],[nan;xmdNVnx70;nan],...
xNVn70,fxNVn70,xdNVn70,[nan;xmdNVn70(2:end-1,1);nan],[nan;xmdNVnn70;nan],...
xUD,fxUD,xdUD,[nan;xmdUD(2:end-1,1);nan],[nan;xmdUDn_nolag6818;nan]];
%--------------------------------------------------------------------------
dat_cel70=num2cell(savDat70);     
savDatT70=[Thead;dat_cel70];
xlswrite([savDir 'savMXNdata70.xlsx'],savDatT70,1,'C8')
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata70.xlsx'],[fvx70.p1;fvx70.p2;fvx70.p3;fvx70.p4],1,'E3')
xlswrite([savDir 'savMXNdata70.xlsx'],[fvn70.p1;fvn70.p2;fvn70.p3;fvn70.p4],1,'J3')
xlswrite([savDir 'savMXNdata70.xlsx'],[fdx70.p1;fdx70.p2;fdx70.p3;fdx70.p4],1,'O3')
%% <0.60>
%savDat60=[[1967:2019]',...
savDat60=[[1967:2020]',...
xNVx60,fxNVx60,xdNVx60,[nan;xmdNVx60(2:end-1,1);nan],[nan;xmdNVnx60;nan],...
xNVn60,fxNVn60,xdNVn60,[nan;xmdNVn60(2:end-1,1);nan],[nan;xmdNVnn60;nan],...
xUD,fxUD,xdUD,[nan;xmdUD(2:end-1,1);nan],[nan;xmdUDn_nolag6818;nan]];
%--------------------------------------------------------------------------
dat_cel60=num2cell(savDat60);     
savDatT60=[Thead;dat_cel60];
xlswrite([savDir 'savMXNdata60.xlsx'],savDatT60,1,'C8')
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata60.xlsx'],[fvx60.p1;fvx60.p2;fvx60.p3;fvx60.p4],1,'E3')
xlswrite([savDir 'savMXNdata60.xlsx'],[fvn60.p1;fvn60.p2;fvn60.p3;fvn60.p4],1,'J3')
xlswrite([savDir 'savMXNdata60.xlsx'],[fdx60.p1;fdx60.p2;fdx60.p3;fdx60.p4],1,'O3')
%% <0.50>
%savDat50=[[1967:2019]',...
savDat50=[[1967:2020]',...
xNVx50,fxNVx50,xdNVx50,[nan;xmdNVx50(2:end-1,1);nan],[nan;xmdNVnx50;nan],...
xNVn50,fxNVn50,xdNVn50,[nan;xmdNVn50(2:end-1,1);nan],[nan;xmdNVnn50;nan],...
xUD,fxUD,xdUD,[nan;xmdUD(2:end-1,1);nan],[nan;xmdUDn_nolag6818;nan]];
%--------------------------------------------------------------------------
dat_cel50=num2cell(savDat50);     
savDatT50=[Thead;dat_cel50];
xlswrite([savDir 'savMXNdata50.xlsx'],savDatT50,1,'C8')
%--------------------------------------------------------------------------
xlswrite([savDir 'savMXNdata50.xlsx'],[fvx50.p1;fvx50.p2;fvx50.p3;fvx50.p4],1,'E3')
xlswrite([savDir 'savMXNdata50.xlsx'],[fvn50.p1;fvn50.p2;fvn50.p3;fvn50.p4],1,'J3')
xlswrite([savDir 'savMXNdata50.xlsx'],[fdx50.p1;fdx50.p2;fdx50.p3;fdx50.p4],1,'O3')
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << cross correlation >>
[Vxv,Dxv]=xcorr(xmdNVn_nolag6818,xmdUDn_nolag6818,'coeff');
[Vnv,Dnv]=xcorr(nmdNVn_nolag6818,xmdUDn_nolag6818,'coeff');
%%
%--------------------------------------------------------------------------
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
box on
%-------------------------
grid on
ax = gca;
ax.GridColor = [.2 .2 .2];
ax.GridLineStyle = '--';
ax.GridAlpha = 0.8;
%-------------------------
hold on
set(gca,'fontsize',16)
%--------------------------------------------------------------------------
p1001=bar(Dxv,Vxv,'r','barwidth',1.0,'EdgeColor','r','LineWidth',2);
p1002=bar(Dnv,Vnv,'b','barwidth',1.0,'EdgeColor','b','LineWidth',2);
set(p1001,'facealpha',.3)
set(p1002,'facealpha',.3)
%--------------------------------------------------------------------------
for ik=1:length(Dxv)
    if Vxv(ik)==max(Vxv)
        text(Dxv(ik)-1.8,Vxv(ik)+0.1,num2str(Dxv(ik),'%+3.0f'),'color','r','fontsize',14);
        plot(Dxv(ik),Vxv(ik)+0.04,'v','color','k','markerfacecolor','k','markersize',7);
    
    elseif rem(Dxv(ik),16)==0 & Dxv(ik)~=0
        if Vxv(ik)>=0
            [mx3v,mx3i]=max(abs([Vxv(ik-2) Vxv(ik-1) Vxv(ik) Vxv(ik+1) Vxv(ik+2)]));
            ikx=ik+mx3i-3;
            plot(Dxv(ikx),Vxv(ikx)+0.03,'*','color','r','markersize',6);
        else
            [mx3v,mx3i]=max(abs([Vxv(ik-2) Vxv(ik-1) Vxv(ik) Vxv(ik+1) Vxv(ik+2)]));
            ikx=ik+mx3i-3;
            plot(Dxv(ikx),Vxv(ikx)-0.03,'*','color','r','markersize',6);
        end
        
    end
    %----------------------------------------------------------------------
    if Vnv(ik)==min(Vnv)
        text(Dnv(ik)-1.8,Vnv(ik)-0.1,num2str(Dnv(ik),'%+3.0f'),'color','b','fontsize',14);
        plot(Dnv(ik),Vnv(ik)-0.04,'^','color','k','markerfacecolor','k','markersize',7);
    elseif rem(Dnv(ik),16)==0 & Dnv(ik)~=0
        if Vnv(ik)>=0
            [mx3v,mx3i]=max(abs([Vnv(ik-2) Vnv(ik-1) Vnv(ik) Vnv(ik+1) Vnv(ik+2)]));
            ikx=ik+mx3i-3;
            plot(Dnv(ikx),Vnv(ikx)+0.03,'*','color','b','markersize',6);
        else
            [mx3v,mx3i]=max(abs([Vnv(ik-2) Vnv(ik-1) Vnv(ik) Vnv(ik+1) Vnv(ik+2)]));
            ikx=ik+mx3i-3;
            plot(Dnv(ikx),Vnv(ikx)-0.03,'*','color','b','markersize',6);
        end
    end
end
%--------------------------------------------------------------------------
set(gca,'xtick',[-48:8:48])
set(gca,'ytick',[-0.8:0.2:0.8])
xlim([-45 45])
ylim([-0.95 0.95])
%--------------------------------------------------------------------------
legend([p1001,p1002],{'NVOL(W) (\rho_{max}) vs USDX','NVOL(E) (\rho_{min}) vs USDX'},'FontSize',12)
xlabel('Lag (year)');
ylabel('Cross correlation coefficient');
%--------------------------------------------------------------------------
set(gcf,'units','centimeters','position',[0 0 25 15],...
    'paperposition',[0 0 25 15]);
print(gcf,'-dpng','-r600',[savDir 'Fig.2(a).png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << detrend ma3 norm lag-1 3cp box >>
%drwLineBoxLAG(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','3p_de_ma3_nm_lg_3cp_el2_env_peak','peak',TimeLag,savDir,useYR);
%drwLineBoxLAGR(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)','peak',TimeLag,savDir,useYR);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%



%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << CC min vs max >>
scrsz = get(0,'ScreenSize');
figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
%%
set(gca,'fontsize',16)
%------------------------
box on
grid on
hold on
%------------------------
if ~isempty(mnVV)
p403 = plot(mnVV,xmdNVn,'ko','MarkerSize',5,'LineWidth',1.5,'MarkerFaceColor','k');
p403.Color(4) = 0.50;
end
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
switch appNormz
    case 'yes'
        xna=[-3 3.5];
        yna=[-3 3.5];
    case 'yes2'
        xna=[-3.5 3.5];
        yna=[-3.5 3.5];
    otherwise
        xna=[-200 200];
        yna=[-30 40];
end
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
line(xna,yna,'Color','k','LineStyle','--','LineWidth',0.5);
f=fit(mnVV,xmdNVn,'poly1');
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
switch appNormz
    case {'yes','yes2'}
        Bxx=[xna(1):0.1:xna(2)]';
    otherwise
        Bxx=[xna(1):10:xna(2)]';
end
if ~isempty(Bxx)
p404=plot(Bxx,f.p1*Bxx+f.p2,'Color','b','LineStyle','-','LineWidth',1.0);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
p404.Color(4) = 0.50;
end
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
[Bx,Ix] = sort(mnVV);
yy=xmdNVn;
By = yy(Ix);
[p,S] = polyfit(Bx,By,1);
%--------------------------------------------------------------------------
% <confidence interval>
[y_fit,delta]=polyconf(p,Bxx,S,'alpha',0.05);
plot(Bxx,y_fit+delta,'b--',Bxx,y_fit-delta,'b--','LineWidth',1.0)
%--------------------------------------------------------------------------
h22 = patch([Bxx' fliplr(Bxx')],[(y_fit-delta)' fliplr((y_fit+delta)')],[0.7 .7 1]);
set(h22,'EdgeColor','none');
alpha(h22,0.2);
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
[cV3,pV3]=corrcoef(mnVV,xmdNVn);
text(xna(1)*0.95,yna(2)*1.07,['\rho=' num2str(cV3(1,2),'%+3.2f') ', NVOL(E) (\rho_{min}) vs NVOL(W) (\rho_{max})'],...
    'color','k','fontsize',14,'FontName','d2coding');
xlim(xna)
ylim(yna)
grid on
pbaspect([1 1 1])
%--------------------------------------------------------------------------
xlabel('Detrended NVOL(E)');
ylabel('Detrended NVOL(W)');
%--------------------------------------------------------------------------
set(gca,'fontsize',16)
%%
set(gcf,'units','centimeters','position',[0 0 15 15],...
    'paperposition',[0 0 15 15]);
print(gcf,'-dpng','-r600',[savDir 'Fig.2(c).png'])
close(gcf)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
























%%
%% << detrend ma3 norm lag-1 3cp box >>
%--------------------------------------------------------------------------
% << PDO & SOI & Palmer Z-Index & MEI & Tmax & Prec >>
sstPS = xlsread('.\data_in\data_PDO_SOI_PZI.xlsx','Ann','C4:D57'); 
sstPDO=sstPS(:,1);      % 1967~2019 PDO
sstSOI=sstPS(:,2);      % 1967~2019 SOI
%**************************************************************************
%selPeriod='All_8603';
selPeriod='All_9203';
%selPeriod='PDO_9203_ELS_8603';
%**************************************************************************
% ma3
[iDXP,dtDP,dDXtP,mdDXtP,fdP]=fit_det_ma3(iYR,sstPDO);
mdPDOt=normalize(mdDXtP(2:end-1)); % 1968~2019
[iDXS,dtDS,dDXtS,mdDXtS,fdS]=fit_det_ma3(iYR,sstSOI);
mdSOIt=normalize(mdDXtS(2:end-1)); % 1968~2019
%-------------------------------------------------------
mdPDO=mdPDOt(1:end-1); % 1968~2018
mdSOI=mdSOIt(1:end-1); % 1968~2018
%--------------------------------------------------------------------------
% org
mdPDOo=sstPDO(2:end-2,1); % 1968~2018
mdSOIo=sstSOI(2:end-2,1); % 1968~2018
%%
dspCLIM='no';
switch dspCLIM
    case 'yes'
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDO','no',TimeLag,savDir,useYR,mdPDO,'PDO');
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOI','no',TimeLag,savDir,useYR,mdSOI,'SOI');
        %--------------------------------------------------------------------------
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOo','no',TimeLag,savDir,useYR,mdPDOo,'PDO');
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIo','no',TimeLag,savDir,useYR,mdSOIo,'SOI');
        %% <envelop>
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOe','no',TimeLag,savDir,useYR,mdPDO,mdPDO,'PDO',selPeriod);
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIe','no',TimeLag,savDir,useYR,mdSOI,mdSOI,'SOI',selPeriod);
        %--------------------------------------------------------------------------
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOoe','no',TimeLag,savDir,useYR,mdPDOo,mdPDOo,'PDO',selPeriod);
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIoe','no',TimeLag,savDir,useYR,mdSOIo,mdSOIo,'SOI',selPeriod);
end
%%

%%
%% << save excel >>
clear d3P d3S d3Z d3T d3A
d3P(1,1)=fdP.p1;
d3P(2,1)=fdP.p2;
d3P(3,1)=fdP.p3;
d3P(4,1)=fdP.p4;
%---------------
d3S(1,1)=fdS.p1;
d3S(2,1)=fdS.p2;
d3S(3,1)=fdS.p3;
d3S(4,1)=fdS.p4;
%--------------------------------------------------------------------------
Thead={'Year','Raw', 'Trend', 'Detrend', 'MA3', 'z-score',...
              'Raw', 'Trend', 'Detrend', 'MA3', 'z-score'};
% Trend, Detrend, MA3, z-score,
savDat=[[1967:2020]',...
    iDXP,dtDP,dDXtP,[nan;mdDXtP(2:end-1,1);nan],[nan;mdPDOt;nan],...
    iDXS,dtDS,dDXtS,[nan;mdDXtS(2:end-1,1);nan],[nan;mdSOIt;nan]];
%--------------------------------------------------------------------------
dat_cel=num2cell(savDat);     
savDatT=[Thead;dat_cel];
xlswrite([savDir 'savIDXdata.xlsx'],savDatT,1,'C8')
%--------------------------------------------------------------------------
xlswrite([savDir 'savIDXdata.xlsx'],d3P,1,'E3')
xlswrite([savDir 'savIDXdata.xlsx'],d3S,1,'J3')
%%
%%


%%
%% <revert>
% 1968~2019
%**************************************************************************
ix_9203_1=1:24;
ix_9203_2=25:36;
ix_9203_3=37:51;
%----------------
ix_8603_1=1:18;
ix_8603_2=19:36;
ix_8603_3=37:51;
%--------------------------------------------------------------------------
switch selPeriod
    case 'All_8603'
        %-------------------
        ix_PDO_1=ix_8603_1; % 1986-2003
        ix_PDO_2=ix_8603_2;
        ix_PDO_3=ix_8603_3;
        %-------------------
        ix_SOI_1=ix_8603_1;
        ix_SOI_2=ix_8603_2;
        ix_SOI_3=ix_8603_3;
        %-------------------
    case 'All_9203'
        %-------------------
        ix_PDO_1=ix_9203_1; % 1992-2003
        ix_PDO_2=ix_9203_2;
        ix_PDO_3=ix_9203_3;
        %-------------------
        ix_SOI_1=ix_9203_1;
        ix_SOI_2=ix_9203_2;
        ix_SOI_3=ix_9203_3;
        %-------------------
    case 'PDO_9203_ELS_8603'
        %-------------------
        ix_PDO_1=ix_9203_1; % 1992-2003
        ix_PDO_2=ix_9203_2;
        ix_PDO_3=ix_9203_3;
        %-------------------
        ix_SOI_1=ix_8603_1; % 1986-2003
        ix_SOI_2=ix_8603_2;
        ix_SOI_3=ix_8603_3;
        %-------------------
end  
%--------------------------------------------------------------------------
% <ma3>
mdPDOr=[mdPDO(ix_PDO_1);-mdPDO(ix_PDO_2);mdPDO(ix_PDO_3)];    
mdSOIr=[mdSOI(ix_SOI_1);-mdSOI(ix_SOI_2);mdSOI(ix_SOI_3)];   
%----------------------------------------------------------
% <org>
mdPDOor=[mdPDOo(ix_PDO_1);-mdPDOo(ix_PDO_2);mdPDOo(ix_PDO_3)];    
mdSOIor=[mdSOIo(ix_SOI_1);-mdSOIo(ix_SOI_2);mdSOIo(ix_SOI_3)];   
%%
%--------------------------------------------------------------------------
[cVP,pVP]=corr(xmdNVn,mdPDO,'Type',ccTyp);
[cVS,pVS]=corr(xmdNVn,mdSOI,'Type',ccTyp);
%--------------------------------------------
[cVPr,pVPr]=corr(xmdNVn,mdPDOr,'Type',ccTyp);
[cVSr,pVSr]=corr(xmdNVn,mdSOIr,'Type',ccTyp);
%--------------------------------------------------------------------------
[cVPo,pVPo]=corr(xmdNVn,mdPDOo,'Type',ccTyp);
[cVSo,pVSo]=corr(xmdNVn,mdSOIo,'Type',ccTyp);
%--------------------------------------------
[cVPor,pVPor]=corr(xmdNVn,mdPDOor,'Type',ccTyp);
[cVSor,pVSor]=corr(xmdNVn,mdSOIor,'Type',ccTyp);
%%


%%
switch dspCLIM
    case 'yes'
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOr','no',TimeLag,savDir,useYR,mdPDOr,'PDO');
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIr','no',TimeLag,savDir,useYR,mdSOIr,'SOI');
        %--------------------------------------------------------------------------
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOor','no',TimeLag,savDir,useYR,mdPDOor,'PDO');
        drwLineBoxLAGR_IDX(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIor','no',TimeLag,savDir,useYR,mdSOIor,'SOI');
        %% <envelop>
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOre','no',TimeLag,savDir,useYR,mdPDO,mdPDOr,'PDO',selPeriod);
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIre','no',TimeLag,savDir,useYR,mdSOI,mdSOIr,'SOI',selPeriod);
        %--------------------------------------------------------------------------
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_PDOore','no',TimeLag,savDir,useYR,mdPDOo,mdPDOor,'PDO',selPeriod);
        drwLineBoxLAGR_IDXe(xmdUDn,xmdNVn,mnVV,dspDat,dic,'yes','Fig.3(a)_SOIore','no',TimeLag,savDir,useYR,mdSOIo,mdSOIor,'SOI',selPeriod);
        %% << CC 1x1 >>
        %%
        % < PDO >
        scrsz = get(0,'ScreenSize');
        figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
        %----------------------------------------------------------------
        drwCCP2(xmdNVn,cVP,mdPDO,cVPr,mdPDOr,'max',appNormz,'no','PDO',selPeriod)
        %----------------------------------------------------------------
        set(gcf,'units','centimeters','position',[0 0 15 15],...
            'paperposition',[0 0 15 15]);
        print(gcf,'-dpng','-r600',[savDir 'Fig.3(a)_PDO_CC' '_' selPeriod '.png'])
        close(gcf)
        % < PDOo >
        scrsz = get(0,'ScreenSize');
        figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
        %----------------------------------------------------------------
        drwCCP2(xmdNVn,cVPo,mdPDOo,cVPor,mdPDOor,'max',appNormz,'no','PDO',selPeriod)
        %----------------------------------------------------------------
        set(gcf,'units','centimeters','position',[0 0 15 15],...
            'paperposition',[0 0 15 15]);
        print(gcf,'-dpng','-r600',[savDir 'Fig.3(a)_PDOo_CC' '_' selPeriod '.png'])
        close(gcf)
        %%
        % < SOI >
        scrsz = get(0,'ScreenSize');
        figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
        %----------------------------------------------------------------
        drwCCP2(xmdNVn,cVS,mdSOI,cVSr,mdSOIr,'max',appNormz,'no','SOI',selPeriod)
        %----------------------------------------------------------------
        set(gcf,'units','centimeters','position',[0 0 15 15],...
            'paperposition',[0 0 15 15]);
        print(gcf,'-dpng','-r600',[savDir 'Fig.3(a)_SOI_CC' '_' selPeriod '.png'])
        close(gcf)
        % < SOIo >
        scrsz = get(0,'ScreenSize');
        figure('Position',[0 0 scrsz(3)/1.1 scrsz(4)/1.1]);
        %----------------------------------------------------------------
        drwCCP2(xmdNVn,cVSo,mdSOIo,cVSor,mdSOIor,'max',appNormz,'no','SOI',selPeriod)
        %----------------------------------------------------------------
        set(gcf,'units','centimeters','position',[0 0 15 15],...
            'paperposition',[0 0 15 15]);
        print(gcf,'-dpng','-r600',[savDir 'Fig.3(a)_SOIo_CC' '_' selPeriod '.png'])
        close(gcf)
end
%%


%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << cross corr. >>
%% < NVOL(W) >
%------------------------------------------
% PDO
[Vxv1u,Dxv1u]=xcorr(xmdNVn,mdPDO,'coeff');
[Vxv2u,Dxv2u]=xcorr(xmdUDn,mdPDO,'coeff');
%--------------------
[Vxv1,Dxv1]=xcorr(xmdNVn,mdPDOr,'coeff');
[Vxv2,Dxv2]=xcorr(xmdUDn,mdPDOr,'coeff');
%------------------------------------------
% SOI
[Vxv5u,Dxv5u]=xcorr(xmdNVn,mdSOI,'coeff');
[Vxv6u,Dxv6u]=xcorr(xmdUDn,mdSOI,'coeff');
%--------------------
[Vxv5,Dxv5]=xcorr(xmdNVn,mdSOIr,'coeff');
[Vxv6,Dxv6]=xcorr(xmdUDn,mdSOIr,'coeff');
%%
%%
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%% << PDO and SOI time series >>
dspEL='no';
%-------------------------------
drwLineBoxLAGR_21(xmdUDn,xmdNVn,mnVV,mdPDO,'PDO',dspEL,'Fig.3(a)',savDir,TimeLag)  % 3(a)
drwLineBoxLAGR_21(xmdUDn,xmdNVn,mnVV,mdSOI,'SOI',dspEL,'Fig.S7(a)',savDir,TimeLag) % S7(a)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%
% < NVOL_USDX >
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% <2 Plot U (uncorrect) > ***
clear DxvA VxvA
DxvA=[Dxv1u;Dxv2u]'; % n x 3
VxvA=[Vxv1u,Vxv2u];
corrYN='uncorrect_sz';
dspCrossC2(DxvA,VxvA,corrYN,savDir,selPeriod,1.6,'NVOL(W)_USDX','PDO')% Fig. 3(b)
%--------------------------------------------------------------------------
% <2 Plot R (correct) > ***
clear DxvA VxvA
DxvA=[Dxv1;Dxv2]'; % n x 3
VxvA=[Vxv1,Vxv2];
corrYN='correct_sz';
dspCrossC2(DxvA,VxvA,corrYN,savDir,selPeriod,1.6,'NVOL(W)_USDX','PDO')% Fig. 3(c)
%--------------------------------------------------------------------------
% <2 Plot U (uncorrect) > ***
clear DxvA VxvA
DxvA=[Dxv5u;Dxv6u]'; % n x 3
VxvA=[-Vxv5u,-Vxv6u];
corrYN='uncorrect_sz';
dspCrossC2(DxvA,VxvA,corrYN,savDir,selPeriod,1.6,'NVOL(W)_USDX','-SOI')% Fig. S7(b)
%--------------------------------------------------------------------------
% <2 Plot R (correct) > ***
clear DxvA VxvA
DxvA=[Dxv5;Dxv6]'; % n x 3
VxvA=[-Vxv5,-Vxv6];
corrYN='correct_sz';
dspCrossC2(DxvA,VxvA,corrYN,savDir,selPeriod,1.6,'NVOL(W)_USDX','-SOI')% Fig. S7(c)
%% ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
%%


end
%%