function [strain, zp] = strain_VM4(b, z_range, K0, processing_window, averaging_window)
    % Perform strain retrieval based on A L Matveyev et al 2018 Laser Phys. Lett. 15 065603
    % Section 3. Vector method for estimating laterally inhomogeneous strains
%     arguments
%         Bu (:,:,:) double % unloaded B-scan. Indexing: (x, y,z)
%         Bl (:,:,:) double % loaded B-scan. Indexing: (x, y,z)
%         z_range (1,2) double % z axis min/max values in (m)
%         K0 (1,1) double % central wavenumber in (1/m)
%         processing_window (1,3) uint32 % [Nx, Ny, Nz] as in the paper
%         averaging_window (1,3) uint32 %= [3, 3, 3] % window to calculate ~b. Should be 2-3 px according to the paper
%     end
    aW = double(averaging_window); pw = double(processing_window);
%     b = Bl .* conj(Bu);
%     h = fspecial('average',);
%     btilde = imfilter(b,h,'replicate');
    btilde = movmean(b,aW(1),1); %disp('First Averaging (x):');
    btilde = movmean(btilde,aW(2),2);  %disp('First Averaging (y):');
    btilde = movmean(btilde,aW(3),3); %disp('First Averaging (z):');
%     clear('b', 'h');

    d = btilde(:,:,2:end,:,:,:) .* conj(btilde(:,:,1:end-1,:,:,:));
%     clear('btilde');

%     davg = movmean(d, processing_window(1), 1); % davg = davg ./ abs(davg);
%     davg = movmean(davg, processing_window(2), 2); % davg = davg ./ abs(davg);
%     davg = movmean(davg, processing_window(3), 3); davg = davg ./ abs(davg);

    davg = movmean(d./abs(d), pw(1), 1); davg = davg ./ abs(davg); % disp('Second Averaging (x):');
    davg = movmean(davg, pw(2), 2); davg = davg ./ abs(davg); %disp('Second Averaging (y):');
    davg = movmean(davg, pw(3), 3);  davg = davg ./ abs(davg);  % disp('Second Averaging (z):'); % davg = davg ./ abs(davg);

    zp = linspace(z_range(1), z_range(2), size(b, 3));
    strain = angle(davg) / (2*K0) / diff(zp(1:2));
end

