function [y,varargout] = slit_mean(x,n,varargin);

i0 = 1; skip = 1;
if nargin >= 3;  i0 = varargin{1}; end
if nargin == 4;  skip = varargin{2}; end

if not(abs(round(skip) == skip)); error('skip must be an integer number!'); end;

sx = size(x);
Nx = sx(i0);

N = floor((Nx-n +1)/skip);
if N == 0; error('N > 0!!'); end;

n2 = ceil(n/2);
sy = sx;

sy(i0) = N;
y = zeros(sy);

for i = 1:N
    im = i*skip;
    if i0 == 1
        y(i,:,:,:,:,:,:) = sum(x(im:im+n-1,:,:,:,:,:,:),i0)/n;
    elseif i0 == 2
        y(:,i,:,:,:,:,:) = sum(x(:,im:im+n-1,:,:,:,:,:),i0)/n;
    elseif i0 == 3
        y(:,:,i,:,:,:,:) = sum(x(:,:,im:im+n-1,:,:,:,:),i0)/n;
    elseif i0 == 4
        y(:,:,:,i,:,:,:) = sum(x(:,:,:,im:im+n-1,:,:,:),i0)/n;
    elseif i0 == 5
        y(:,:,:,:,i,:,:) = sum(x(:,:,:,:,im:im+n-1,:,:),i0)/n;
    elseif i0 == 6
        y(:,:,:,:,:,i,:) = sum(x(:,:,:,:,:,im:im+n-1,:),i0)/n;
    elseif i0 == 7
        y(:,:,:,:,:,:,i) = sum(x(:,:,:,:,:,:,im:im+n-1),i0)/n;
    end
end

varargout{1} = n2-1 +skip*[1:N];
% varargout{1} = n2:skip:(n2+N-1);

end

 
