function [r_abs, r_ref, varargout] = retrieval_v_old(sampleFolder, skip_p,j_flag, varargin)
warning('off');
if nargout >= 5; error('Too many output'); end

slh = '\'; if isunix; slh = '/'; end; % Usually is '/' with Linux and '\' with Windows

% current_dir = fileparts(matlab.desktop.editor.getActiveFilename); cd(current_dir);
cd ..; cd ..; current_dir = pwd;% "Matlab_drive_scripts" folder
addpath(genpath([current_dir,slh,'handle_functions']));
cd([current_dir,slh,'post_doc_code']); current_dir = pwd; % Postdoc folder
addpath(genpath([current_dir,slh,'AXIm_handle_functions']));
addpath(genpath([current_dir,slh,'CT_reconstruction_code']));
addpath(genpath([current_dir,slh,'retrieval_code']));

global Np_tot Nf_tot image_tmp N_row N_col;
[flat_data,IC,Np,Nd,intervalFlat] = projections_loader_AXIm_10_2023(sampleFolder,'flat'); %( N_row,N_col,Nc,Nf);
s_flat = size(flat_data); Nc = s_flat(3); Nf = s_flat(4);

% "varargin"
Nw = 20; num_var = length(varargin); ind_slices = 1:N_row; 
if num_var >= 1; ind_slices = varargin{1}; end; if strcmp(ind_slices,'all'); ind_slices = 1:N_row; end; N_sl = length(ind_slices);
if num_var >= 2; Nw = varargin{2}; end
if num_var >= 3; error('Too many input data'); end


normalizationWindow = 20; %Savvas

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Create folders
retrievedAbsorption = strcat(sampleFolder,['retrieved2Absorption',slh]); mkdir(retrievedAbsorption);
retrievedRefractionActual = strcat(sampleFolder,['retrieved2RefractionActual',slh]); mkdir(retrievedRefractionActual);
retrievedRefraction = strcat(sampleFolder,['retrieved2Refraction',slh]); mkdir(retrievedRefraction);
retrievedScattering = strcat(sampleFolder,['retrieved2Scattering',slh]); mkdir(retrievedScattering);

%% Manually define a ROI in the first projection
evenImage=image_tmp(:,2:2:end,:);
oddImage=image_tmp(:,1:2:end,:);
roi=[round(size(evenImage,2)/2-75),round(size(evenImage,1)/2-75),100,100];
evenMean=mean2(imcrop(evenImage,roi)); oddMean=mean2(imcrop(oddImage,roi));

% This decides what columns to cover (see last minutes of video with Savvas)
if evenMean>oddMean; flagSkipCol='even'; elseif evenMean<oddMean; flagSkipCol='odd'; end
if strcmp(flagSkipCol,'even')==1; image1=image_tmp(:,2:2:end,:); elseif strcmp(flagSkipCol,'odd')==1; image1=image_tmp(:,1:2:end,:); end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[~,rect]=imcrop(imshow(image1,[])); % interactive selectiom of ROI
cropImage=imcrop(image1,rect); N_row_crop = size(cropImage,1); N_col_crop = size(cropImage,2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% select region for background normalization
[im,normRect]=imcrop(imshow(cropImage,[])); 

r_abs = zeros(N_row_crop,N_col_crop*Nd,Np); r_ref = zeros(N_row_crop,N_col_crop*Nd,Np);
if nargout >=3; r_sca = zeros(N_row_crop,N_col_crop*Nd,Np); end
if nargout >=4; r_ref_act = zeros(N_row_crop,N_col_crop*Nd,Np); end

%load and retrieve flat field (don't crop at this stage)
eS = zeros(Nf,Nd);
flat_data(flat_data<=0) = 1 + rand;
flat_data2 = permute(flat_data,[3,1,2,4]); [aF,bF,cF,eF] = gauss_interp(IC(:),flat_data2);

% if sum(isnan(aF(:)))> 0; aF(isnan(aF)) = mean(aF,[2,3],'omitnan'); end
% if sum(isnan(bF(:)))> 0; bF(isnan(bF)) = mean(bF,[2,3],'omitnan'); end
% if sum(isnan(cF(:)))> 0; cF(isnan(cF)) = mean(cF,[2,3],'omitnan'); end
amplitudeFlat = reshape(aF,[N_row,N_col,Nf]); centerFlat = reshape(bF,[N_row,N_col,Nf]); widthFlat = reshape(cF,[N_row,N_col,Nf]);
if max(eF(:))>0.04; fprintf('Gaussian regression on the flat data did not work properly, relative error %f!',max(eF(:))); end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% RETRIEVE PROJECTIONS

% load jittering array
if j_flag==1;jitteringCorrection = readmatrix([sampleFolder,'jitter.txt']);
    sumJ = sum(isnan(jitteringCorrection));
    if sumJ == 1 & isnan(jitteringCorrection(end)); jitteringCorrection(end) = [];
    elseif sumJ >=1; error('There are NaN entries in the jitteringCorrection file.'); end
end

for ii=1:70:Np
    fprintf('Projection %d/%d\n',ii,Np)
    tmpAbs=zeros(N_row_crop,N_col_crop,Nd); tmpRef=zeros(N_row_crop,N_col_crop,Nd); tmpScat=zeros(N_row_crop,N_col_crop,Nd);
     sequence = projections_loader_AXIm_10_2023(sampleFolder,'proj',ii);

    if j_flag==1; sequence=imtranslate(sequence,[skip_p*jitteringCorrection(ii,1),0,0],'OutputView','same'); end
    if strcmp(flagSkipCol,'even')==1; sequence=sequence(:,2:2:end,:); elseif strcmp(flagSkipCol,'odd')==1; sequence=sequence(:,1:2:end,:); end

    sequence=sequence(rect(2):rect(2)+rect(4),rect(1):rect(1)+rect(3),:); isub = floor((ii-1)/intervalFlat); flatSeries = isub + 1;

    for id = 1:Nd
        startIndex=Nc*(id-1)+1;
        endIndex=startIndex+Nc-1;
        ICseries=sequence(:,:,startIndex:endIndex);

        ind_tmp = (find(ICseries(:)<=0));   ICseries(ind_tmp) = 1+rand;
        tmp2 = permute(ICseries,[3,1,2]); [aS,bS,cS,eS(ii,id)] = gauss_interp(IC(:),tmp2);
        amplitudeSample = reshape(aS(1,:,:),[N_row_crop,N_col_crop]); centerSample = reshape(bS(1,:,:),[N_row_crop,N_col_crop]); widthSample = reshape(cS(1,:,:),[N_row_crop,N_col_crop]);

        % jitter the flat field according to the sample remove columns and crop
        A0=amplitudeFlat(:,:,flatSeries);
        if j_flag==1; A0=imtranslate(amplitudeFlat(:,:,flatSeries),[skip_p*jitteringCorrection(ii,1),0],'OutputView','same'); end
        if strcmp(flagSkipCol,'even')==1; A0=A0(:,2:2:end); elseif strcmp(flagSkipCol,'odd')==1; A0=A0(:,1:2:end); end; A0=imcrop(A0,rect);

        B0=centerFlat(:,:,flatSeries);
        if j_flag==1; B0=imtranslate(centerFlat(:,:,flatSeries),[skip_p*jitteringCorrection(ii,1),0],'OutputView','same'); end
        if strcmp(flagSkipCol,'even')==1; B0=B0(:,2:2:end); elseif strcmp(flagSkipCol,'odd')==1; B0=B0(:,1:2:end); end; B0=imcrop(B0,rect);

        C0=widthFlat(:,:,flatSeries);
        if j_flag==1; C0=imtranslate(widthFlat(:,:,flatSeries),[skip_p*jitteringCorrection(ii,1),0],'OutputView','same'); end
        if strcmp(flagSkipCol,'even')==1; C0=C0(:,2:2:end); elseif strcmp(flagSkipCol,'odd')==1; C0=C0(:,1:2:end); end; C0=imcrop(C0,rect);

        % calculate retrieved images
        absorption=amplitudeSample./A0; refraction=centerSample-B0; scattering=widthSample-C0;

        % normalize
        meanAir=mean2(imcrop(absorption,normRect)); absorption=-log(absorption./meanAir);
        meanAir=mean2(imcrop(refraction,normRect)); refraction=refraction-meanAir;
        meanAir=mean2(imcrop(scattering,normRect)); scattering=scattering-meanAir;

        tmpAbs(:,:,id)=real(absorption); tmpRef(:,:,id)=real(refraction); tmpScat(:,:,id)=real(scattering);
    end

    % recombine dithering steps
    recombinedAbsorption=zeros(N_row_crop,N_col_crop*Nd); recombinedRefraction=zeros(N_row_crop,N_col_crop*Nd); recombinedScattering=zeros(N_row_crop,N_col_crop*Nd);
    for mm=1:N_col_crop
        startCol=1+Nd*(mm-1); endCol=Nd*mm;
        recombinedAbsorption(:,startCol:endCol)=squeeze(tmpAbs(:,mm,1:1:Nd)); recombinedRefraction(:,startCol:endCol)=squeeze(tmpRef(:,mm,1:1:Nd)); recombinedScattering(:,startCol:endCol)=squeeze(tmpScat(:,mm,1:1:Nd));
    end
    meanAir=mean(recombinedRefraction(:,[1:normalizationWindow,end-normalizationWindow:end]),2); recombinedRefraction=recombinedRefraction-meanAir;

    %convert lenght to micron
    recombinedRefractionActual = recombinedRefraction;
    recombinedRefraction=cumsum(double(recombinedRefractionActual),2); %sampling in x - direction of integration
    recombinedRefraction = fillmissing(recombinedRefraction,'linear');

    if mod(ii,Nw) == 1; 
        filename = sprintf('absorption_%04d.tif',ii); file = strcat(retrievedAbsorption,filename); imwrite2tif(double(recombinedAbsorption),[],file,'single'); 
        filename = sprintf('refraction_%04d.tif',ii); file = strcat(retrievedRefraction,filename); imwrite2tif(double(recombinedRefraction),[],file,'single');  
        filename = sprintf('retrievedRefractionActual_%04d.tif',ii); file = strcat(retrievedRefractionActual,filename); imwrite2tif(double(recombinedRefractionActual),[],file,'single');  
        filename = sprintf('scattering_%04d.tif',ii); file = strcat(retrievedScattering,filename); imwrite2tif(double(recombinedScattering),[],file,'single'); 
    end

    r_abs(:,:,ii) = single(recombinedAbsorption); 
    r_ref(:,:,ii) = single(recombinedRefraction); 
    if nargout >= 3; r_sca(:,:,ii) = single(recombinedScattering); end
    if nargout >= 4; r_ref_act(:,:,ii) = single(recombinedRefractionActual); end
    
end
if max(eS(:))>0.04; fprintf('Gaussian regression on the projections did not work properly, relative error %f!',max(eS(:))); end

if nargout >= 3; varargout{2} = r_sca; end
if nargout >= 4; varargout{1} = r_ref_act; end
end

