function [strain, zbar,varargout] = strain_VM2(zmin,zmax,f_vec ,IU, IL, varargin)
% This function esimates the strain from IU and IL, (z,x,y) by calculating the
% lateral displacement in "x" and "y" directions in a sparse grid, first and
% later it uses this information to calculate the strain by using all A-scans.

sIk = size(IU); NIk = length(sIk);  if NIk <= 2; Ny = 1; else; Ny = sIk(3); end;
Nx = sIk(2); pw = [1,1,92];

aW = [1,1,20];
num_arg = length(varargin);
if (num_arg >= 1); pw = varargin{1}; end
if (num_arg >= 2); aW = varargin{2}; end
if (num_arg >= 3); error('Too many input arguments'); end
f0 = mean(f_vec); K0 = 2*pi*f0; f_max = max(f_vec);
cut_off = 1e-3; Wk = 2*pi*(f_max-f0)/sqrt(log(1/cut_off));

dz_tmp = 7e-7*sqrt(2); 11e-7*sqrt(2);  Nz = ceil((zmax - zmin)/dz_tmp/2)*2+1;
[A_tmp,zbar2] = gen_fft2(-1,f_vec(:),IU(:,1,1,1,1,1),2*[zmin ,zmax ],Nz);  zbar = zbar2(:)./2; dz = zbar(2) - zbar(1);

f_vec = f_vec(:);  P = 1./2./Wk.^2;
Sk =  1/sqrt(pi)./Wk.*exp(-(2*pi*(f_vec-f0)./Wk).^2);
AU = gen_fft2(-1,f_vec,IU.*Sk,zbar2); AL = gen_fft2(-1,f_vec,IL.*Sk,zbar2);
DAU = gen_fft2(-1,f_vec,(1i.*4.*pi.*f_vec).*IU.*Sk,zbar2); DAL = gen_fft2(-1,f_vec,(1i.*4.*pi.*f_vec).*IL.*Sk,zbar2);
D2AU = gen_fft2(-1,f_vec,((1i.*4.*pi.*f_vec).^2).*IU.*Sk,zbar2);   D2AL = gen_fft2(-1,f_vec,((1i.*4.*pi.*f_vec).^2).*IL.*Sk,zbar2);

costA = -1i.*4.*pi.*f0; Ph_zbar = exp(costA.*zbar);
BU = Ph_zbar.*AU; DBU = Ph_zbar.*(costA.*AU + DAU); D2BU = Ph_zbar.*((costA.^2).*AU + 2.*costA.*DAU + D2AU);
BL = Ph_zbar.*AL; DBL = Ph_zbar.*(costA.*AL + DAL); D2BL = Ph_zbar.*((costA.^2).*AL + 2.*costA.*DAL + D2AL);


BUL = BU .* conj(BL);
DBUL = BU.*conj(DBL) + DBU.*conj(BL);
D2BUL = DBU.*conj(DBL) + BU.*conj(D2BL) + D2BU.*conj(BL)+DBU.*conj(DBL);

fm = 1e-0; dx = dz.*fm; 
BULd = BUL - dx.*DBUL + (dx.^2)/2.*D2BUL;

btilde = movmean(BUL,aW(2),2);  disp('First Averaging (y):'); %btilde = btilde./abs(btilde);
btilde = movmean(btilde,aW(3),3); disp('First Averaging (z):'); %btilde = btilde./abs(btilde);
btilde = movmean(btilde,aW(1),1); disp('First Averaging (x):'); %btilde = btilde./abs(btilde);

btilded = movmean(BULd,aW(2),2);  disp('First Averaging (y):'); %btilded = btilded./abs(btilded);
btilded = movmean(btilded,aW(3),3); disp('First Averaging (z):'); %btilded = btilded./abs(btilded);
btilded = movmean(btilded,aW(1),1); disp('First Averaging (x):'); %btilded = btilded./abs(btilded);
clear('b', 'h');

d = btilde.*conj(btilded);
d2 = btilde(2:end,:,:) .* conj(btilde(1:end-1,:,:));
d3 = d; d3(:,1:end-1,:) = btilde(:,2:end,:).*  conj(btilded(:,1:end-1,:));
d4 = d; d4(:,2:end,:)   = btilde(:,1:end-1,:).*conj(btilded(:,2:end,:));
d5 = d; d5(:,:,1:end-1) = btilde(:,:,2:end).*  conj(btilded(:,:,1:end-1));
d6 = d; d6(:,:,2:end)   = btilde(:,:,1:end-1).*conj(btilded(:,:,2:end));

dt = (d+d3+d4+d5+d6)/5;
%  
clear('btilde');

%     davg = movmean(d, processing_window(1), 1); % davg = davg ./ abs(davg);
%     davg = movmean(davg, processing_window(2), 2); % davg = davg ./ abs(davg);
%     davg = movmean(davg, processing_window(3), 3); davg = davg ./ abs(davg);

davg = movmean(dt./abs(dt), pw(1), 1); davg = davg ./ abs(davg);  disp('Second Averaging (x):');
davg = movmean(davg, pw(2), 2); davg = davg ./ abs(davg); disp('Second Averaging (y):');
davg = movmean(davg, pw(3), 3); davg = davg ./ abs(davg); disp('Second Averaging (z):'); % davg = davg ./ abs(davg);

strain = angle(davg) / (2*K0) / dx;

end

