% This script generates all plots of Fig. (6) and Fig. (7)

clear all; clc;


%%%% % Update the path with the folder containing the scripts.
path_string = [''];

% Add to the path the folder containing all the nested functions employed in the following lines of code
addpath(genpath([path_string,'handle_functions_to_add']))

saving_file = [path_string,'/WLS_test3_3D_04_02_2025_Nx_160801_zmin_0_zmax_750_ds_11_dz_36_pw_2_Na_20_Nd_9_Nxy_55_Off_56_red.mat']; % File where the processed data will be saved 

if isfile(saving_file)
    DL = load(saving_file); unpackStruct(DL);
else

    rng(6); % fixed random seed to ensure reproducible simulation results

    % Parameters related to the OCT system used to acquire the experimental data
    lam_min = 1170.5e-9; lam_max = 1407.8e-9; f_min = 1./lam_max; f_max = 1./lam_min; f0 = (f_min + f_max)/2; Df = f_max - f_min;


    Nx = 160801; % Number of independent unloaded A-scans generated
    N_eps = 20; % Number of strains applied for each unloaded A-scan
    N_Delta = 9; % Number of bulk-displacement applied for each  unloaded A-scan

    % z-space
    zmin = 0e-6;     % Minimum axial depth of the simulated OCT A-scans
    zmax = 750e-6;   % Maximum axial depth of the simulated OCT A-scans
    DZ = zmax-zmin;  % Axial range of the simulated OCT A-scans
    dz_thin_tmp = 0.6e-6; % Estimation of the Small step-size used for finely sampling OCT A-scans
    Nz = ceil(DZ/dz_thin_tmp/2)*2+1; % Number of points for the finely sampled OCT A-scans
    dz = DZ./(Nz-1); % Small step-size used for finely sampling OCT A-scans
    dz_OCE =  3.6e-6; % step-size corresponding to OCT A-scans with spectrum ~ [1050,1400]nn
    fitting_range = 100e-6; % Axial fitting range employed by the NEW method to estimate the error function (see Eq. (12))
    K0 = 2*pi*f0; % Central wavenumber
    lambda = 2*pi./K0; % Wavelength corresponding to the central wavenumber
    Nzb  = ceil((fitting_range + 25e-6)/dz_thin_tmp); % Number of pixels of the OCT A-scans used for each OCE A-scan interval
    IZb = 1:Nzb; % Array of indices of each OCE A-scan interval
    d_step = 65e-6; % Axial distance between the centers of two subsequent interval centers of the  OCE A-scans intervals
    iz_step = ceil(d_step/dz_thin_tmp); % Number of pixels corresponding to "d_step"
    ind_minz = [1:iz_step:Nz-Nzb]; ind_minz = ind_minz(1:end-1); % indices of the minima of each subsequent interval
    Nintz = length(ind_minz); % number of OCE intervals analyzed for each OCE A-scan (each epsilon and each Delta)

    %%%% Definition of the arrays used to store the results.
    eps_vec = linspace(-3,3,N_eps)*1e-3; % simulated strains
    Delta_vec = linspace(-1.5,1.5,N_Delta)*1e-6; % simulated bulk displacements

    S_j = cell(N_eps,N_Delta,Nintz); % Estimated WLS strains of signals containing at least a "2-pi jump"
    S_p = cell(N_eps,N_Delta,Nintz); % Estimated WLS strains of signals containing an high oscillation peak
    S_n = cell(N_eps,N_Delta,Nintz); % Estimated WLS strains of signals containing low oscillation peaks
    S_g = cell(N_eps,N_Delta,Nintz); % All estimated WLS strains

    Sv_j = cell(N_eps,N_Delta,Nintz); % Estimated VM strains of signals containing at least a "2-pi jump"
    Sv_p = cell(N_eps,N_Delta,Nintz); % Estimated VM strains of signals containing an high oscillation peak
    Sv_n = cell(N_eps,N_Delta,Nintz); % Estimated VM strains of signals containing low oscillation peaks
    Sv_g = cell(N_eps,N_Delta,Nintz); % All estimated VM strains

    % parallelization setting
    poolobj = gcp('nocreate');
    if isempty(poolobj); poolobj = parpool('Threads'); else; if strcmp(class(poolobj),'parallel.ProcessPool'); delete(gcp('nocreate')); poolobj = parpool('Threads');  end; end

    % Array containing the number of signals generated for the 4 classes (2pi-jump, high osc.peaks, low osc. peaks, and a fourth class of all signals generated)
    Pars = zeros(N_eps,N_Delta,Nintz,4,2); Pars_prod = zeros(N_eps,N_Delta,Nintz,4);

    % OCT A-scans generation (Eq. (4a-4b))
    dens_scat = 11; % Average number of scatterers per 10 microns of axial depth
    Ws = 20e-6; % Extra optical path used to generate meaningful OCT signals also around zmin and zmax
    DZ_s = DZ + Ws; % Total axial length
    zmin_s = zmin - Ws/2; zmax_s = zmax + Ws/2; % minimum and maximum axial depth related to the total axial length

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    Ns = ceil(dens_scat*DZ_s*1e5); rho_max = 3e-4; cut_off_min =  1e-3;1e-1; %
    rho = rho_max.*rand(Ns,Nx);
    z_scatU = zmin_s + DZ_s.*sort(rand(Nx,Ns),2); 
    Df = f_max - f_min; Nk_nyq = 4*zmax*Df; Nk_tmp = ceil(Nk_nyq*1.5); 
    f_vec = linspace(f_min,f_max,Nk_tmp);  
    cut_off = 1e-3; Wk = 2*pi*(f_max-f0)/sqrt(log(1/cut_off)); T = 1./2./Wk.^2;
    dfvec = f_vec(2)-f_vec(1); f_maxL = Wk./2./pi.*sqrt(log(1./cut_off_min))+f0; f_minL = -Wk./2./pi.*sqrt(log(1./cut_off_min))+f0;
    f_long = [f_minL:dfvec:f_maxL]; f_long = f_long - mean(f_long) + f0; Nk = length(f_long); %f_long = f_vec;
    Sk =  2.*pi./sqrt(pi)./Wk.*exp(-(2*pi*(f_long(:)-f0)./Wk).^2);
    IU0 = exp(-1i.*z_scatU(1,:).*4.*pi.*f_long(:))*rho(:,1); 
    [BU_tmp,zb2] = gen_fft2(-1,f_long,IU0.*Sk,2.*[zmin,zmax],Nz); zbar = zb2(:)./2; 

    IU = zeros(Nk,Nx);  BU = zeros(Nz,Nx); 
    tic;
    parfor ix = 1:Nx
        IU(:,ix) = exp(-1i.*z_scatU(ix,:).*4.*pi.*f_long(:))*rho(:,ix);
       BU(:,ix) = gen_fft2(-1,f_long,IU(:,ix).*Sk,zb2,Nz);   
    end
    toc;
%     save(saved_IU,'IU','f_vec','f_long','Sk','Wk','cut_off','zmin','zmax','dens_scat');
    BU = BU.*exp(-1i.*4.*pi.*f0.*zbar);
    
%     Ns = ceil(dens_scat*DZ_s*1e5); % Number of scatterers for each simulated OCT A-scan
%     rho_max = 3e-4; % Maximum of the scattering cross-section parameter
%     cut_off = 1e-3; % Frequencies cut-off at the edge of the spectrum
%     rho = rho_max.*rand(Ns,Nx); % Array of the scattering cross-section parameters, for all scatterers ad all signals
%     z_scatU = zmin_s + DZ_s.*sort(rand(Nx,Ns),2); % Array of the scattering axial coordinates, for all scatterers ad all signals
%     Nk_nyq = 4*zmax*Df; % Number of spatial frequencies needed to generate signals with maximum depth "zmax"
%     Nk_tmp = ceil(Nk_nyq*1.5); % Upper bound for Nk_nyq
%     f_vec = linspace(f_min,f_max,Nk_tmp); % Array of the spatial frequencies
%     Wk = 2*pi*(f_max-f0)/sqrt(log(1/cut_off)); % spectral width of the light sourcr
%     dfvec = f_vec(2)-f_vec(1); % sampled spatial frequencies step-size
%     Nk = length(f_vec); % Number of simulated monochromatic components
%     Sk =  2.*pi./sqrt(pi)./Wk.*exp(-(2*pi*(f_vec(:)-f0)./Wk).^2); % Spectral density
% 
%     IU = zeros(Nk,Nx); % Array of unloaded raw signals
%     BU = zeros(Nz,Nx); % Array of unloaded signals in z- domain
% 
%     IU(:,1) = exp(-1i.*z_scatU(1,:).*4.*pi.*f_vec(:))*rho(:,1);
%     [BU(:,1),zb2] = gen_fft2(-1,f_vec,IU(:,1).*Sk,2.*[zmin,zmax],Nz); % calculation of the array of axial coordinates zb2 and zbar
%     zbar = zb2(:)./2; % Array of z coordinates wher the OCT signals have been calculated
    % Loop generating all raw and z-domain OCT signals
%     parfor ix = 2:Nx
%         IU(:,ix) = exp(-1i.*z_scatU(ix,:).*4.*pi.*f_vec(:))*rho(:,ix);
%         BU(:,ix) = gen_fft2(-1,f_vec,IU(:,ix).*Sk,zb2,Nz); % Eq. (3a)
%     end
% 
%     BU = BU.*exp(-1i.*4.*pi.*f0.*zbar); % Eq. (4a) Demodulated unloaded signal

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


    for ia = 1:N_eps % loop over the simulated axial strains 
        alpha = eps_vec(ia);  % Strain

        ILa = zeros(Nk,Nx);  % Array used to computation all the loaded A-scan for the strain alpha
        parfor ix = 1:Nx 
            ILa(:,ix) = exp(-1i.*z_scatU(ix,:).*(1+alpha).*4.*pi.*f_long(:))*rho(:,ix);
        end

        for id = 1:N_Delta % loop over the simulated Bulk displacements 
            fprintf('ia,id = (%d,%d)/(%d,%d)\n',ia,id,N_eps,N_Delta);

            BL = zeros(Nz,Nx); % Array of loaded signals in z- domain
            Disp = Delta_vec(id); % Bulk displacement

            IL = ILa.*exp(-1i.*4.*pi.*f_long(:).*Disp); % Loaded signal in raw domain
            parfor ix = 1:Nx;
                BL(:,ix) = gen_fft2(-1,f_long,IL(:,ix).*Sk,zb2,Nz);
            end
            BL = BL.*exp(-1i.*4.*pi.*f0.*zbar); % Loaded signal in z-domain

            aw = 2*[1,1,1]; 
            aw_UWA = 2*[1,1,1]; 
            uw = [4,4,ceil(25e-6/dz_OCE)];
            % Generation of the three kind of signals, including 2-pi jumps, high and low oscillation peaks
            for iz = 1:Nintz % loop over the signal depths analyzed in Figs. 6c), 7c), 7g), 8c) 
                IZ_tmp = ind_minz(iz) - 1 + IZb; %
                itp = 0; itj = 0; itn = 0;  itg = 0; % Indices used to fill the generated OCT B-scans
                Nxy = 55; % Dimension of the rearranged OCT C-scans in both x and y direction
                Nmax = Nxy^2; % Maximum number of OCT A-scans for each OCT C-scan
                cond_tot = 1; iss = 0;
                BUL_peak = zeros(Nzb,Nxy^2); BUL_gen = zeros(Nzb,Nxy^2); BUL_no_dark = zeros(Nzb,Nxy^2); BUL_jump = zeros(Nzb,Nxy^2);
                IU_jump = zeros(Nk,Nxy^2); IL_jump = zeros(Nk,Nxy^2); IU_peak = zeros(Nk,Nxy^2); IL_peak = zeros(Nk,Nxy^2); IU_no_dark = zeros(Nk,Nxy^2); IL_no_dark = zeros(Nk,Nxy^2); IU_gen = zeros(Nk,Nxy^2); IL_gen = zeros(Nk,Nxy^2);
                C_JNP = 1; C_G = 1; C_N = 1; C_J = 1; C_P = 1; Ix_comb = [1:Nx].'; % nchoosek(1:Nx,2);
                INDs = 1:Nx;  Nsh = floor(size(Ix_comb,1)/Nx)-1;

                while C_JNP % loop that separates each generated signal as 2-pi jump, high peak or low oscillation peak
                    iss = iss+1;
                    Ix_comb1 = Ix_comb(INDs,1);
                    BUs1 = BU(:,Ix_comb1);  BLs1 = BL(:,Ix_comb1);
                    IUs1 = IU(:,Ix_comb1); ILs1 = IL(:,Ix_comb1);
                    BUL = (BUs1).*conj(BLs1);
                    Dphi_wrap = angle(BUL); Dphi = unwrap(Dphi_wrap); Dphim = Dphi;
                    xvec = [zmin*1e6+50,zmax*1e6-50];
                    IZ0 = find( (zbar>=xvec(1)*1e-6)&(zbar<=xvec(2)*1e-6)); iz0 = IZ0(1); Dphi_rig_tmp = (Disp+ alpha.*zbar).*2.*K0;
                    Dphi_rig = Dphi_rig_tmp - Dphi_rig_tmp(iz0) + Dphim(iz0,:,:); i_slit2 = 0; i_slit = 2*i_slit2+1;
                    D_red = (Dphim-Dphi_rig)./2./pi; D_mean_T =  (movmean(D_red,i_slit,1));
                    Offset = 0.55;  Offset_peak1 = 0.65; 0.5;  Offset_peak2 = 0.95; off_jump = 1.2;
                    D_mean = D_mean_T(IZ_tmp,:); BUxy = BUL(IZ_tmp,:);
                    MD = max(D_mean); mD = min(D_mean); MmD = (MD-mD).*ones(size(BUxy));
                    sD = sum(D_mean-min(D_mean)).*ones(size(BUxy));
                    cond_mean1 = abs(sD)*dz_thin_tmp>0.45*(zbar(Nzb)-zbar(1));
                    cond_mean2 = 1;
                    cond_n =  (MmD <= Offset);
                    cond_j = (MmD >= off_jump)&cond_mean1;
                    cond_p =   not(cond_j) & (MmD >= Offset_peak1) &(MmD <= Offset_peak2) & cond_mean2;
                    if C_N; BUL_n = BUxy(:,cond_n(1,:)); IU_n = IU(:,cond_n(1,:)); IL_n = IL(:,cond_n(1,:)); end;
                    if C_J; BUL_j = BUxy(:,cond_j(1,:)); IU_j = IU(:,cond_j(1,:)); IL_j = IL(:,cond_j(1,:)); end;
                    if C_P; BUL_p = BUxy(:,cond_p(1,:)); IU_p = IU(:,cond_p(1,:)); IL_p = IL(:,cond_p(1,:)); end;

                    if C_N; itn_2 = itn + size(BUL_n,2); BUL_no_dark(:,itn+1:itn_2) = BUL_n; IU_no_dark(:,itn+1:itn_2) = IU_n; IL_no_dark(:,itn+1:itn_2) = IL_n; end;
                    if C_J; itj_2 = itj + size(BUL_j,2); BUL_jump(:,itj+1:itj_2) = BUL_j; IU_jump(:,itj+1:itj_2) = IU_j; IL_jump(:,itj+1:itj_2) = IL_j;  end;
                    if C_P; itp_2 = itp + size(BUL_p,2); BUL_peak(:,itp+1:itp_2) = BUL_p; IU_peak(:,itp+1:itp_2) = IU_p; IL_peak(:,itp+1:itp_2) = IL_p; end
                    if C_G; itg_2 = itg + size(BUxy,2); BUL_gen(:,itg+1:itg_2) = BUxy; IU_gen(:,itg+1:itg_2) = IU; IL_gen(:,itg+1:itg_2) = IL; end;
                    itn = itn_2; itj = itj_2; itp = itp_2;  itg = itg_2;

                    C_G = itg <= Nmax+1; C_N = itn <= Nmax+1; C_J = itj <= Nmax+1; C_P = itp <= Nmax+1; INDs = INDs+Nx; C_JNP = (C_N | C_J | C_P)& iss<=Nsh; % fprintf('inds = %d, iss = %d\n',INDs(1),iss);

                end

                Tp = 10; ind_8 = 16; pw(1) = 2; pw(2) = 2; pw(3) = ceil(fitting_range/dz_OCE);
                Ntg = min(itg-1,Nmax); Ntg1 = floor(sqrt(Ntg)); Ntg2 = floor(Ntg/Ntg1); Ntp =  min(itp-1,Nmax); Ntj = min(itj-1,Nmax); Ntn = min(itn-1,Nmax); Ntp1 = floor(sqrt(Ntp)); Ntp2 = floor(Ntp/Ntp1); Ntj1 = floor(sqrt(Ntj)); Ntj2 = floor(Ntj/Ntj1); Ntn1 = floor(sqrt(Ntn)); Ntn2 = floor(Ntn/Ntn1);
                z_range = [zbar(IZ_tmp(1)) zbar(IZ_tmp(Nzb))]; Pars(ia,id,iz,:,1) = [Ntj1,Ntp1,Ntn1,Ntg1]; Pars(ia,id,iz,:,2) = [Ntj2,Ntp2,Ntn2,Ntg2];
                Pars_prod(ia,id,iz,:) = [itj,itp,itn,itg];
                step_OCE = round(dz_OCE/dz); IZE = [1:step_OCE:Nzb]; IZE_z = IZ_tmp(IZE);

                fit_range = 100e-6; resolution = 5e-6; Nx_lat = 0; Ny_lat = 0;
                zmin_c = z_range(1); zmax_c = z_range(2);

                if Ntj1 >= Tp & Ntj2 >= Tp; BUL_jump = BUL_jump(:,1:Ntj1*Ntj2); BUL_jump = reshape(BUL_jump,[Nzb,Ntj1,Ntj2]); BUL_jump_3D = permute(BUL_jump,[2,3,1]); [s_jump, zp_jump,Dphi_jump] = strain_UWA(lambda,zbar(IZE_z),BUL_jump_3D(:,:,IZE),1:Ntj1,1:Ntj2,fitting_range,uw,aw_UWA); s_jump = permute(s_jump,[3,1,2]); S_j{ia,id,iz} = precision_set2(s_jump,ind_8,1); [sv_jump, zp_VM]   = strain_VM4(BUL_jump_3D(:,:,IZE), z_range, K0, pw, aw);  IZV_jump = find(zp_VM <=max(zp_jump)+dz_OCE & zp_VM >=min(zp_jump)); sv_jump = permute(sv_jump,[3,1,2]);  Sv_j{ia,id,iz} = precision_set2(sv_jump(IZV_jump,:,:),ind_8,1); end
                if Ntn1 >= Tp & Ntn2 >= Tp; BUL_no_dark = BUL_no_dark(:,1:Ntn1*Ntn2); BUL_no_dark = reshape(BUL_no_dark,[Nzb,Ntn1,Ntn2]); BUL_no_dark_3D = permute(BUL_no_dark,[2,3,1]); [s_no_dark, zp_no_dark,Dphi_no_dark] = strain_UWA(lambda,zbar(IZE_z),BUL_no_dark_3D(:,:,IZE),1:Ntn1,1:Ntn2,fitting_range,uw,aw_UWA); s_no_dark = permute(s_no_dark,[3,1,2]); S_n{ia,id,iz} = precision_set2(s_no_dark,ind_8,1); [sv_no_dark, zp_VM]   = strain_VM4(BUL_no_dark_3D(:,:,IZE), z_range, K0, pw, aw); IZV_no_dark = find(zp_VM <=max(zp_no_dark)++dz_OCE & zp_VM >=min(zp_no_dark));  sv_no_dark = permute(sv_no_dark,[3,1,2]);  Sv_n{ia,id,iz} = precision_set2(sv_no_dark(IZV_no_dark,:,:),ind_8,1); end;
                if Ntp1 >= Tp & Ntp2 >= Tp; BUL_peak = BUL_peak(:,1:Ntp1*Ntp2); BUL_peak = reshape(BUL_peak,[Nzb,Ntp1,Ntp2]); BUL_peak_3D = permute(BUL_peak,[2,3,1]); [s_peak, zp_peak,Dphi_peak] = strain_UWA(lambda,zbar(IZE_z),BUL_peak_3D(:,:,IZE),1:Ntp1,1:Ntp2,fitting_range,uw,aw_UWA); s_peak = permute(s_peak,[3,1,2]); S_p{ia,id,iz} = precision_set2(s_peak,ind_8,1); [sv_peak, zp_VM]   = strain_VM4(BUL_peak_3D(:,:,IZE), z_range, K0, pw, aw); IZV_peak = find(zp_VM <=max(zp_peak)+dz_OCE & zp_VM >=min(zp_peak)); sv_peak = permute(sv_peak,[3,1,2]); Sv_p{ia,id,iz} = precision_set2(sv_peak(IZV_peak,:,:),ind_8,1); end;
                if Ntg1 >= Tp & Ntg2 >= Tp; BUL_gen = BUL_gen(:,1:Ntg1*Ntg2); BUL_gen = reshape(BUL_gen,[Nzb,Ntg1,Ntg2]); BUL_gen_3D = permute(BUL_gen,[2,3,1]); [s_gen, zp_gen,Dphi_gen] = strain_UWA(lambda,zbar(IZE_z),BUL_gen_3D(:,:,IZE),1:Ntg1,1:Ntg2,fitting_range,uw,aw_UWA); s_gen = permute(s_gen,[3,1,2]); S_g{ia,id,iz} = precision_set2(s_gen,ind_8,1); [sv_gen, zp_VM]   = strain_VM4(BUL_gen_3D(:,:,IZE), z_range, K0, pw, aw); IZV_gen = find(zp_VM <=max(zp_gen) + dz_OCE & zp_VM >=min(zp_gen)); sv_gen = permute(sv_gen,[3,1,2]); Sv_g{ia,id,iz} = precision_set2(sv_gen(IZV_gen,:,:),ind_8,1); end;
            end
        end
    end

    izw = ceil(10e-6/dz_thin_tmp); WW = 1*[1,1,1]; [izw,3,3]; coef_out = 111; Pars(abs(imag(Pars))>0) = 0; Pars = real(Pars); Pars(isnan(Pars)) = 0;
    str_v{1} = '_jump'; str_v{2} = '_peak';str_v{3} = '_no_dark'; str_v{4} = '_gen'; Nv = length(str_v);
    EE_j = zeros(N_eps,N_Delta,Nintz)+NaN; EE_p = zeros(N_eps,N_Delta,Nintz)+NaN; EE_n = zeros(N_eps,N_Delta,Nintz)+NaN; EE_g = zeros(N_eps,N_Delta,Nintz)+NaN;
    EEv_j = zeros(N_eps,N_Delta,Nintz)+NaN; EEv_p = zeros(N_eps,N_Delta,Nintz)+NaN; EEv_n = zeros(N_eps,N_Delta,Nintz)+NaN;  EEv_g = zeros(N_eps,N_Delta,Nintz)+NaN;
    for ia = 1:N_eps; alpha = eps_vec(ia);
        for id = 1:N_Delta; Disp = Delta_vec(id);
            for iz = 1:Nintz;
                for iv = 1:Nv;
                    strv = str_v{iv};
                    eval(['if not(isempty(S',strv(1:2),'{ia,id,iz})); Nxy2 = min(Nxy,min(Pars(ia,id,iz,iv,:),[],5)); str_tmp = func_cell2(S',strv(1:2),'{ia,id,iz},"all",1:Nxy2,1:Nxy2);  str_tmp(abs(str_tmp-eps_vec(ia))>abs(eps_vec(ia)).*coef_out) = NaN; sm',strv,' = strain_optimized2(str_tmp,ones(size(str_tmp)),WW(1),WW(2),WW(3),1,"omitnan");  EE',strv(1:2),'(ia,id,iz) = mean( abs(sm',strv,' -alpha),"all","omitnan"); end;']);
                    eval(['if not(isempty(Sv',strv(1:2),'{ia,id,iz})); Nxy2 = min(Nxy,min(Pars(ia,id,iz,iv,:),[],5)); str_tmp = func_cell2(Sv',strv(1:2),'{ia,id,iz},"all",1:Nxy2,1:Nxy2);  str_tmp(abs(str_tmp-eps_vec(ia))>abs(eps_vec(ia)).*coef_out) = NaN; sm',strv,' = strain_optimized2(str_tmp,ones(size(str_tmp)),WW(1),WW(2),WW(3),1,"omitnan");  EEv',strv(1:2),'(ia,id,iz) = mean( abs(sm',strv,' -alpha),"all","omitnan"); end;']);
                end
            end
        end
    end

    % Smoothing of the array of errors with a filter 3X3X3
    WWE = 3*[1,1,1];
    for iv = 1:Nv; strv = str_v{iv}; sv = strv(2);
        eval(['EE_m',sv,' = strain_optimized2(EE_',sv,',((EE_',sv,')),WWE(1),WWE(2),WWE(3),0.5,"omitnan");']);
        eval(['EEv_m',sv,' = strain_optimized2(EEv_',sv,',((EEv_',sv,')),WWE(1),WWE(2),WWE(3),0.5,"omitnan");']);
    end

    str_image = ['Na_',num2str(N_eps),'_Nd_',num2str(N_Delta)]; str_off = num2str(ceil(Offset*1e2));
    str1 = [path_string,'/WLS_test3_3D_04_02_2025_Nx_',num2str(Nx),'_zmin_',num2str(ceil(zmin*1e6)),'_zmax_',num2str(ceil(zmax*1e6)),'_ds_',num2str(dens_scat),'_dz_',num2str(ceil(dz_OCE*1e7)),'_pw_',num2str(pw(1)),'_',str_image,'_Nxy_',num2str(Nxy),'_Off_',str_off];
    clear DL z_scatU z_scatL zL rho BU BL BU_T BUL BUL0 BUL_3D Dphi* BU* BL* IU* IL*  D_* poolobj cond_* MmD sD path_str*

    disp(str1);  save([str1,'.mat'],'-v7.3'); 
    
    % saving a smaller file that will be for creating the plots  
    clear S_* Sv_*;  save([str1,'_red.mat'],'-v7.3'); 
    
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%    Processing data pregenerated    %%%%%%%%%%%%%%%%

IA0 = find(abs(eps_vec) >0 ); ID0 = find(Delta_vec <=1.5e-6 & Delta_vec >= -1.5e-6 );
ind_mean = ind_minz + ceil(Nzb/2);
IA_L = find((eps_vec)>3e-4);

% Array that will be used to tranform each NaN into "1"
EEE = EE_mj+EE_mp+EE_mn+EE_mg+EEv_mj+EEv_mp+EEv_mn+EEv_mg;

% Condition array: Each each OCE C-scan containing less than half of the Nxy^2 strains will not be processed 
condP = (min(Pars_prod,[],4) < Nxy^2*0.5); condP(isnan(EEE)) = 1;

% Array of weights according to the condP condition
Wp  = 1+0.*EE_mj; Wp(condP) = 0;

ID00 = [1:N_Delta]; IZ00 = [1:length(ind_mean)]; Nz00 = length(ind_mean(IZ00));
VECZ = ((eps_vec(IA_L).').*reshape(zbar(ind_mean(IZ00)),[1,1,Nz00])+Delta_vec(ID00));
[VEC_sort,ind_sort]  = sort(VECZ(:)); vecdx =[0,max(VEC_sort)]; ParsP_n = Pars_prod./squeeze(max(Pars_prod(:,:,:,4),[],[1,2,3])); % Plots of the 
Ip = Wp(IA0,:,:); Ip = logical(Ip(ind_sort));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     Plots     %%%%%%%%%%%%%%%%%%%%%%%%%%% 

% Plots (a,b,c) of Fig. (6) 
vcol = 'rbgk'; % string containing the colours used for the plots
vecy_tmp = [2.2,11.5]*1e-2; % lower and Upper bound for the y-axis
figure(1); clf; NL = 2; NF = 30; vec_p = [0,11]*1e-1; 
INDZ = round(ind_minz + (ind_minz(2)-ind_minz(1))/2);
[mD,IDs] = sort(abs(Delta_vec));
[mA,IAs] = sort(abs(eps_vec(IA0))); W_m2 = Wp.*0+1;
for iv = 1:3;
    PD = squeeze(mean(ParsP_n(IA0,:,:,iv).*W_m2(IA0,:,:),[1,3])./mean(W_m2(IA0,:,:),[1,3]));
    PA = squeeze(mean(ParsP_n(IA0,:,:,iv).*W_m2(IA0,:,:),[2,3])./mean(W_m2(IA0,:,:),[2,3]));
    subplot(1,4,1); hold on; plot((mA),movmean(PA(IAs),1),'Color',vcol(iv),'Linewidth',NL); ylim(vec_p); %set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF);  % alpha
    subplot(1,4,2); hold on; plot((mD),movmean(PD(IDs),1),'Color',vcol(iv),'Linewidth',NL); ylim(vec_p); %set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF);  % alpha
    subplot(1,4,3); hold on; plot(zbar(INDZ),movmean(squeeze(mean(ParsP_n(IA0,:,:,iv).*W_m2(IA0,:,:),[1,2])./mean(W_m2(IA0,:,:),[1,2])),1),'Color',vcol(iv),'Linewidth',NL); ylim(vec_p); %set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF);  % alpha
    subplot(1,4,4);  ParsPj_sort = ParsP_n(IA_L,:,:,iv); ParsPj_sort = ParsPj_sort(ind_sort); eval(['ParsPj_sort = ParsPj_sort(Ip);']); hold on;
    ind_tmp = eval(['Ip;']); plot(VEC_sort(ind_tmp),(movmean(squeeze(mean(ParsPj_sort,[2,3])),71)),'Color',vcol(iv),'Linewidth',NL); xlim(vecdx); ylim(vec_p); %set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF);% ylim(vec_p); % alpha
end
legend('jump','high peak','low peak');





EE_mj_sort = EE_mj(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mj_sort = EE_mj_sort(ind_sort); EE_mj_sort = EE_mj_sort(Ip);
EE_mn_sort = EE_mn(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mn_sort = EE_mn_sort(ind_sort); EE_mn_sort = EE_mn_sort(Ip);
EE_mp_sort = EE_mp(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mp_sort = EE_mp_sort(ind_sort); EE_mp_sort = EE_mp_sort(Ip);
EE_mg_sort = EE_mg(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mg_sort = EE_mg_sort(ind_sort); EE_mg_sort = EE_mg_sort(Ip);
EEv_mj_sort = EEv_mj(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EEv_mj_sort = EEv_mj_sort(ind_sort); EEv_mj_sort = EEv_mj_sort(Ip);
EEv_mn_sort = EEv_mn(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EEv_mn_sort = EEv_mn_sort(ind_sort); EEv_mn_sort = EEv_mn_sort(Ip);
EEv_mp_sort = EEv_mp(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EEv_mp_sort = EEv_mp_sort(ind_sort); EEv_mp_sort = EEv_mp_sort(Ip);
EEv_mg_sort = EEv_mg(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EEv_mg_sort = EEv_mg_sort(ind_sort); EEv_mg_sort = EEv_mg_sort(Ip);


% Plots (a,b,c,e,f,g) of Fig. (7)
iaL = min(find(eps_vec >= 1e-3)); % strain chosen for the plots
idL = round(N_Delta/2)+1;  % bulk displacement chosen for the plots
izL = round(Nintz*0.3); % depth chosen for the plots
figure(2);  clf;   vcol = 'rbgk'; func_log = '(';'log10(';  eval(['vecy_tmp = ',func_log,'[2.2,11.5]*1e-2);']);
subplot(2,3,1); hold on; for iv = 1:3; str_tmp = '-'; eval(['plot( eps_vec(IA_L),',func_log,'movmean(squeeze(EE_m',str_v{iv}(2),'(IA_L,idL,izL)./aIA0),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  xlim([0.5,3]*1e-3);   ylim(vecy_tmp); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
subplot(2,3,2); hold on; for iv = 1:3; str_tmp = '-'; eval(['plot( Delta_vec(ID0),',func_log,'movmean(squeeze(EE_m',str_v{iv}(2),'(iaL,ID0,izL)./abs(eps_vec(iaL))),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  xlim([0,max(Delta_vec)]);   ylim(vecy_tmp); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
subplot(2,3,3); hold on; for iv = 1:3; str_tmp = '-'; eval(['plot( zbar(ind_mean),',func_log,'movmean(squeeze(EE_m',str_v{iv}(2),'(iaL,idL,:)./abs(eps_vec(iaL))),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  xlim([0,650e-6]);   ylim(vecy_tmp); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
subplot(2,3,4); hold on; for iv = 1:3; str_tmp = '-'; eval(['plot( eps_vec(IA_L),',func_log,'movmean(squeeze(EEv_m',str_v{iv}(2),'(IA_L,idL,izL)./aIA0),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  xlim([0.5,3]*1e-3);   ylim(vecy_tmp); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
subplot(2,3,5); hold on; for iv = 1:3; str_tmp = '-'; eval(['plot( Delta_vec(ID0),',func_log,'movmean(squeeze(EEv_m',str_v{iv}(2),'(iaL,ID0,izL)./abs(eps_vec(iaL))),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  xlim([0,max(Delta_vec)]);   ylim(vecy_tmp); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
subplot(2,3,6); hold on; for iv = 1:3; str_tmp = '-'; eval(['plot( zbar(ind_mean),',func_log,'movmean(squeeze(EEv_m',str_v{iv}(2),'(iaL,idL,:)./abs(eps_vec(iaL))),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  xlim([0,650e-6]);   ylim(vecy_tmp); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);





% Plots (d,h) of Fig. (7)
figure(3); clf; ids = 111; NF = 12; NL = 2; vecdz = [0.02,0.1];
for iv = 1:3
    stline = '-';
    if iv == 4; stline = '--'; end
    
    subplot(1,2,1); hold on;  eval(['ind_tmp = Ip; EE_m_tmp_sort = EE_m',str_v{iv}(2),'_sort;']); plot(VEC_sort(ind_tmp),movmean(EE_m_tmp_sort(:),ids,'omitnan'),stline,'Color',vcol(iv),'Linewidth',NL);  ylim(vecdz); xlim(vecdx);% set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF); %
    subplot(1,2,2); hold on;  eval(['ind_tmp = Ip; EEv_m_tmp_sort = EEv_m',str_v{iv}(2),'_sort;']); plot(VEC_sort(ind_tmp),movmean(EEv_m_tmp_sort(:),ids,'omitnan'),stline,'Color',vcol(iv),'Linewidth',NL);  ylim(vecdz); xlim(vecdx); % set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF); %
end
subplot(1,2,2); xlabel('|\Delta + \epsilon z|'); legend('jump','high peak','low peak','general'); title('VM');
subplot(1,2,1); xlabel('|\Delta + \epsilon z|'); title('UWA');

