clear all; clc;

% This script generates plots analogous to the one presented in Fig. (2)

rng(10); 

% k-space
lam_min = 1170.5e-9; lam_max = 1407.8e-9;  % minmum and maximum wavelengths (meters)
f_min = 1./lam_max; f_max = 1./lam_min; f0 = (f_min + f_max)/2; Df = f_max - f_min;   % minimum/maximum/mean frequencies of the simulated spectrum

% z-space
zmin_long = -5e-6; zmin = +50e-6; zmax = 400e-6; DZ = zmax-zmin; DZ_long = zmax-zmin_long;
dz_tmp = 0.3e-6; Nz = ceil(DZ/dz_tmp/2)*2+1;



Nz_long = ceil(DZ_long/dz_tmp/2)*2+1; zbar_long = linspace(zmin_long,zmax,Nz_long).';

% scatterers (Unloaded)
dens_scat = 7;
zmin_s = zmin_long; zmax_s = zmax + 20e-6; DZ_s = zmax_s - zmin_s;
Ns_long = ceil(dens_scat*DZ_s*1e6); rho_max = 3e-4; rho_long = rho_max.*rand(Ns_long,1);
z_scatlongU = zmin_s + DZ_s.*sort(rand(1,Ns_long)); % zlongU = zbar-z_scatlongU;

izs_min = min(find(z_scatlongU > zmin - 5e-6));
z_scatU = z_scatlongU(izs_min:Ns_long); Ns = length(z_scatU);
rho = rho_long(izs_min:Ns_long);

% Parameters related to the OCT system used to acquire the experimental data
lam_min = 1170.5e-9; lam_max = 1407.8e-9;  % minmum and maximum wavelengths (meters)
f_min = 1./lam_max; f_max = 1./lam_min; f0 = (f_min + f_max)/2; Df = f_max - f_min;   % minimum/maximum/mean frequencies of the simulated spectrum
cut_off = 1e-3; Wk = 2*pi*(f_max-f0)/sqrt(log(1/cut_off)); Df = f_max - f_min; Nk_nyq = 4*max(abs(zmax))*Df; % Minimum number of frequencies able to simulate the deepest axial position (coming from the Nyquist frequency and rates relation)
Nk =  ceil(Nk_nyq*1.5); f_vec = linspace(f_min,f_max,Nk).'; Sk = (2*pi)*1/sqrt(pi)./Wk.*exp(-(2*pi*(f_vec(:)-f0)./Wk).^2);
alpha = -3e-3; % strain
Disp = -3e-6; % Bulk displacement
z_scatL = Disp + z_scatU.*(1+alpha); % zL = zbar-z_scatL;
T = 1./2./Wk.^2;

Nz = 205; zbar = linspace(zmin,zmax,Nz).';

% A-scans
cut_off = 1e-3;
An = @(z,zs,f0,W,rho,Nd)  (z-zs).^Nd.*exp(-1i.*zs.*4.*pi.*f0-W.^2.*(z-zs).^2)*rho;

% Definition of generalized A-scans (Eq. (5))
AU = An(zbar,z_scatU,f0,Wk,rho,0); % Unloaded
AL = An(zbar,z_scatL,f0,Wk,rho,0); % Loaded
AU1 = An(zbar,z_scatU,f0,Wk,rho,1); % 1st generalized AU
AU2 = An(zbar,z_scatU,f0,Wk,rho,2); % 2nd generalized AU
AU3 = An(zbar,z_scatU,f0,Wk,rho,3); % 3rd generalized AU
AU4 = An(zbar,z_scatU,f0,Wk,rho,4); % 4th generalized AU

% terms d_j, defined into the supplementary document
d0 = (alpha.*zbar+Disp).^2;
d1 = -2.*(1+alpha).*(alpha.*zbar+Disp);
d2 = alpha*(2+alpha);


% Phase term Ph_BL, defined into the supplementary document
PSI = -4.*pi.*f0.*(Disp+alpha.*zbar);
Ph_BL = exp(1i.*PSI -d0.*Wk.^2);

%Coefficients c_j, defined into the supplementary document
c1 = 1i.*4.*pi.*f0.*alpha + 2.*Wk.^2.*(1+alpha).*(alpha.*zbar+Disp);
c2 = (-Wk.^2.*d2 + c1.^2./2);
c3 = (-Wk.^2.*d2.*c1 + c1.^3./6);
c4 = ((-Wk.^2.*d2).^2./2 + c1.^2.*(-Wk.^2.*d2)./2 + c1.^4./24);

% Truncated version of the series Expansion defined in Eq. (6)
BL_est0 = AU.*Ph_BL;  % Eq. (6), truncated at n = 0
BL_est1 = BL_est0 + c1.*AU1.*Ph_BL; % Eq. (6), truncated at n = 1
BL_est2 = BL_est1 + c2.*AU2.*Ph_BL; % Eq. (6), truncated at n = 2
BL_est3 = BL_est2 + c3.*AU3.*Ph_BL; % Eq. (6), truncated at n = 3
BL_est4 = BL_est3 + c4.*AU4.*Ph_BL; % Eq. (6), truncated at n = 4


% Figure (2)
figure(1); clf; NL = 2; NF = 9;   xvec = [100,200];
subplot(2,4,1);  xlabel('z(\mu m)'); hold on; plot(zbar.*1e6,real(AU),'k','Linewidth',NL*2);  xlim(xvec); plot(zbar.*1e6,real(AL),'r','Linewidth',NL); title(['Unloaded']); legend('U','L'); set(gca,'FontSize',NF);  
subplot(2,4,2);  xlabel('z(\mu m)'); hold on; plot(zbar.*1e6,real(BL_est0),'k','Linewidth',NL*2); plot(zbar.*1e6,real(AL),'r','Linewidth',NL); xlim(xvec); title(['n = 0']); legend('n=0','L'); set(gca,'FontSize',NF);  
subplot(2,4,3);  xlabel('z(\mu m)'); hold on; plot(zbar.*1e6,real(BL_est1),'k','Linewidth',NL*2); plot(zbar.*1e6,real(AL),'r','Linewidth',NL); xlim(xvec); title(['n = 1']); legend('n=1','L'); set(gca,'FontSize',NF);  
subplot(2,4,4);  xlabel('z(\mu m)'); hold on; plot(zbar.*1e6,real(BL_est4),'k','Linewidth',NL*2); plot(zbar.*1e6,real(AL),'r','Linewidth',NL); xlim(xvec); title(['n = 4']); legend('n=4','L'); set(gca,'FontSize',NF);  
sgtitle(['\epsilon = ', num2str(alpha*1e3,2), 'm\epsilon', ',    \Delta = ', num2str(Disp*1e6,2), '\mu m'],'FontSize',2*NF);  set(gca,'FontSize',NF);



