clear all; clc;



% Update the path with the folder containing the scripts.
path_string = '';

% Add to the path the folder containing all the nested functions employed in the following lines of code
addpath(genpath([path_string,'handle_functions_to_add']));

saving_file = [path_string,'VM_WLS_NEW_inclusion_phantom2.mat']; % File where the processed data were saved

if isfile(saving_file)
    DL = load(saving_file); unpackStruct(DL);
else
   % File containing both unloaded and loaded OCT C-scans. This file exceeds 20 GB and can be provided upon request.
    data_str_load = [path_string,'rta_vol_kxy_low.mat']; 

    % Uploading of the Unloaded and Loaded OCT C-scans of size 2048X2000X1999, in (f,x,y) space, where f represents the spatial frequencies array.
    DD = load(data_str_load).rta_vol_kxy;

    Ny_T = size(DD,3); Nx = size(DD,2); Nk = size(DD,1);
    IU_T = DD(:,:,1:2:(Ny_T-1)); % I stop at "Ny_T-1" at the end because the loaded B-scan is not available
    IL_T = DD(:,:,2:2:Ny_T); Ny = floor(Ny_T./2);

    % Parameters related to the OCT system used to acquire the images
    lam_min = 1163.4e-9; lam_max = 1401.6e-9; f_min = 1/lam_max; f_max = 1/lam_min; f0 = (f_min + f_max)/2;
    f_vec = linspace(f_min,f_max,Nk).'; % Equally spaced array of spatial frequencies
    k0 = 2*pi*f0; % Central wavenumber
    lambda0 = 1/f0; % wavelength corresponding to the central spatial frequency f0
    chirp_data = load([path_string,'Chirp_UWA.dat']);
    f_raw = f_min + (f_max - f_min).*chirp_data./2047; % Array of the raw-frequencies

    % Setting spectrum Parameters
    cut_off = 1e-3; % Bandwidth cut-off
    Wk = 2*pi*(f_max-f0)/sqrt(log(1/cut_off)); % Bandwidth cut-off
    Sk =  1/sqrt(pi)./Wk.*exp(-(2*pi*(f_vec(:)-f0)./Wk).^2);  % Gaussian Power spectral density

    % Raw OCT signals in frequency domain
    IU_T_ss_raw = double(IU_T); clear IU_T ; IL_T_ss_raw = double(IL_T); clear IL_T;

    % OCT signals calculated on equally-spaced spatial frequencies, by interpolating the raw OCT signals
    IU_T_ss = zeros(size(IU_T_ss_raw)); IL_T_ss = IU_T_ss; Nx_st = 50; Nxr = ceil(Nx/Nx_st);
    for ix = 1:Nx_st
        IX_tmp = (ix-1)*Nxr + [1:Nxr];

        disp(['Spectrum interpolation, step ', num2str(ix),'/', num2str(Nx_st)]);
        [IU_T_ss_tmp,f_vec] = eq_sig_int(IU_T_ss_raw(:,IX_tmp,:),f_raw); IU_T_ss(:,IX_tmp,:) = IU_T_ss_tmp;
        [IL_T_ss_tmp,f_vec] = eq_sig_int(IL_T_ss_raw(:,IX_tmp,:),f_raw); IL_T_ss(:,IX_tmp,:) = IL_T_ss_tmp;
    end

    clear IU_T_ss_raw IL_T_ss_raw;

    %%%%%%   En-face calculation at the plane z = 400e-6;
    fit_range = 100e-6; % Axial fitting range used for all OCE methods
    res = 3.5e-6; % Axial step-size used for the elastograms generated with the New method

    % Lateral shifting applied to the Loaded Data to match the Unloaded Data
    Nx_lat = 1; % Maximum number of voxels displaced in x-direction --> indices shifting test: -1,0,1
    Ny_lat = 1; % Maximum number of voxels displaced in y-direction --> indices shifting test: -1,0,1
    z0 = 400e-6; % depth at which the en-face image is extracted
    zmin_s = z0 - 55e-6; % Minimum axial depth employed by the algorithms to retrieve the en-face elastograms
    zmax_s = z0 + 55e-6; % Maximum axial depth employed by the algorithms to retrieve the en-face elastograms
    z_range_en = [zmin_s,zmax_s];

    %%%   New method: strain retrieval    %%
    Nx_T = size(IU_T_ss,2);
    IY0 = 501:1500; % C-scan reduction from 2000 to 1000 B-scans
    Ny_T2 = length(IY0);
    [str_en, z_csr, Disp_en,Err_en,vec_lat_x_en,vec_lat_y_en] = CSR_Tay_10_tot_comb(zmin_s,zmax_s,f_vec ,IU_T_ss(:,:,IY0), IL_T_ss(:,:,IY0),fit_range,res,Nx_lat,Ny_lat); Np_z = length(z_csr);

    % Data saving
    int_prec = 8;
    str_en = precision_set2(str_en,int_prec,1); 
    DATASET.str_en = str_en; DATASET.z_csr = z_csr; DATASET.Disp_en = Disp_en; DATASET.Err_en = precision_set2(Err_en,int_prec,1);
    DATASET.vec_lat_x_en = precision_set2(vec_lat_x_en,int_prec,1); DATASET.vec_lat_y_en = precision_set2(vec_lat_y_en,int_prec,1);
    DATASET.IY0 = IY0; DATASET.zmin_s = zmin_s; DATASET.zmax_s = zmin_s; DATASET.f_vec = f_vec; DATASET.Nk = Nk; DATASET.z0 = z0;
    DATASET.Nx_T = Nx_T; DATASET.Ny = Ny; DATASET.Ny_T = Ny_T; DATASET.Ny_T2 = Ny_T2; DATASET.Nx_lat = Nx_lat; DATASET.Ny_lat = Ny_lat;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%% OCT signals preparation for both WLS & VM %%
    dz_tmp = 2e-6*sqrt(2); % Axial step-size used for samping the OCT signals in z-domain
    Nz_en = ceil((zmax_s-zmin_s)./dz_tmp);  %number of voxels in the axial direction related to the range [zmin_s,zmax_s] with step-size dz_tmp
    BUT_400 = zeros(Nz_en,Nx_T,Ny_T2);
    BLT_400 = zeros(Nz_en,Nx_T,Ny_T2);
    Nv = 10; Nvx = ceil(Nx_T/10);

    Sm = mean(IU_T_ss,[2,3]); % Average of the original power spectral density, performed across all OCT A-scans of the Unloaded OCT C-scan

    % Furier transform of the OCT signals, from Fourier domain to spatial
    % domain. FFT is performed in multiple steps because the OCT C-scans are too large
    for iv = 1:Nv
        fprintf(' Iteration %d/%d\n\n',iv,Nv)
        IV = [1:Nvx] + (iv-1)*Nvx; if iv == Nv; IV = (1+(iv-1)*Nvx):Nx_T; end
        IU_0 = IU_T_ss(:,IV,IY0)./Sm; IL_0 = IL_T_ss(:,IV,IY0)./Sm; [Szm,zb2_en] = gen_fft2(-1,f_vec-f0,Sm,2*[zmin_s,zmax_s],Nz_en); zbar = zb2_en/2;
        BU_0 = ff_tr(IU_0.*Sk,f_vec,0,-1); BL_0 = ff_tr(IL_0.*Sk,f_vec,0,-1);  % (STANDARD NORMALIZATION): IT_CCgen  = IT_CCgen_flat -mean(IT_CCgen_flat,1);%
        BUT_400(:,IV,:) = gen_fft2(-1,f_vec,(IU_0-BU_0*2*pi).*Sk,zb2_en); BLT_400(:,IV,:) = gen_fft2(-1,f_vec,(IL_0-BL_0*2*pi).*Sk,zb2_en); %plt.plot(zbar,np.absolute(BU[2,2,:])); plt.plot(zbar,np.absolute(BL[2,2,:]));
    end

    %  Kasai-estimator: Complex phase difference used by botVM and WLS methods
    BULT_400 = BUT_400.*conj(BLT_400);
    BULT_400 = permute(BULT_400,[2,3,1]); dx = 2e-6;

    fprintf('\n\n Simulation en-face  :\n\n');
    fit_range = 100e-6; Nz_fit = min(find(zbar>zbar(1)+fit_range)); dz = zbar(2)-zbar(1);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % WLS strain retrieval
    aw = [2,2,2]; % Number of voxels averaged in x,y, and z direction, respectively.
    aw2 = [1,1,7]; % Number of voxels used by the phase unwrapping algorithm incorporated into the WLS method in x,y, and z direction, respectively.
    [str_en_UWA2,z_en_UWA,unwrap_uwa_xyz] =  strain_UWA(lambda0,zbar,BULT_400,1:Nx_T,1:Ny_T2,fit_range,aw2,aw); % Weighted Least Square method Matlab function
    int_prec = 8; % Compression number. If it is "8" or "16" data are compressed into unit8 or unit16 data.

    % Data saving
    str_en_UWA2 = precision_set2(str_en_UWA2,int_prec,1);
    DATASET.str_en_UWA2 = str_en_UWA2; % Compressed version of str_en_UWA2
    DATASET.z_en_UWA = z_en_UWA;
    DATASET.zbar = zbar; DATASET.z_range_en = z_range_en; DATASET.lambda0 = lambda0; DATASET.aw = aw; DATASET.aw2 = aw2; 
    save(saving_file,'DATASET','-v7.3');

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % VM strain retrieval
    pw = [2,2,Nz_fit];  % processing_window used by Vector Method. First and second number are the number of voxels in x and y directions, respctively. THe third number (Nz_fit) is the width employed into the processing window, expressed in meters.
    [str_en_VM, zp_en_VM]   = strain_VM4(BULT_400, z_range_en, k0, pw, aw); % Vector Method Matlab function
    str_en_VM = precision_set2(str_en_VM,int_prec,1); DATASET.str_en_VM = str_en_VM; 
    DATASET.zp_en_VM = zp_en_VM; DATASET.pw = pw;

    save(saving_file,'DATASET','-v7.3'); % Data saving
end

% Plots generated from the above script

dx = 2e-6; % Lateral sampling of the acquired OCT C-scans (in meters)
refind = 1.42; % Background refractive index of teh inclusion phantom
x_scan = dx*[1:Nx_T]; % x-coordinates
x_scan_csr = x_scan(Nx_lat+1:Nx_T-Nx_lat);  % x-coordinates for the NEW method
y_scan = dx*[1:Ny];  % y-coordinates
y_scan_csr = y_scan(IY0(Ny_lat+1:Ny_T2-Ny_lat)); % y-coordinates for the NEW method

%%%%%   Plots of EN-face elastograms   %%%%

%%%%%%%%%%   Axial index corresponding to 400 micron of  depth, for the three strain retrieval methods
iz0_csr = min(find(z_csr >= z0)); %  NEW
iz0_uwa = min(find(z_en_UWA >= z0)); % WLS
iz0_vm = min(find(zp_en_VM >= z0)); %  VM

%%%%%%%%%% En-face elastograms corresponding to  z = 400 micron: Decopression of the compressed file and storage in new variables
str0_csr = squeeze(func_cell2(str_en,iz0_csr,'all',"all")); % NEW
str0_vm = squeeze(func_cell2(str_en_VM,'all',"all",iz0_vm)); % VM
str0_uwa2 = squeeze(func_cell2(str_en_UWA2,'all',"all",iz0_uwa)); % WLS

% Plots (e-f-g) of Fig. (8) of the manuscript
vecy = [1650,2900]*1e-6; vecx = [1100,2700]*1e-6; vec_a = [-1,1]*1e-3; NF = 10;
figure(1); clf; imagesc_set(str0_csr,y_scan_csr,x_scan_csr); caxis(vec_a); axis equal; colormap('hot'); xlim(vecx); ylim(vecy); set(gca,"xtick",[],"ytick",[],'FontSize',NF);
figure(2); clf; imagesc_set(str0_vm,y_scan(IY0),x_scan); caxis(vec_a); axis equal;  colormap('hot'); xlim(vecx); ylim(vecy); set(gca,"xtick",[],"ytick",[],'FontSize',NF);
figure(3); clf; imagesc_set(str0_uwa2,y_scan(IY0),x_scan); caxis(vec_a); axis equal;  colormap('hot'); xlim(vecx); ylim(vecy); set(gca,"xtick",[],"ytick",[],'FontSize',NF);

IYT = 600; % index of the line in the x-direction corresponding to y = 550 micron in the coordinates used in plots h) and i) of Fig. (8)

% 1D elastograms corresponding to y = 550 micron and z = 400 micron
sm0 = str0_csr(:,IYT); % NEW
sm1 = str0_vm(:,IYT); % VM
sm2 = str0_uwa2(:,IYT); % WLS
for it = 0:2; eval(['[snr_',num2str(it),', mean_',num2str(it),',std_',num2str(it),'] = local_snr(sm',num2str(it),',[25,1,1]);']); end %

% Plots (h-i) in Fig. (8) of the manuscript
figure(4); clf; hold on; plot(x_scan_csr,mean_0); plot(x_scan,mean_1); plot(x_scan,mean_2); xlim(vecx);
figure(5); clf; hold on; plot(x_scan_csr,snr_0); plot(x_scan,snr_1); plot(x_scan,snr_2); xlim(vecx);


