% This script generates Fig. (8a-b-c-d)

clear all; clc;

% Update the path with the folder containing the scripts.
path_string = [''];
% path_string = '/home/amazzolani/Matlab_drive_scripts/post_doc_code/Experimental_data/remotedata/PhD/saved_heavy_files/inclusion_UWA/';

% Add to the path the folder containing all the nested functions employed in the following lines of code
addpath(genpath([path_string,'handle_functions_to_add']));

% File where the processed data were saved
saving_file = [path_string,'CSR_test_3D_04_02_2025_Nx_160801_zmin_0_zmax_750_ds_11_dz_36_pw_2_Na_20_Nd_9_Nxy_55_Off_56_red.mat']; 


if isfile(saving_file)
    DL = load(saving_file); unpackStruct(DL);
else

    rng(6); % fixed random seed to ensure reproducible simulation results

    % Parameters related to the OCT system used to acquire the experimental data
    lam_min = 1170.5e-9; lam_max = 1407.8e-9; f_min = 1./lam_max; f_max = 1./lam_min; f0 = (f_min + f_max)/2; Df = f_max - f_min;

    Nx = 301;160801; % Number of independent unloaded A-scans generated
    N_eps = 3;20; % Number of strains applied for each unloaded A-scan
    N_Delta = 3;9; % Number of bulk-displacement applied for each  unloaded A-scan

    % z-space
    zmin = 0e-6;     % Minimum axial depth of the simulated OCT A-scans
    zmax = 750e-6;   % Maximum axial depth of the simulated OCT A-scans
    DZ = zmax-zmin;  % Axial range of the simulated OCT A-scans
    dz_thin_tmp = 0.6e-6; % Estimation of the Small step-size used for finely sampling OCT A-scans
    Nz = ceil(DZ/dz_thin_tmp/2)*2+1; % Number of points for the finely sampled OCT A-scans
    dz = DZ./(Nz-1); % Small step-size used for finely sampling OCT A-scans
    dz_OCE =  3.6e-6; % step-size corresponding to OCT A-scans with spectrum ~ [1050,1400]nn
    fitting_range = 100e-6; % Axial fitting range employed by the NEW method to estimate the error function (see Eq. (12))
    K0 = 2*pi*f0; % Central wavenumber
    lambda = 2*pi./K0; % Wavelength corresponding to the central wavenumber
    Nzb  = ceil((fitting_range + 25e-6)/dz_thin_tmp); % Number of pixels of the OCT A-scans used for each OCE A-scan interval
    IZb = 1:Nzb; % Array of indices of each OCE A-scan interval
    d_step = 65e-6; % Axial distance between the centers of two subsequent interval centers of the  OCE A-scans intervals
    iz_step = ceil(d_step/dz_thin_tmp); % Number of pixels corresponding to "d_step"
    ind_minz = [1:iz_step:Nz-Nzb]; ind_minz = ind_minz(1:end-1); % indices of the minima of each subsequent interval
    Nintz = length(ind_minz); % number of OCE intervals analyzed for each OCE A-scan (each epsilon and each Delta)

    %%%% Definition of the arrays used to store the results.
    eps_vec = linspace(-3,3,N_eps)*1e-3; % simulated strains
    Delta_vec = linspace(-1.5,1.5,N_Delta)*1e-6; % simulated bulk displacements

    S_j = cell(N_eps,N_Delta,Nintz); % Estimated strains of signals containing at least a "2-pi jump"
    S_p = cell(N_eps,N_Delta,Nintz); % Estimated strains of signals containing an high oscillation peak
    S_n = cell(N_eps,N_Delta,Nintz); % Estimated strains of signals containing low oscillation peaks
    S_g = cell(N_eps,N_Delta,Nintz); % Cell containing all the estimated strains

    % parallelization setting
    poolobj = gcp('nocreate');
    if isempty(poolobj); poolobj = parpool('Threads'); else; if strcmp(class(poolobj),'parallel.ProcessPool'); delete(gcp('nocreate')); poolobj = parpool('Threads');  end; end

    % Array containing the number of signals generated for the 4 classes (2pi-jump, high osc.peaks, low osc. peaks, and a fourth class of all signals generated)
    Pars = zeros(N_eps,N_Delta,Nintz,4,2); Pars_prod = zeros(N_eps,N_Delta,Nintz,4);

    % OCT A-scans generation (Eq. (4a-4b))
    dens_scat = 11; % Average number of scatterers per 10 microns of axial depth
    Ws = 20e-6; % Extra optical path used to generate meaningful OCT signals also around zmin and zmax
    DZ_s = DZ + Ws; % Total axial length
    zmin_s = zmin - Ws/2; zmax_s = zmax + Ws/2; % minimum and maximum axial depth related to the total axial length

    Ns = ceil(dens_scat*DZ_s*1e5); % Number of scatterers for each simulated OCT A-scan
    rho_max = 3e-4; % Maximum of the scattering cross-section parameter
    cut_off = 1e-1; % Frequencies cut-off at the edge of the spectrum
    rho = rho_max.*rand(Ns,Nx); % Array of the scattering cross-section parameters, for all scatterers ad all signals
    z_scatU = zmin_s + DZ_s.*sort(rand(Nx,Ns),2); % Array of the scattering axial coordinates, for all scatterers ad all signals
    Nk_nyq = 4*zmax*Df; % Number of spatial frequencies needed to generate signals with maximum depth "zmax"
    Nk_tmp = ceil(Nk_nyq*1.5); % Upper bound for Nk_nyq
    f_vec = linspace(f_min,f_max,Nk_tmp); % Array of the spatial frequencies
    Wk = 2*pi*(f_max-f0)/sqrt(log(1/cut_off)); % spectral width of the light sourcr
    dfvec = f_vec(2)-f_vec(1); % sampled spatial frequencies step-size
    Nk = length(f_vec); % Number of simulated monochromatic components
    Sk =  2.*pi./sqrt(pi)./Wk.*exp(-(2*pi*(f_vec(:)-f0)./Wk).^2); % Spectral density

    IU = zeros(Nk,Nx); % Array of unloaded raw signals
    BU = zeros(Nz,Nx); % Array of unloaded signals in z- domain

    IU(:,1) = exp(-1i.*z_scatU(1,:).*4.*pi.*f_vec(:))*rho(:,1);
    [BU(:,1),zb2] = gen_fft2(-1,f_vec,IU(:,1).*Sk,2.*[zmin,zmax],Nz); % calculation of the array of axial coordinates zb2 and zbar
    zbar = zb2(:)./2; % Array of z coordinates wher the OCT signals have been calculated

    % Loop generating all raw and z-domain OCT signals
    parfor ix = 2:Nx
        IU(:,ix) = exp(-1i.*z_scatU(ix,:).*4.*pi.*f_vec(:))*rho(:,ix);
        BU(:,ix) = gen_fft2(-1,f_vec,IU(:,ix).*Sk,zb2,Nz); % Eq. (3a)
    end

    BU = BU.*exp(-1i.*4.*pi.*f0.*zbar); % Eq. (4a) Demodulated unloaded signal


    for ia = 1:N_eps % loop over the simulated axial strains 
        alpha = eps_vec(ia);  % Strain

        ILa = zeros(Nk,Nx);  % Array used to computation all the loaded A-scan for the strain alpha
        parfor ix = 1:Nx 
            ILa(:,ix) = exp(-1i.*z_scatU(ix,:).*(1+alpha).*4.*pi.*f_vec(:))*rho(:,ix);
        end

        for id = 1:N_Delta % loop over the simulated Bulk displacements 
            fprintf('ia,id = (%d,%d)/(%d,%d)\n',ia,id,N_eps,N_Delta);

            BL = zeros(Nz,Nx); % Array of loaded signals in z- domain
            Disp = Delta_vec(id); % Bulk displacement

            IL = ILa.*exp(-1i.*4.*pi.*f_vec(:).*Disp); % Loaded signal in raw domain
            parfor ix = 1:Nx;
                BL(:,ix) = gen_fft2(-1,f_vec,IL(:,ix).*Sk,zb2,Nz);
            end
            BL = BL.*exp(-1i.*4.*pi.*f0.*zbar); % Loaded signal in z-domain

            % Generation of the three kind of signals, including 2-pi jumps, high and low oscillation peaks
            for iz = 1:Nintz % loop over the signal depths analyzed in Figs. 6c), 7c), 7g), 8c) 
                IZ_tmp = ind_minz(iz) - 1 + IZb; %
                itp = 0; itj = 0; itn = 0;  itg = 0; Nxy = 55; Nmax = Nxy^2; cond_tot = 1; iss = 0;
                BUL_peak = zeros(Nzb,Nxy^2); BUL_gen = zeros(Nzb,Nxy^2); BUL_no_dark = zeros(Nzb,Nxy^2); BUL_jump = zeros(Nzb,Nxy^2);
                IU_jump = zeros(Nk,Nxy^2); IL_jump = zeros(Nk,Nxy^2); IU_peak = zeros(Nk,Nxy^2); IL_peak = zeros(Nk,Nxy^2); IU_no_dark = zeros(Nk,Nxy^2); IL_no_dark = zeros(Nk,Nxy^2); IU_gen = zeros(Nk,Nxy^2); IL_gen = zeros(Nk,Nxy^2);
                C_JNP = 1; C_G = 1; C_N = 1; C_J = 1; C_P = 1; Ix_comb = [1:Nx].'; % nchoosek(1:Nx,2);
                INDs = 1:Nx;  Nsh = floor(size(Ix_comb,1)/Nx)-1;

                while C_JNP % loop that separates each generated signal as 2-pi jump, high peak or low oscillation peak
                    iss = iss+1;
                    Ix_comb1 = Ix_comb(INDs,1);
                    BUs1 = BU(:,Ix_comb1);  BLs1 = BL(:,Ix_comb1);
                    IUs1 = IU(:,Ix_comb1); ILs1 = IL(:,Ix_comb1);
                    BUL = (BUs1).*conj(BLs1);
                    Dphi_wrap = angle(BUL); Dphi = unwrap(Dphi_wrap); Dphim = Dphi;
                    xvec = [zmin*1e6+50,zmax*1e6-50];
                    IZ0 = find( (zbar>=xvec(1)*1e-6)&(zbar<=xvec(2)*1e-6)); iz0 = IZ0(1); Dphi_rig_tmp = (Disp+ alpha.*zbar).*2.*K0;
                    Dphi_rig = Dphi_rig_tmp - Dphi_rig_tmp(iz0) + Dphim(iz0,:,:); i_slit2 = 0; i_slit = 2*i_slit2+1;
                    D_red = (Dphim-Dphi_rig)./2./pi; D_mean_T =  (movmean(D_red,i_slit,1));
                    Offset = 0.55;  Offset_peak1 = 0.65; 0.5;  Offset_peak2 = 0.95; off_jump = 1.2;
                    D_mean = D_mean_T(IZ_tmp,:); BUxy = BUL(IZ_tmp,:);
                    MD = max(D_mean); mD = min(D_mean); MmD = (MD-mD).*ones(size(BUxy));
                    sD = sum(D_mean-min(D_mean)).*ones(size(BUxy));
                    cond_mean1 = abs(sD)*dz_thin_tmp>0.45*(zbar(Nzb)-zbar(1));
                    cond_mean2 = 1;
                    cond_n =  (MmD <= Offset);
                    cond_j = (MmD >= off_jump)&cond_mean1;
                    cond_p =   not(cond_j) & (MmD >= Offset_peak1) &(MmD <= Offset_peak2) & cond_mean2;
                    if C_N; BUL_n = BUxy(:,cond_n(1,:)); IU_n = IU(:,cond_n(1,:)); IL_n = IL(:,cond_n(1,:)); end;
                    if C_J; BUL_j = BUxy(:,cond_j(1,:)); IU_j = IU(:,cond_j(1,:)); IL_j = IL(:,cond_j(1,:)); end;
                    if C_P; BUL_p = BUxy(:,cond_p(1,:)); IU_p = IU(:,cond_p(1,:)); IL_p = IL(:,cond_p(1,:)); end;

                    if C_N; itn_2 = itn + size(BUL_n,2); BUL_no_dark(:,itn+1:itn_2) = BUL_n; IU_no_dark(:,itn+1:itn_2) = IU_n; IL_no_dark(:,itn+1:itn_2) = IL_n; end;
                    if C_J; itj_2 = itj + size(BUL_j,2); BUL_jump(:,itj+1:itj_2) = BUL_j; IU_jump(:,itj+1:itj_2) = IU_j; IL_jump(:,itj+1:itj_2) = IL_j;  end;
                    if C_P; itp_2 = itp + size(BUL_p,2); BUL_peak(:,itp+1:itp_2) = BUL_p; IU_peak(:,itp+1:itp_2) = IU_p; IL_peak(:,itp+1:itp_2) = IL_p; end
                    if C_G; itg_2 = itg + size(BUxy,2); BUL_gen(:,itg+1:itg_2) = BUxy; IU_gen(:,itg+1:itg_2) = IU; IL_gen(:,itg+1:itg_2) = IL; end;
                    itn = itn_2; itj = itj_2; itp = itp_2;  itg = itg_2;

                    C_G = itg <= Nmax+1; C_N = itn <= Nmax+1; C_J = itj <= Nmax+1; C_P = itp <= Nmax+1; INDs = INDs+Nx; C_JNP = (C_N | C_J | C_P)& iss<=Nsh; % fprintf('inds = %d, iss = %d\n',INDs(1),iss);

                end

                Tp = 10; ind_8 = 16; pw(1) = 2; pw(2) = 2; pw(3) = ceil(fitting_range/dz_OCE);
                Ntg = min(itg-1,Nmax); Ntg1 = floor(sqrt(Ntg)); Ntg2 = floor(Ntg/Ntg1); Ntp =  min(itp-1,Nmax); Ntj = min(itj-1,Nmax); Ntn = min(itn-1,Nmax); Ntp1 = floor(sqrt(Ntp)); Ntp2 = floor(Ntp/Ntp1); Ntj1 = floor(sqrt(Ntj)); Ntj2 = floor(Ntj/Ntj1); Ntn1 = floor(sqrt(Ntn)); Ntn2 = floor(Ntn/Ntn1);
                z_range = [zbar(IZ_tmp(1)) zbar(IZ_tmp(Nzb))]; Pars(ia,id,iz,:,1) = [Ntj1,Ntp1,Ntn1,Ntg1]; Pars(ia,id,iz,:,2) = [Ntj2,Ntp2,Ntn2,Ntg2];
                Pars_prod(ia,id,iz,:) = [itj,itp,itn,itg];
                step_OCE = round(dz_OCE/dz); IZE = [1:step_OCE:Nzb]; IZE_z = IZ_tmp(IZE);

                fit_range = 100e-6; resolution = 5e-6; Nx_lat = 0; Ny_lat = 0;
                zmin_c = z_range(1); zmax_c = z_range(2);

                if Ntj1 >= Tp & Ntj2 >= Tp; IU_jump = IU_jump(:,1:Ntj1*Ntj2); IU_jump = reshape(IU_jump,[Nk,Ntj1,Ntj2]); IL_jump = IL_jump(:,1:Ntj1*Ntj2); IL_jump = reshape(IL_jump,[Nk,Ntj1,Ntj2]); [s_jump, zp_jump, D_jump] = CSR_Tay_gen_comb(zmin_c,zmax_c,f_vec,IU_jump, IL_jump,fit_range,resolution); S_j{ia,id,iz} = precision_set2(s_jump(1:3,:,:),ind_8,1); D_j{ia,id,iz} = precision_set2(D_jump(1:3,:,:),ind_8,1); end
                if Ntn1 >= Tp & Ntn2 >= Tp; IU_no_dark = IU_no_dark(:,1:Ntn1*Ntn2); IU_no_dark = reshape(IU_no_dark,[Nk,Ntn1,Ntn2]); IL_no_dark = IL_no_dark(:,1:Ntn1*Ntn2); IL_no_dark = reshape(IL_no_dark,[Nk,Ntn1,Ntn2]); [s_no_dark, zp_no_dark, D_no_dark] = CSR_Tay_gen_comb(zmin_c,zmax_c,f_vec,IU_no_dark, IL_no_dark,fit_range,resolution); S_n{ia,id,iz} = precision_set2(s_no_dark(1:3,:,:),ind_8,1); D_n{ia,id,iz} = precision_set2(D_no_dark(1:3,:,:),ind_8,1); end
                if Ntp1 >= Tp & Ntp2 >= Tp; IU_peak = IU_peak(:,1:Ntp1*Ntp2); IU_peak = reshape(IU_peak,[Nk,Ntp1,Ntp2]); IL_peak = IL_peak(:,1:Ntp1*Ntp2); IL_peak = reshape(IL_peak,[Nk,Ntp1,Ntp2]); [s_peak, zp_peak, D_peak] = CSR_Tay_gen_comb(zmin_c,zmax_c,f_vec,IU_peak, IL_peak,fit_range,resolution); S_p{ia,id,iz} = precision_set2(s_peak(1:3,:,:),ind_8,1); D_p{ia,id,iz} = precision_set2(D_peak(1:3,:,:),ind_8,1); end
                if Ntg1 >= Tp & Ntg2 >= Tp; IU_gen = IU_gen(:,1:Ntg1*Ntg2); IU_gen = reshape(IU_gen,[Nk,Ntg1,Ntg2]); IL_gen = IL_gen(:,1:Ntg1*Ntg2); IL_gen = reshape(IL_gen,[Nk,Ntg1,Ntg2]); [s_gen, zp_gen, D_gen] = CSR_Tay_gen_comb(zmin_c,zmax_c,f_vec,IU_gen, IL_gen,fit_range,resolution); S_g{ia,id,iz} = precision_set2(s_gen(1:3,:,:),ind_8,1); D_g{ia,id,iz} = precision_set2(D_gen(1:3,:,:),ind_8,1); end
            end
        end
    end

    izw = ceil(10e-6/dz_thin_tmp); WW = 1*[1,1,1]; coef_out = 111; Pars(abs(imag(Pars))>0) = 0; Pars = real(Pars); Pars(isnan(Pars)) = 0;
    str_v{1} = '_jump'; str_v{2} = '_peak';str_v{3} = '_no_dark'; str_v{4} = '_gen'; Nv = length(str_v);
    EE_j = zeros(N_eps,N_Delta,Nintz)+NaN; EE_p = zeros(N_eps,N_Delta,Nintz)+NaN; EE_n = zeros(N_eps,N_Delta,Nintz)+NaN; EE_g = zeros(N_eps,N_Delta,Nintz)+NaN;
    EED_j = zeros(N_eps,N_Delta,Nintz)+NaN; EED_p = zeros(N_eps,N_Delta,Nintz)+NaN; EED_n = zeros(N_eps,N_Delta,Nintz)+NaN; EED_g = zeros(N_eps,N_Delta,Nintz)+NaN;
    for ia = 1:N_eps; alpha = eps_vec(ia);
        for id = 1:N_Delta; Disp = Delta_vec(id);
            for iz = 1:Nintz;
                for iv = 1:Nv;
                    strv = str_v{iv};
                    eval(['if not(isempty(S',strv(1:2),'{ia,id,iz})); Nxy2 = min(Nxy,min(Pars(ia,id,iz,iv,:),[],5)); str_tmp = func_cell2(S',strv(1:2),'{ia,id,iz},"all",1:Nxy2,1:Nxy2);  str_tmp(abs(str_tmp-eps_vec(ia))>abs(eps_vec(ia)).*coef_out) = NaN; sm',strv,' = strain_optimized2(str_tmp,ones(size(str_tmp)),WW(1),WW(2),WW(3),1,"omitnan");  EE',strv(1:2),'(ia,id,iz) = mean( abs(sm',strv,' -alpha),"all","omitnan"); end;']);
                    eval(['if not(isempty(D',strv(1:2),'{ia,id,iz})); Nxy2 = min(Nxy,min(Pars(ia,id,iz,iv,:),[],5)); str_tmp = func_cell2(D',strv(1:2),'{ia,id,iz},"all",1:Nxy2,1:Nxy2);  str_tmp(abs(str_tmp-Delta_vec(id))>abs(Delta_vec(id)).*coef_out) = NaN; sm',strv,' = strain_optimized2(str_tmp,ones(size(str_tmp)),WW(1),WW(2),WW(3),1,"omitnan");  EED',strv(1:2),'(ia,id,iz) = mean( abs(sm',strv,' -alpha),"all","omitnan"); end;']);
                end
            end
        end
    end

    % Smoothing of the array of errors with a filter 3X3X3
    WWE = 3*[1,1,1];
    for iv = 1:Nv; strv = str_v{iv}; sv = strv(2);
        eval(['EE_m',sv,' = strain_optimized2(EE_',sv,',((EE_',sv,')),WWE(1),WWE(2),WWE(3),0.5,"omitnan");']);
    end


    str_image = ['Na_',num2str(N_eps),'_Nd_',num2str(N_Delta)]; str_off = num2str(ceil(Offset*1e2));
    str1 = [path_string,'/CSR_test_3D_04_02_2025_Nx_',num2str(Nx),'_zmin_',num2str(ceil(zmin*1e6)),'_zmax_',num2str(ceil(zmax*1e6)),'_ds_',num2str(dens_scat),'_dz_',num2str(ceil(dz_OCE*1e7)),'_pw_',num2str(pw(1)),'_',str_image,'_Nxy_',num2str(Nxy),'_Off_',str_off];
    clear DL z_scatU z_scatL zL rho BU BL BU_T BUL BUL0 BUL_3D Dphi* BU* BL* IU* IL* D_* poolobj cond_* MmD sD path_string*
    disp(str1);  save([str1,'.mat'],'-v7.3'); 
    
    % saving a smaller file that will be used for creating the plots  
    clear S_* Sv_*;  save([str1,'_red.mat'],'-v7.3'); 
    
end


IA0 = find(abs(eps_vec) >0 ); ID0 = find(Delta_vec <=1.5e-6 & Delta_vec >= -1.5e-6 );
ind_mean = ind_minz + ceil(Nzb/2);
IA_L = find((eps_vec)>3e-4);

EEE = EE_mj+EE_mp+EE_mn+EE_mg; 
condP = (min(Pars_prod,[],4) < (Nxy*0.73)^2); condP(isnan(EEE)) = 1;

Wp  = 1+0.*EE_mj; Wp(condP) = 0;
vcol = 'rbgk';

EE_mja = zeros(N_eps,N_Delta*Nintz);
for ia = 1:N_eps; E_tmp = EE_mj(ia,:,:); EE_mja(ia,:) = E_tmp(:); end;

ID00 = [1:N_Delta]; IZ00 = [1:length(ind_mean)]; Nz00 = length(ind_mean(IZ00));
VECZ = ((eps_vec(IA_L).').*reshape(zbar(ind_mean(IZ00)),[1,1,Nz00])+Delta_vec(ID00));
[VEC_sort,ind_sort]  = sort(VECZ(:)); vecdx =[0,max(VEC_sort)];
Ip = Wp(IA0,:,:); Ip = logical(Ip(ind_sort));

%%%%%%%%  Plots  %%%%%%%%%%%%% 

% Plots (a,b,c) of Fig. (8) 
NF = 12; NL = 2;
iaL = min(find(eps_vec >= 1e-3)); round(N_eps/2)+3; idL = round(N_Delta/2)+1; izL = round(Nintz*0.3); aIA0 = abs(eps_vec(IA_L).');
Nv0 = 3; Nv; yvec = [-4.5,-2.4]; vecy_tmp = [2.2,11.5]*1e-2;
figure(1); clf; hold on; for iv = 1:Nv0; str_tmp = '-'; eval(['plot( eps_vec(IA_L),log10(movmean(squeeze(EE_m',str_v{iv}(2),'(IA_L,idL,izL)./aIA0),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  ylim(yvec);  % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
figure(2); clf; hold on; for iv = 1:Nv0; str_tmp = '-'; eval(['plot( Delta_vec(ID0),log10(movmean(squeeze(EE_m',str_v{iv}(2),'(iaL,ID0,izL)./abs(eps_vec(iaL))),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;  ylim(yvec);  % set(gca,"xtick",[],"ytick",[],'FontSize',NF);
figure(3); clf; hold on; for iv = 1:Nv0; str_tmp = '-'; eval(['plot( zbar(ind_mean),log10(movmean(squeeze(EE_m',str_v{iv}(2),'(iaL,idL,:)./abs(eps_vec(iaL))),3,"omitnan")),"',str_tmp,'","Color",vcol(iv),"Linewidth",NL);']); end;   ylim(yvec); % set(gca,"xtick",[],"ytick",[],'FontSize',NF);


% Plot (d) of Fig. (8) 
EE_mj_sort = EE_mj(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mj_sort = EE_mj_sort(ind_sort); EE_mj_sort = EE_mj_sort(Ip);
EE_mn_sort = EE_mn(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mn_sort = EE_mn_sort(ind_sort); EE_mn_sort = EE_mn_sort(Ip);
EE_mp_sort = EE_mp(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mp_sort = EE_mp_sort(ind_sort); EE_mp_sort = EE_mp_sort(Ip);
EE_mg_sort = EE_mg(IA_L,ID00,IZ00)./abs(eps_vec(IA_L).'); EE_mg_sort = EE_mg_sort(ind_sort); EE_mg_sort = EE_mg_sort(Ip);


figure(4); clf; hold on; ids = 55; vecdz = [-4.5,-2.7];
for iv = 1:3;Nv; stline = '-';
    eval(['EE_m_tmp_sort = EE_m',str_v{iv}(2),'_sort;']); 
    plot(VEC_sort(Ip),log10(movmean(EE_m_tmp_sort(:),ids,'omitnan')),stline,'Color',vcol(iv),'Linewidth',NL);  ylim(vecdz); xlim(vecdx); %set(gca,'xtick',[],'ytick',[]); set(gca,'FontSize',NF); %
end


