% This script generates Fig. (4)

clear all; clc;

% Update the path with the folder containing the scripts.
path_string = '';

% Add to the path the folder containing all the nested functions employed in the following lines of code
addpath(genpath([path_string,'handle_functions_to_add']));

saving_file = [path_string,'OCT_data.mat']; 

DL = load(saving_file).DD;  

BU = DL.BU; % Unloaded OCT B-scan
BL = DL.BL; % Loaded OCT B-scan
zbar = DL.zbar; % Complex phase difference
BUL = BU.*conj(BL); % Complex phase difference

dphi_wrap = (angle(BUL)); % Wrapped phase difference
dphi = unwrap(dphi_wrap); % Unrapped phase difference
ix0 = 49; % Lateral index of the A_scan used to plot the phase difference in plots a), c)

Nx = size(BU,2); % Number of A-scans
Nz = size(BU,1); % Number of points sampled in depth for each A-scans
x_scan = 2e-6*[1:Nx]; % lateral sampling
 
% Plots of Fig. (5)
BU_0 = BU./max(abs(BU(:))); % Normalized B-scan
figure(1); clf; NL = 1.5; INDZ = Nz*0.1:Nz*0.4; dx = 15; IX0 = [ix0 - dx:ix0+dx];  
subplot(3,1,1); semilogy(zbar(INDZ)*1e6,abs(BU(INDZ,ix0)),'b','LineWidth',NL); xlabel('z (\mum)');  
subplot(3,1,2); hold on; imagesc_set(abs(BU_0(INDZ,IX0)),x_scan(IX0)*1e6,zbar(INDZ)*1e6);  caxis(10.^[-4,-2.1]);
colormap('gray'); axis equal; plot(zbar(INDZ).*1e6,x_scan(ix0).*1e6.*ones(length(INDZ),1),'b--','LineWidth',NL); xlabel('z (\mum)'); ylabel('x (\mum)')
subplot(3,1,3); plot(zbar(INDZ)*1e6,dphi(INDZ,ix0)./2./pi,'k','LineWidth',NL); legend('\Delta\phi'); xlabel('z (\mum)')
 

