% 数据加载与预处理
epsilon = 1e-10;
satname = 'GF5A';
k_name = ['k_', satname];
%% 加载气体吸收系数文件
% 水汽
load('data/H2O_k/H2O_k_v2.mat', k_name)
eval(['k_H2O = ', k_name, '(:, end);'])
k_H2O = k_H2O / sum(k_H2O); % 归一化
k_H2O(k_H2O <= epsilon) = epsilon;
% 甲烷
load('data/CH4_k/CH4_k_v2.mat', k_name)
eval(['k_CH4 = ', k_name, '(:, end);'])
k_CH4 = k_CH4 / sum(k_CH4); % 归一化
k_CH4(k_CH4 <= epsilon) = epsilon;
% 二氧化碳
load('data/CO2_k/CO2_k_v1.mat', k_name)
eval(['k_CO2 = ', k_name, '(:, end);'])
k_CO2 = k_CO2 / sum(k_CO2); % 归一化
k_CO2(k_CO2 <= epsilon) = epsilon;
% 波长数据
eval(['band = ', k_name, '(:, 1);']) % 波段数据

%% 选取CO2兴趣波段
% 找到每个数据点处最大值的索引
[max_values, max_idx] = max([k_H2O, k_CH4, k_CO2], [], 2);
selected_band_idx = max_idx == 3; % CO2最大
selected_band = band(selected_band_idx)

%% 制图
% 创建画布
figure('position',  [0 0 1000 250]);
hold on;
grid on;

% 绘图参数
linewidth = 1;
FaceAlpha = 0.4;

% 颜色矩阵
colors = {[166, 186, 204]/255,...
            [158, 148, 182]/255,...
            [191, 145, 105]/255,...
            [62, 53, 64]/255};

% 绘制折线图
plot(band, k_H2O, '-o', 'MarkerSize', 2, 'DisplayName', 'H2O', 'linewidth', linewidth, 'Color', colors{1});
plot(band, k_CH4, '-o', 'MarkerSize', 2, 'DisplayName', 'CH4', 'linewidth', linewidth, 'Color', colors{2});
plot(band, k_CO2, '-o', 'MarkerSize', 2, 'DisplayName', 'CO2', 'linewidth', linewidth, 'Color', colors{3});

% 坐标轴相关
xlim([1000 2500])
ylim([1e-8 1])
xticks(linspace(1000, 2500, 16));  % 设置x轴刻度
set(gca, 'yscale', 'log');

% 绘制面积图，每个点根据最高线索引填充对应颜色
% 填充面积
for i = 1:length(band)-1
    x_fill = [band(i), band(i+1), band(i+1), band(i)];

    % 判断是否发生了交叉
    if max_idx(i) ~= max_idx(i+1)
        % 对数空间中的线性插值 (使用log10)
        log_k_H2O_i = log10(k_H2O(i));
        log_k_H2O_ip1 = log10(k_H2O(i+1));
        log_k_CH4_i = log10(k_CH4(i));
        log_k_CH4_ip1 = log10(k_CH4(i+1));
        log_k_CO2_i = log10(k_CO2(i));
        log_k_CO2_ip1 = log10(k_CO2(i+1));
        
        % 找出交叉的两条线，计算交点 (对数空间插值)
        if max_idx(i) == 1 && max_idx(i+1) == 2 || max_idx(i) == 2 && max_idx(i+1) == 1
            % H2O 和 CH4 交点
            k1_slope_log = (log_k_H2O_ip1 - log_k_H2O_i) / (band(i+1) - band(i));
            k2_slope_log = (log_k_CH4_ip1 - log_k_CH4_i) / (band(i+1) - band(i));
            x_cross = band(i) + (log_k_H2O_i - log_k_CH4_i) / (k2_slope_log - k1_slope_log);
            log_k_cross = log_k_H2O_i + k1_slope_log * (x_cross - band(i));
        elseif max_idx(i) == 1 && max_idx(i+1) == 3 || max_idx(i) == 3 && max_idx(i+1) == 1
            % H2O 和 CO2 交点
            k1_slope_log = (log_k_H2O_ip1 - log_k_H2O_i) / (band(i+1) - band(i));
            k3_slope_log = (log_k_CO2_ip1 - log_k_CO2_i) / (band(i+1) - band(i));
            x_cross = band(i) + (log_k_H2O_i - log_k_CO2_i) / (k3_slope_log - k1_slope_log);
            log_k_cross = log_k_H2O_i + k1_slope_log * (x_cross - band(i));
        elseif max_idx(i) == 2 && max_idx(i+1) == 3 || max_idx(i) == 3 && max_idx(i+1) == 2
            % CH4 和 CO2 交点
            k2_slope_log = (log_k_CH4_ip1 - log_k_CH4_i) / (band(i+1) - band(i));
            k3_slope_log = (log_k_CO2_ip1 - log_k_CO2_i) / (band(i+1) - band(i));
            x_cross = band(i) + (log_k_CH4_i - log_k_CO2_i) / (k3_slope_log - k2_slope_log);
            log_k_cross = log_k_CH4_i + k2_slope_log * (x_cross - band(i));
        end
        
        % 将交叉点的对数值还原为普通值
        k_cross = 10^log_k_cross;
        
        % 绘制交点前后的填充区域
        % 前半部分填充
        x_former = [band(i), x_cross, x_cross, band(i)];
        y_former = [epsilon, epsilon, k_cross, max_values(i)];
        fill(x_former, y_former, colors{max_idx(i)}, 'FaceAlpha', FaceAlpha, 'EdgeColor', 'none');
        
        x_latter = [x_cross, band(i + 1), band(i + 1), x_cross];
        y_latter = [epsilon, epsilon, max_values(i + 1), k_cross];
        % 后半部分填充
        fill(x_latter, y_latter, colors{max_idx(i+1)}, 'FaceAlpha', FaceAlpha, 'EdgeColor', 'none');
    else
        % 没有交叉的情况，正常填充
        y_fill = [epsilon, epsilon, max_values(i+1), max_values(i)];
        fill(x_fill, y_fill, colors{max_idx(i)}, 'FaceAlpha', FaceAlpha, 'EdgeColor', 'none');
    end
end

% 再次绘制折线
plot(band, k_H2O, '-o', 'MarkerSize', 2, 'DisplayName', 'H2O', 'linewidth', linewidth, 'Color', colors{1});
plot(band, k_CH4, '-o', 'MarkerSize', 2, 'DisplayName', 'CH4', 'linewidth', linewidth, 'Color', colors{2});
plot(band, k_CO2, '-o', 'MarkerSize', 2, 'DisplayName', 'CO2', 'linewidth', linewidth, 'Color', colors{3});
 
% 绘制竖线
stem(selected_band, k_CO2(selected_band_idx), 'fill', 'MarkerSize', 3, 'Color', colors{4}, 'linewidth', linewidth);


%
legend('H2O', 'CH4', 'CO2', 'location', 'northwest', 'Orientation', 'horizon');
pos = axis;
xlabel('(nm)','position',[pos(2)+60 pos(3)]);
ylabel('Normalized Coefficient');

hold off;
%% 打印图像
% print('select_band.png','-dpng','-r300')