load('data/H2O_k/H2O_k_v3.mat')
load('radiance_76M_H2O.mat')
x = k_GF5(:,1);
y = k_GF5(:,5);
figure('Position', [0 250 1000 250]);
hold on
%% 颜色定义
color1 = [166, 186, 204]/256; 
color2 = [209, 255, 233]/256;
colora = [82, 111, 132]/256;
%% 1轴图像
yyaxis left
radiance = radiance_76M_H2O;
x2 = radiance{1}(1:end-1,1);
x2 = 1e7./x2;
% 生成渐变矩阵
newcolors = zeros(10, 3);  % 初始化矩阵
for i = 1:3
    newcolors(:, i) = linspace(color1(i), color2(i), 10);
end
y2 = zeros(size(radiance{1}, 1) - 1, 10);
sigma = 5; % 高斯核的标准差
for i = 1:10
    y2(:,i) = radiance{i}(1:end-1,2);
    y2(:,i) = gaussianFilter1D(y2(:,i), sigma);
end
% 逐差用于area函数的正确显示
z2 = y2;
for i = 1: 10 - 1
    z2(:, i + 1) = -y2(:, i + 1) + y2(:, i);
end
area(x2, z2, 'EdgeColor', [166,166,182]/256, 'FaceAlpha', 0.5)
colororder(newcolors)
ax = gca;
% 设置坐标轴颜色
ax.YColor = 'k';  % 设置Y轴颜色
ylabel('radiance(mW/(m^2 sr cm^{-1}))');
%% 2轴图像
yyaxis right
[y_s, i_s] = sort(abs(y), 'descend');
num = 40;
y_1 = y(i_s(1:num));
x_1 = x(i_s(1:num));
y_2 = y(i_s(num+1:end));
x_2 = x(i_s(num+1:end));
plot(x, y, '-o', 'MarkerSize',2, 'linewidth',1.5, 'color', colora);
xticks(linspace(1000, 2500, 16));  % 设置x轴刻度
xlim([1000 2500])
grid on;
pos = axis;
xlabel('(nm)','position',[pos(2)+60 pos(3)]);
ylabel('k(mW/(cm^2 sr cm^{-1})/ppm)');
ax = gca;
% 设置坐标轴颜色
ax.YColor = 'k';  % 设置Y轴颜色
%% 图廓整饰
box on;
hold off;
%% 打印图像
% print('k_H2O.png','-dpng','-r300')