%% 加载路径
fun_path = genpath('functions'); addpath(fun_path)
%%
load('data/CH4_k/CH4_k_v3.mat')
load('radiance_76M_CH4.mat')
x = k_GF5A(:,1);
y = k_GF5A(:,3);
figure('Position', [0 500 1000 250]);
figure('Position', [1000 250 440 250]);
figure('Position', [1000 0 440 250]);
hold on
%% 颜色定义
color1 = [158, 148, 182]/255; 
color2 = [250, 170, 137]/255;
colora = [62, 53, 64]/255;
%% 1轴图像
yyaxis left
radiance = radiance_76M_CH4; % mW/m2 sr cm-1
wavenum = radiance{1}(1:end-1, 1); % 波数 cm-1
x2 = 1e7 ./ wavenum; % nm
% 生成渐变矩阵
newcolors = zeros(10, 3);  % 初始化矩阵
for i = 1:3
    newcolors(:, i) = linspace(color1(i), color2(i), 10);
end
y2 = zeros(size(radiance{1}, 1) - 1, 10);
sigma = 5; % 高斯核的标准差
for i = 1:10
    y2(:,i) = radiance{i}(1:end-1, 2); % mW/m2 sr cm-1
    y2(:,i) = gaussianFilter1D(y2(:,i), sigma);
end
% 逐差用于area函数的正确显示
z2 = y2;
for i = 1: 10 - 1
    z2(:, i + 1) = -y2(:, i + 1) + y2(:, i);
end
area(x2, z2, 'EdgeColor', [182,179,166]/256, 'FaceAlpha', 0.5)
colororder(newcolors)
ax = gca;
% 设置坐标轴颜色
ax.YColor = 'k';  % 设置Y轴颜色
xticks(linspace(1000, 2500, 16));  % 设置x轴刻度
xlim([1000 2500])

% 弱吸收
xticks(linspace(1620, 1680, 7));  % 设置x轴刻度
xlim([1620 1680])
ylim([6.8e-7 7.8e-7])
% 强吸收
xticks(linspace(2220, 2420, 6));  % 设置x轴刻度
xlim([2220 2420])
ylim([1.5e-7 5e-7])
%
ylabel('radiance(W/(cm^2 sr cm^{-1}))');
%% 2轴图像
yyaxis right
[y_s, i_s] = sort(abs(y), 'descend');
num = 40;
y_1 = y(i_s(1:num));
x_1 = x(i_s(1:num));
y_2 = y(i_s(num+1:end));
x_2 = x(i_s(num+1:end));
plot(x, y, '-o', 'MarkerSize',2, 'linewidth',1.5, 'color', colora);
%
% ylim([0 0.1])
grid on; % 添加网格线
pos = axis;
xlabel('(nm)','position',[pos(2)+60 pos(3)]);
ylabel('k(W/(cm^2 sr cm^{-1})/ppm)');
set(gca, 'YColor', 'k');  % 设置Y轴颜色
%% 图廓整饰
box on;
hold off;
%% 打印图像
print('k_CH4_GF5A_H.png','-dpng','-r300')