%% 文件名及路径
Root_Path1 = 'F:\2024.7 美国原始数据'; % 原始数据根目录
Root_Path2 = 'F:\2024.7 美国核查结果'; % 核查结果根目录
%% 读取数据
datafile2 = 'data/Band_CO2_v1.xlsx';
Tabledata = readtable(datafile2, 'VariableNamingRule', 'preserve', 'TreatAsEmpty', '');
fpath_k = 'data/CO2_k/CO2_k_v10.mat'; % 吸收系数查找表路径
fpath_wv = 'data/WaterVaporTable.mat';
load(fpath_wv, 'WaterVaporTable');
% datafile = 'data/美国碳源反演.xlsx'; sheetName = '2025.1';
datafile = 'data/美国电厂GF5.xlsx'; sheetName = '2025.1';
T = readtable(datafile, 'Sheet', sheetName, 'VariableNamingRule', 'preserve');
len = length(T, 1);
%% 循环处理
for i = 1:len
    close all % 清除图窗
    %% 读取当前排放设施的坐标以及时间信息
    Item = GetFacilityData(T, i);

    %% 数据路径
    origin_path = fullfile(Root_Path1, Item.facility, Item.filename);
    process_path = fullfile(Root_Path2, Item.foldername); mymkdir(process_path) % 若不存在就新建文件夹
    result_path = fullfile(process_path, Item.facility); mymkdir(result_path)
    tempdata_path = fullfile(process_path, 'INPUT'); mymkdir(tempdata_path) % 数据缓存路径
    %% 移动文件夹
    cut_folder_src = fullfile(process_path, 'CUT'); % CUT文件夹源路径
    cut_folder_dst = fullfile(result_path, 'CUT'); % CUT文件夹目标路径

    % 检查并移动'CUT'文件夹
    if exist(cut_folder_src, 'dir')
        movefile(cut_folder_src, cut_folder_dst);
    else
        warning('源文件夹不存在: %s', cut_folder_src);
    end
end