function visualizeTIFF(TIFF_3)
    % 创建图形界面
    FIG = figure('Position', [10 180 700 700]);
    
    % 原始数据
    subplot(2,2,1);
    ShowImage(TIFF_3.cutrgb, TIFF_3.cutdata, 'origin data');

    % 阈值数据
    subplot(2,2,2);
    ShowImage(TIFF_3.cutrgb, TIFF_3.threshdata, 'thresh data');
    
    % 掩码数据
    subplot(2,2,3);
    ShowImage(TIFF_3.cutrgb, TIFF_3.maskdata, 'mask data');
    
    % 羽流数据
    subplot(2,2,4);
    ShowImage(TIFF_3.cutrgb, TIFF_3.finaldatashow, 'plume data');
    hold on;
    
    % 绘制射线
    x1 = TIFF_3.segment_start(1);
    y1 = TIFF_3.segment_start(2);
    x2 = TIFF_3.segment_end(1);
    y2 = TIFF_3.segment_end(2);
    [rows, cols] = size(TIFF_3.cutdata);
    
    % 检查线段是否与边框相交
    [isIntersect, intersectionPoints] = checkIntersection(x1, y1, x2, y2, cols, rows);
    % 显示结果
    if isIntersect % 线段与边框相交
        x3 = intersectionPoints(1);
        y3 = intersectionPoints(2);
    else % 线段与边框不相交
        x3 = x2;
        y3 = y2;
    end
        plot([x1, x3], [y1, y3], 'r--', 'LineWidth', 0.5);

    % 画出线段起点
    plot(TIFF_3.x1, TIFF_3.y1, 'ro', 'MarkerSize', 5);
    % 画出线段终点
    plot(TIFF_3.x2, TIFF_3.y2, 'ro', 'MarkerSize', 5);
    % 画出设施点
    plot(TIFF_3.colIndex, TIFF_3.rowIndex, 'wo', 'MarkerSize', 5);
    
    % textProperties = {'FontName', 'Times New Roman', 'FontSize', 10, 'FontWeight', 'bold', 'Color', 'yellow'}; % 文字属性
    % text('Position', [20, 40], 'String', ['EPA-CAMPD: ', num2str(EPA_data(i), '%.2f'), 'ton/h'], textProperties{:});
    % text('Position', [20, 20], 'String', [Facility.Satellite, '-AHSI: ', num2str(Emission(i,1), '%.2f'), '±', num2str(Emission(i,3),'%.2f'), 'ton/h'], textProperties{:});
end

function [isIntersect, intersectionPoints] = checkIntersection(x1, y1, x2, y2, cols, rows)
    % 定义边框的四条边
    borders = [0, 0, cols, 0;        
               cols, 0, cols, rows; 
               cols, rows, 0, rows; 
               0, rows, 0, 0];     
    
    % 初始化交点信息
    isIntersect = false;
    intersectionPoints = [];
    
    % 逐条检查线段与边框的四条边是否相交
    for i = 1:4
        [xi, yi, intersect] = segmentIntersect(x1, y1, x2, y2, ...
                                               borders(i, 1), borders(i, 2), ...
                                               borders(i, 3), borders(i, 4));
        if intersect
            isIntersect = true;
            intersectionPoints = [intersectionPoints; xi, yi];
        end
    end
end

function [xi, yi, isIntersect] = segmentIntersect(x1, y1, x2, y2, x3, y3, x4, y4)
    % 使用向量叉积法计算两条线段是否相交并给出交点
    % 图像坐标系：x 向右, y 向下
    denominator = (x2 - x1) * (y4 - y3) - (y2 - y1) * (x4 - x3);
    if denominator == 0
        xi = NaN; yi = NaN; isIntersect = false;
        return; % 平行或共线
    end
    
    % 计算交点
    xi = ((x2 * y1 - y2 * x1) * (x4 - x3) - (x2 - x1) * (x4 * y3 - y4 * x3)) / denominator;
    yi = ((x2 * y1 - y2 * x1) * (y4 - y3) - (y2 - y1) * (x4 * y3 - y4 * x3)) / denominator;
    epsilon = 1e-5;
    % 检查交点是否在线段范围内
    isIntersect = (xi > min(x1, x2)-epsilon && xi <= max(x1, x2)+epsilon && ...
                   yi > min(y1, y2)-epsilon && yi <= max(y1, y2)+epsilon && ...
                   xi > min(x3, x4)-epsilon && xi <= max(x3, x4)+epsilon && ...
                   yi > min(y3, y4)-epsilon && yi <= max(y3, y4)+epsilon);
end

