function pixel_ll = RpcBackwardCompute(RPC, lsh, value_bijin)

line = lsh(1);
sample = lsh(2);
height = lsh(3);

% nargin 表示参数个数
if nargin==3

elseif nargin==2
    value_bijin=[RPC.latOffset, RPC.longOffset];
else
    error('输入数据错误！');
end

%% 多项式计算
syms lat lon
vars = [lat lon];

% 计算常用项
L = (lon - RPC.longOffset) / RPC.longScale;
P = (lat - RPC.latOffset) / RPC.latScale;
H = (height - RPC.heightOffset) / RPC.heightScale;

% 定义特征向量
coef = [1,L,P,H,L*P,L*H,P*H,L*L,P*P,H*H,P*L*H,L*L*L,L*P*P,L*H*H,L*L*P,P*P*P,P*H*H,L*L*H,P*P*H,H*H*H];

% 计算方程
equns = [line == (RPC.num_l_coef * coef') / (RPC.den_l_coef * coef') * RPC.linescale + RPC.lineOffset, ...
    sample == (RPC.num_s_coef * coef') / (RPC.den_s_coef * coef') * RPC.samplescale + RPC.sampOffset];
[lat, lon] = vpasolve(equns, vars, value_bijin);
pixel_ll = double([lat, lon]);
end


