function pixel_position = RS_read_rpb(fname, llh)
%% 代码说明
% https://blog.csdn.net/weixin_43955546/article/details/123702554
% author: lizijia
% 2022-4-28
% 读取遥感RPB文件，输入经纬度，获取经纬度值对象的像素坐标。
%fname： 输入RPB文件名称
%llh： [lat,lon,height]
%pixel_position: [line, sample]
%%
lat=llh(1);
lon=llh(2);
h=llh(3);

% 1 读取RPB文件内容
fid1=fopen(fname,'r');

read_one_line = fgetl(fid1);
read_one_line = fgetl(fid1);
read_one_line = fgetl(fid1);
read_one_line = fgetl(fid1);
read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',});
errBias=char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',});
errRand=char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',});
lineOffset =char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',});
sampOffset=char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',});
latOffset =char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
longOffset=char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
heightOffset=char(temp(2));


read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
linescale=char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
samplescale=char(temp(2));



read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
latScale  =char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
longScale =char(temp(2));

read_one_line = fgetl(fid1);
temp=strsplit(read_one_line,{';','=',')',','});
heightScale =char(temp(2));

read_one_line = fgetl(fid1);
for i=1:20
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    lineNumCoef{i}=temp(1);
end
read_one_line = fgetl(fid1);
for i=1:20
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    lineDenCoef{i}=temp(1);
end
read_one_line = fgetl(fid1);
for i=1:20
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    sampNumCoef{i}=temp(1);
end
read_one_line = fgetl(fid1);
for i=1:20
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    sampDenCoef{i}=temp(1);
end
fclose(fid1);

P=(lat-str2num(latOffset))/str2num(latScale);
L=(lon-str2num(longOffset))/str2num(longScale);
H=(h-str2num(heightOffset))/str2num(heightScale);
% X,Y的归一化公式
%X=(sample-str2num(sampOffset))/str2num(samplescale);
%Y=(line-str2num(lineOffset))/str2num(linescale);

num_l_coef=[];
for i=1:20
    num_l_coef=[num_l_coef,str2num(char(lineNumCoef{i}))]  ;
end
den_l_coef=[];
for i=1:20
    den_l_coef=[den_l_coef,str2num(char(lineDenCoef{i}))]  ;
end

num_s_coef=[];
for i=1:20
    num_s_coef=[num_s_coef,str2num(char(sampNumCoef{i}))]  ;
end
den_s_coef=[];
for i=1:20
    den_s_coef=[den_s_coef,str2num(char(sampDenCoef{i}))] ;
end


xishu=[1,L,P,H,L*P,L*H,P*H,L*L,P*P,H*H,P*L*H,L*L*L,L*P*P,L*H*H,L*L*P,P*P*P,P*H*H,L*L*H,P*P*H,H*H*H];


line=((num_l_coef*xishu')/(den_l_coef*xishu'))*str2num(char(linescale))+str2num(char(lineOffset));
sample=(num_s_coef*xishu')/(den_s_coef*xishu')*str2num(char(samplescale))+str2num(char(sampOffset));

pixel_position=[line,sample];
end

