function pixel_position=RS_forward_compute_rpc(f_in_name,llh)
   %author  lizijia
   %2022-4-28
   % 读取遥感RPB文件，输入经纬度，获取经纬度值对象的像素坐标。
   
   %f_in_name： 输入RPB,RPC文件名称
   %llh： [lat,lon,height]
   %pixel_position: [line,sample]
   format longE  %因为RPC的系数都是小数点后15位，所以设置数据格式 format为longE

    lat=llh(1);
    lon=llh(2);
    h=llh(3);
    
    % 1 读取RPB文件内容
    fid1=fopen(f_in_name,'r');
    
    read_one_line = fgetl(fid1);
    read_one_line = fgetl(fid1);
    read_one_line = fgetl(fid1);
    read_one_line = fgetl(fid1);
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',});
    errBias=char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',});
    errRand=char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',});
    lineOffset =char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',});
    sampOffset=char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',});
    latOffset =char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    longOffset=char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    heightOffset=char(temp(2));
    
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    linescale=char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    samplescale=char(temp(2));
    
    
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    latScale  =char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    longScale =char(temp(2));
    
    read_one_line = fgetl(fid1);
    temp=strsplit(read_one_line,{';','=',')',','});
    heightScale =char(temp(2));
    
    read_one_line = fgetl(fid1); 
    for i=1:20
         read_one_line = fgetl(fid1);
        temp=strsplit(read_one_line,{';','=',')',','});
        lineNumCoef{i}=temp(1);
    end
    read_one_line = fgetl(fid1); 
    for i=1:20
         read_one_line = fgetl(fid1);
        temp=strsplit(read_one_line,{';','=',')',','});
        lineDenCoef{i}=temp(1);
    end
     read_one_line = fgetl(fid1); 
    for i=1:20
         read_one_line = fgetl(fid1);
        temp=strsplit(read_one_line,{';','=',')',','});
        sampNumCoef{i}=temp(1);
    end
     read_one_line = fgetl(fid1); 
    for i=1:20
         read_one_line = fgetl(fid1);
        temp=strsplit(read_one_line,{';','=',')',','});
        sampDenCoef{i}=temp(1);
    end
    fclose(fid1);

P=(lat-str2double(latOffset))/str2double(latScale);
L=(lon-str2double(longOffset))/str2double(longScale);
H=(h-str2double(heightOffset))/str2double(heightScale);
% X,Y的归一化公式
%X=(sample-str2num(sampOffset))/str2num(samplescale);
%Y=(line-str2num(lineOffset))/str2num(linescale);



num_l_coef=[];
for i=1:20
  num_l_coef=[num_l_coef,str2double(char(lineNumCoef{i}))]  ;
end
den_l_coef=[];
for i=1:20
  den_l_coef=[den_l_coef,str2double(char(lineDenCoef{i}))]  ;
end

num_s_coef=[];
for i=1:20
  num_s_coef=[num_s_coef,str2double(char(sampNumCoef{i}))]  ;
end
den_s_coef=[];
for i=1:20
  den_s_coef=[den_s_coef,str2double(char(sampDenCoef{i}))] ; 
end


xishu=[1,L,P,H,L*P,L*H,P*H,L*L,P*P,H*H,P*L*H,L*L*L,L*P*P,L*H*H,L*L*P,P*P*P,P*H*H,L*L*H,P*P*H,H*H*H];


line=((num_l_coef*xishu')/(den_l_coef*xishu'))*str2double(char(linescale))+str2double(char(lineOffset));
sample=(num_s_coef*xishu')/(den_s_coef*xishu')*str2double(char(samplescale))+str2double(char(sampOffset));

pixel_position=[line,sample];
end
