function error_columns = preprocess_image(image_data)
    % 逐列统计像素平均值
    column_means = mean(image_data);
    
    % 根据像素平均值向量，计算去除5%极值后的标准差
    sorted_means = sort(column_means);
    num_pixels = size(image_data, 2);
    valid_means = sorted_means(ceil(0.05*num_pixels):floor(0.95*num_pixels));
    std_dev = std(valid_means);
    
    % 初始化需要修正的列号
    error_columns = [];
    
    % 逐列判断是否有问题
    num_columns = size(image_data, 2);
    for i = 5:num_columns-5
        window_indices = i-4:i+5;
        window_data = column_means(window_indices);
        sorted_window_data = sort(window_data);
        window_mean = mean(sorted_window_data(4:6));
        column_mean = column_means(i);
        column_range = window_mean + 1.5 * [-std_dev, std_dev];
        if column_mean < column_range(1) || column_mean > column_range(2)
            error_columns = [error_columns, i];
        end
    end
    
    % 绘制条形图并标记需要修正的列为红色
%     bar(column_means);
%     hold on;
%     for i = 1:length(error_columns)
%         bar(error_columns(i), column_means(error_columns(i)), 'r');
%     end
%     hold off;
end
