function corrected_image_data = interpolate_errors(image_data, error_columns)
    % 拷贝原始数据
    corrected_image_data = image_data;
    
    % 对每一个有问题的波段进行修复
    for i = 1:length(error_columns)
        % 获取当前有问题的波段列号
        error_column = error_columns(i);
        
        % 如果是中间的有问题波段
        if error_column > 1 && error_column < size(image_data, 2)
            % 向左找一个非问题波段
            left_valid_column = find(~ismember(1:error_column, error_columns), 1, 'last');
            % 向右找一个非问题波段
            right_valid_column = find(~ismember(error_column:size(image_data, 2), error_columns), 1, 'first') + error_column - 1;
            % 取左右波段的均值作为修复值
            corrected_image_data(:, error_column) = (corrected_image_data(:, left_valid_column) + corrected_image_data(:, right_valid_column)) / 2;
        end
    end
end
