function Item = prepare_basis(Root_Path1, Root_Path2, Item)
    %% 初始化结构体用于存储路径
    Item.path = struct();
    
    %% 数据路径
    Item.path.origin_path = fullfile(Root_Path1, Item.region, Item.filename); % 原始数据
    % 判断路径是否存在
    if exist(Item.path.origin_path, 'dir') % 检查是否存在该文件夹
        % disp('The specified path is a directory and it exists.');
    else
        error('The specified path does not exist. 指定路径不存在。\n 请检查路径是否存在：%s\n', Item.path.origin_path);
    end

    Item.path.process_path = fullfile(Root_Path2, Item.foldername);
    mymkdir(Item.path.process_path); % 若不存在就新建文件夹
    
    Item.path.result_path = fullfile(Item.path.process_path, Item.facility);
    mymkdir(Item.path.result_path);
    
    Item.path.tempdata_path = fullfile(Item.path.process_path, 'INPUT');
    mymkdir(Item.path.tempdata_path); % 数据缓存路径


    %% 读取文件名
    Item.flist = ReadFiles(Item.path.origin_path); % 读取数据
    Item.xmlStruct = ReadXmlData(Item.flist.xml); % 读取xml文件
    
    %% 设置输出文件名
    Item.tiffname.RMF = fullfile(Item.path.process_path, [Item.gas, '_', Item.foldername, '_', Item.algorithm, '.tif']);
    Item.tiffname.RGB = fullfile(Item.path.process_path, 'RGB.tif');
    Item.tiffname.RMF_cor = fullfile(Item.path.process_path, [Item.gas, '_', Item.foldername, '_', Item.algorithm, '_cor.tif']);
    Item.tiffname.RGB_cor = fullfile(Item.path.process_path, 'RGB_cor.tif');

end