function plotbar(result, res_error, satellite)
FontSize = 14;
%% 初始化标注变量
GF5_labeled = false;
GF5A_labeled = false;
GF5B_labeled = false;
ZY1E_labeled = false;
ZY1F_labeled = false;
%% 根据第一列数据值从大到小排序
[sortedData, sortIdx] = sort(result, 'descend');
sortedErrors = res_error(sortIdx);
sortedclass = string(satellite(sortIdx,:));

% 提取数据和误差
data = sortedData;
errors = sortedErrors;

hold on;
numBars = size(data, 1);
colors = {[220,10,80]/255;
    [192,50,26]/255;
    [221,124,79]/255;
    [84,123,180]/255;
    [108,97,175]/255}; % 不同类别对应的颜色

for i = 1:numBars
    x = i; % 每个柱子的x坐标
    if(strcmp(sortedclass(i),'GF5')) % GF系列
        if(~GF5_labeled)
            h = bar(x, data(i), 'FaceColor', colors{1}); % 按类别着色
            GF5_labeled = true;
        else
            h = bar(x, data(i), 'FaceColor', colors{1}); % 按类别着色
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    elseif(strcmp(sortedclass(i),'GF5A')) % GF系列
        if(~GF5A_labeled)
            h = bar(x, data(i), 'FaceColor', colors{2}); % 按类别着色
            GF5A_labeled = true;
        else
            h = bar(x, data(i), 'FaceColor', colors{2}); % 按类别着色
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    elseif(strcmp(sortedclass(i),'GF5B')) % GF系列
        if(~GF5B_labeled)
            h = bar(x, data(i), 'FaceColor', colors{3}); % 按类别着色
            GF5B_labeled = true;
        else
            h = bar(x, data(i), 'FaceColor', colors{3}); % 按类别着色
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    elseif(strcmp(sortedclass(i),'ZY1E')) % 资源系列
        if(~ZY1E_labeled)
            h = bar(x, data(i), 'FaceColor', colors{4}); % 按类别着色
            ZY1E_labeled = true;
        else
            h = bar(x, data(i), 'FaceColor', colors{4}); % 按类别着色
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    elseif(strcmp(sortedclass(i),'ZY1F')) % 资源系列
        if(~ZY1F_labeled)
            h = bar(x, data(i), 'FaceColor', colors{5}); % 按类别着色
            ZY1F_labeled = true;
        else
            h = bar(x, data(i), 'FaceColor', colors{5}); % 按类别着色
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    else
        fprintf("ERROR TYPE!");
    end
    h = errorbar(x, data(i), errors(i), 'k', 'LineWidth', 0.5); % 添加误差线，黑色
    set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');

end
hold off;
box on;
grid on;
% 添加数据标签
xticks(5:5:numBars); % 设置x轴刻度，每隔5个点设置一个
xticklabels(5:5:length(result)); % 设置刻度标签
% ylabel('排放强度 ');
ylim([0 3500])
legend({'ZY1F', 'GF5A', 'ZY1E', 'GF5B', 'GF5'})
legend({'GF5A', 'ZY1E', 'ZY1F', 'GF5B', 'GF5'})
legend({'GF5A', 'ZY1F', 'GF5B', 'ZY1E', 'GF5'})
% 添加标题
% xtitle = '$$\mathrm{EPA\ emission\ rate\ (ton\ CO_2\ per\ hour)}$$';
ytitle = 'AHSI emission rate (t·h^{-1})';
% xlabel(xtitle, 'Interpreter', 'latex', 'FontName','Times New Roman','FontWeight','bold','FontSize',12);
ylabel(ytitle, 'Interpreter', 'tex', 'FontName','Arial','FontWeight','bold','FontSize',FontSize);
set(gca,'FontName','Arial','FontSize',FontSize,'FontWeight','bold','LineWidth',1);
