function plotRGBMeanHistogram(pan_img, stat)
% PLOTRGBMEANHISTOGRAM 绘制RGB均值直方图及两倍中误差线
%
% 输入:
%   pan_img - 单波段图像数据 (m x n)
%   stat - 包含统计信息的结构体，应包含字段 midline, maxline 和 minline

% 检查输入参数是否正确
if ~isstruct(stat) || ~all(isfield(stat, {'midline', 'maxline', 'minline'}))
    error('第二个输入必须是包含midline, maxline和minline字段的结构体');
end

% 定义自定义颜色
custom_midline_color = [0.1 0.1 0.1]; % 自定义中线颜色
custom_maxline_color = [0.4 0.4 0.4]; % 自定义上限线颜色
custom_minline_color = [0.4 0.4 0.4]; % 自定义下限线颜色

hold on;

in_range_color = [0.466 0.674 0.188];                  % 界内深绿
out_range_color = [0.850 0.325 0.098];                 % 界外深红

% 计算所有数据的直方图，获取bin的位置
[counts, edges] = histcounts(pan_img, 'Normalization', 'pdf', 'BinWidth', 5);

% 统计界内和界外的数据点
in_range_counts = counts .* (edges(1:end-1) >= stat.minline & edges(1:end-1) <= stat.maxline);
out_range_counts = counts .* (~ismember(edges(1:end-1), edges(find(in_range_counts > 0))));

% 绘制界内直方图
bar(edges(1:end-1), in_range_counts, 'FaceColor', in_range_color, 'EdgeColor', 'none');
hold on;

% 绘制界外直方图
bar(edges(1:end-1), out_range_counts, 'FaceColor', out_range_color, 'EdgeColor', 'none');

% 设置字体大小和字体名称
set(gca, 'FontName', 'Arial', 'FontSize', 14);

% 获取当前坐标轴的Y限
ylims = get(gca, 'YLim');
xlims = get(gca, 'XLim');

% 设置文本
str = sprintf("Outlier Rate: %.2f%%", 100 * stat.ratio_outlier);
text(0.4*xlims(2), 0.9 * ylims(2), str, 'FontSize', 14, 'FontName', 'Arial');

% 绘制中线和上下限线
plot([stat.midline stat.midline], ylims, 'Color', custom_midline_color, 'LineStyle', '-', 'LineWidth', 1.5);
plot([stat.maxline stat.maxline], ylims, 'Color', custom_maxline_color, 'LineStyle', '--', 'LineWidth', 1.5);
plot([stat.minline stat.minline], ylims, 'Color', custom_minline_color, 'LineStyle', '--', 'LineWidth', 1.5);

% 添加图例
% legend({'', ['mean: ' num2str(stat.midline, "%.1f")], ...
%     ['max: ' num2str(stat.maxline, "%.1f")], ['min: ' num2str(stat.minline, "%.1f")]}, ...
%     'Location', 'northeast');

% 设置图形标题和标签
% title('Histogram of Pan image');
% xlabel('DN value');
% ylabel('Frequency');



hold off;
box on;

end