function class_res = perform_kmeans_clustering(rgb, swir_sel, K)
tic;
% 检查尺寸是否一致
[rgb, swir_sel] = CheckSize(rgb, swir_sel);
% 获取数据尺寸
[row, col, wav] = size(swir_sel);
% 构建 kmeans 输入数据
kmeans_input = cat(3, rgb, swir_sel(:, :, [1, end]));
% 将数据展平
k_means_input = reshape(kmeans_input, row * col, []);
% 标准化数据
k_means_input = zscore(k_means_input);
% 执行 K-means 聚类
k_means_output = kmeans(k_means_input, K, 'MaxIter', 100, 'Start', 'plus');
% 将结果重新整形为原始图像尺寸
class_res = reshape(k_means_output, [row, col]);
toc;
end
