function mu = mytrimmean(L, a1, a2)
    % 检查输入参数是否有效
    if a1 < 0 || a2 < 0 || a1 + a2 >= 100
        error('a1 and a2 must be non-negative and their sum must be less than 1.');
    end
    nanindex = sum(isnan(L),2) > 0;
    L1 = L;
    L1(nanindex, :) = [];
    % 对 L 进行升序排序
    [~, sort_idx] = sort(mean(L1,2));

    % 计算需要修剪的元素数量
    num_elements = length(L1);
    num_trim_a1 = floor(num_elements * a1 / 100); % 修剪最小部分的数据数量
    num_trim_a2 = floor(num_elements * a2 / 100); % 修剪最大部分的数据数量

    % 去除两端的数据
    L_trimmed = L1(sort_idx(num_trim_a1+1 : end-num_trim_a2),:);

    % 计算修剪后的平均值
    mu = mean(L_trimmed);
end
