function mergeXLSXFiles()
    % 获取当前目录
    currentDir = pwd;
    
    % 查找当前目录下所有的xlsx文件
    xlsxFiles = dir(fullfile(currentDir, '*.xlsx'));
    
    % 初始化一个表格数组来存储每个文件的数据
    dataTables = {};
    
    % 读取每个文件的数据并存储在dataTables中
    for k = 1:length(xlsxFiles)
        fileName = fullfile(xlsxFiles(k).folder, xlsxFiles(k).name);
        % 假设数据从第一行开始，包括标题行
        data = readtable(fileName, 'ReadVariableNames', true, 'ReadRowNames', false, 'VariableNamingRule', 'preserve');
        dataTables{k} = data;
    end
    
    % 如果没有找到任何文件，给出提示并退出
    if isempty(dataTables)
        disp('没有找到任何xlsx文件');
        return;
    end
    
    % 合并所有文件的数据
    % 假设所有文件都有相同的标题行，所以只保留第一个文件的标题行
    mergedTable = dataTables{1}; % 初始化合并表为第一个表格
    for k = 2:length(dataTables)
        mergedTable = [mergedTable; dataTables{k}]; % 使用分号进行垂直连接
    end
    
    % 写入新的Excel文件
    outputFileName = fullfile(currentDir, ['MergedData_', datestr(now, 'yyyymmdd_HHMMSS'), '.xlsx']);
    writetable(mergedTable, outputFileName);
    
    disp(['合并完成，结果已保存至: ', outputFileName]);
end