function manualCorrection(Item, force)
%% 手动校准0
if(Item.correction) % 如果需要手动对齐校正
    if(force || ~exist(Item.tiffname.RGB_cor, 'file') || ~exist(Item.tiffname.RMF_cor, 'file')) % 存在文件，则直接加载
        [tiff_RGB, tiff_RGB_R] = readgeoraster(Item.tiffname.RGB);
        [tiff_RMF, ~] = readgeoraster(Item.tiffname.RMF);
        fig_set.subfigsize = 800;
        fig_set.marginsize = 50;
        fig_set.width = 2 * fig_set.subfigsize + 3 * fig_set.marginsize;
        fig_set.height = fig_set.subfigsize + 2 * fig_set.marginsize;
        figure('Position', [40 40 fig_set.width fig_set.height]);
        ax1 = axes('Position', [fig_set.marginsize/fig_set.width fig_set.marginsize/fig_set.height fig_set.subfigsize/fig_set.width fig_set.subfigsize/fig_set.height]); % [left, bottom, width, height]
        image(tiff_RGB);
        hold(ax1, 'on'); axis(ax1, 'square');
        ax2 = axes('Position', [(fig_set.marginsize + fig_set.subfigsize)/fig_set.width fig_set.marginsize/fig_set.height fig_set.subfigsize/fig_set.width fig_set.subfigsize/fig_set.height]); % [left, bottom, width, height]
        key = 'Wang20020818';
        total_range = [tiff_RGB_R.LatitudeLimits, tiff_RGB_R.LongitudeLimits];
        DEM = readhgt(total_range, 'srtm1', 'login', 'whu_why2021', key, 'interp', 'outdir', 'E:/SRTM_data');
        demoptions = {'latlon','lake','nodecim'};
        dem(DEM.lon,DEM.lat,DEM.z,demoptions{:});
        hold(ax2, 'on'); axis(ax2, 'square');
        % 初始化用于存储点的数组
        n = 4; % 总共提取4次
        left_points = zeros(n, 2); % 存储左边的点坐标
        right_points = zeros(n, 2); % 存储右边的点坐标

        % 开始获取用户输入的点
        for j = 1:n
            disp(['Select point ' num2str(j) ' on the left image.']);
            [x1, y1] = ginput(1); % 获取左侧图像上的点
            left_points(j, :) = [x1, y1]; % 存储点坐标
            plot(ax1, x1, y1, 'g+', 'MarkerSize', 10, 'LineWidth', 2); % 用绿色十字标记点

            disp(['Select point ' num2str(j) ' on the right image.']);
            [x2, y2] = ginput(1); % 获取右侧图像上的点
            right_points(j, :) = [x2, y2]; % 存储点坐标
            plot(ax2, x2, y2, 'r+', 'MarkerSize', 10, 'LineWidth', 2); % 用红色十字标记点
        end
        [lat, lon] = intrinsicToGeographic(tiff_RGB_R, left_points(:,1), left_points(:,2));
        lat_diff = mean(right_points(:, 2) - lat);
        lon_diff = mean(right_points(:, 1) - lon);
        % 一阶偏移校正
        tiff_R_cor = tiff_RGB_R;
        tiff_R_cor.LatitudeLimits = tiff_RGB_R.LatitudeLimits + lat_diff;
        tiff_R_cor.LongitudeLimits = tiff_RGB_R.LongitudeLimits + lon_diff;
        % 导出TIFF文件
        GeoKeyDirectoryTag = struct('GTModelTypeGeoKey', 2, 'GTRasterTypeGeoKey', 1); % 创建 GeoTIFF 标签
        geotiffwrite(Item.tiffname.RGB_cor, tiff_RGB, tiff_R_cor, 'CoordRefSysCode', 4326,'GeoKeyDirectoryTag', GeoKeyDirectoryTag);
        geotiffwrite(Item.tiffname.RMF_cor, tiff_RMF, tiff_R_cor, 'CoordRefSysCode', 4326,'GeoKeyDirectoryTag', GeoKeyDirectoryTag);
    end
end
end