function [k_unit, PARM_INPUT] = load_gas_absorption_coef(version)
fpath_k = ['data/CO2_k/CO2_k_v', version, '.mat']; % 吸收系数查找表路径
variableNames = {'k_GF5', 'k_GF5A', 'k_GF5B', 'k_ZY1E', 'k_ZY1F', 'PARM_INPUT'}; % 定义要查找的变量名

% 检查.mat文件是否包含所有指定的变量名
allVariablesExist = all(ismember(variableNames, fieldnames(matfile(fpath_k))));

if allVariablesExist
    disp('所有指定的变量都包含在.mat文件中，正在加载...');
    % 动态构建加载命令，因为load不接受cell数组作为参数来选择性加载多个变量
    load(fpath_k, variableNames{:}); % 使用 {:} 来展开元胞数组为逗号分隔的列表
else
    disp('并非所有指定的变量都包含在.mat文件中，无法加载指定变量。');
end
k_unit.('GF5') = k_GF5; k_unit.('GF5A') = k_GF5A; k_unit.('GF5B') = k_GF5B; k_unit.('ZY1E') = k_ZY1E; k_unit.('ZY1F') = k_ZY1F;
end