function filtered_image = gaussianLowPassFilter(image, cutoffFrequency)
    % 将图像转换为灰度并获取尺寸
    [rows, cols] = size(image);
    
    % 扩展图像尺寸到 2 的幂次，以便进行频域变换
    padded_rows = 2^nextpow2(rows);
    padded_cols = 2^nextpow2(cols);
    padded_image = padarray(image, [padded_rows - rows, padded_cols - cols], 'post');
    
    % 进行傅里叶变换并将零频移到中心
    image_fft = fftshift(fft2(padded_image));
    
    %% 绘制图像
    %     mag_fft = abs(image_fft); % 幅度谱
    %     imagesc(mag_fft)
    %%

    % 创建高斯低通滤波器
    [X, Y] = meshgrid(-padded_cols/2 : padded_cols/2 - 1, -padded_rows/2 : padded_rows/2 - 1);
    gaussian_filter = exp(-(X.^2 + Y.^2) / (2 * cutoffFrequency^2));
    
    % 应用滤波器
    filtered_fft = image_fft .* gaussian_filter;
    
    % 逆傅里叶变换回到空间域
    filtered_image = real(ifft2(ifftshift(filtered_fft)));
    
    % 去除填充部分
    filtered_image = filtered_image(1:rows, 1:cols);
end
