function filtered_data = gaussianFilter1D(data, sigma)
% 输入:
% data - 一维数据数组
% sigma - 高斯核的标准差，控制滤波的平滑程度

% 1. 计算高斯核的大小（通常选择奇数，并覆盖大部分高斯分布）
% 这里我们简单地选择核大小为 2*ceil(3*sigma) + 1，这通常足够覆盖大部分高斯分布
kernelSize = 2*ceil(3*sigma) + 1;

% 2. 创建高斯核
% 初始化高斯核数组
gaussianKernel = zeros(1, kernelSize);
% 计算高斯核的索引（相对于中心）
indices = -(kernelSize-1)/2:(kernelSize-1)/2;
% 计算高斯核的权重
gaussianKernel = exp(-(indices.^2) / (2*sigma^2)) / (sqrt(2*pi)*sigma);
% 归一化高斯核，确保权重之和为1
gaussianKernel = gaussianKernel / sum(gaussianKernel);

% 3. 应用高斯核进行滤波
% 使用conv函数进行卷积操作，'same'参数确保输出与输入大小相同
filtered_data = conv(data, gaussianKernel, 'same');

end