function stdMap = computeLocalStd(image, windowSize)
    % 输入：
    % - image: 输入图像 (可以是灰度图像或一个通道的彩色图像)
    % - windowSize: 滑动窗口的大小 (例如 200)
    % 输出：
    % - stdMap: 每个点邻域标准差的图像

    % 确保图像为双精度类型（避免计算误差）
    image = double(image);

    % 定义滤波器
    kernel = ones(windowSize) / (windowSize^2);

    % 计算均值
    meanLocal = conv2(image, kernel, 'same');

    % 计算平方均值
    meanSquareLocal = conv2(image.^2, kernel, 'same');

    % 计算标准差
    stdMap = sqrt(meanSquareLocal - meanLocal.^2);
end