function outputImage = color_AHSI(inputImage)
model_name = 'GF5_CTM.mat';

if(~exist(model_name, 'file'))
    % 定义颜色对应关系
    colorMap_AHSI = [
        110, 37, 22;
        30, 31, 33;
        255, 255, 255;
        0, 0, 5;
        0, 82, 47;
        149, 86, 67
        ];

    colorMap_Google = [
        166, 123, 74;
        96, 87, 57;
        254, 231, 202;
        32, 66, 44;
        95, 143, 103;
        111, 99, 61
        ];

    % 创建颜色转换器
    transformer = ColorTransformer(colorMap_AHSI, colorMap_Google);

    % 保存模型
    transformer.saveModel(model_name);
else % 存在模型，直接加载
    transformer = ColorTransformer.loadModel(model_name);     % 加载模型
end

% 转换图像
inputImage = double(inputImage*255);
outputImage = transformer.transformImage(inputImage);
% 显示结果
% imshow(outputImage);
end