function [wind_direction_offset, wind_deviation] = calculateWindPlumeDeviation(TIFF_5, Wind)
% 计算坐标差
delta_x = TIFF_5.segment_start(1) - TIFF_5.segment_end(1);
delta_y = TIFF_5.segment_start(2) - TIFF_5.segment_end(2);
% 使用 atan2 函数计算相对于正东方向的角度 (弧度)
angle_radians = atan2(delta_y, delta_x);
plume_dir = 90 + rad2deg(angle_radians);
if plume_dir < 0
    plume_dir = plume_dir + 360;
end
wind_direction_offset = abs(plume_dir - Wind.direction);
if(wind_direction_offset > 180)
    wind_direction_offset = 360 - wind_direction_offset;
end
fprintf("ERA5风向: %.2f\n", Wind.direction);
fprintf("Plume方向: %.2f\n", plume_dir);
fprintf("羽流方向绝对偏差: %.2f°\n", wind_direction_offset);
wind_deviation =  wind_direction_offset * Wind.speed / 3;

end