function stat = calculateOutlierRate(pan_img)
    % CALCULATEOUTLIERRATE 计算图像中两倍标准差外的像素占比（异常值比率）
    %
    % 输入:
    %   image - 多波段图像数据 (m x n x bands) 
    %
    % 输出:
    %   ratio_outlier - 异常值比率

    % 计算背景标准差和平均值，忽略NaN值
    stat.bkg_std = std(pan_img(:), 0, 'omitnan'); % 第二个参数为0表示样本标准差
    stat.midline = mean(pan_img(:), 'omitnan');
    
    % 计算上下限
    stat.maxline = stat.midline + 2 * stat.bkg_std;
    stat.minline = stat.midline - 2 * stat.bkg_std;
    
    % 计算两倍标准差外的像素占比（定义为Outlier Rate）
    num_pixels = numel(pan_img); % 总像素数
    num_outliers = sum(pan_img(:) > stat.maxline | pan_img(:) < stat.minline, 'omitnan'); % 异常像素数
    
    stat.ratio_outlier = num_outliers / num_pixels;
end