function result = Threshdata(image)
%% 频率域滤波
% 设置截止频率，数值越小模糊效果越强
cutoffFrequency = 500;
% 应用高斯低通滤波
image_filt = gaussianLowPassFilter(image, cutoffFrequency);

%% 估算背景标准差
windowSize = 20;
stdMap = computeLocalStd(image_filt, windowSize);
sigma = 50;
stdMap2 = imgaussfilt(stdMap, sigma);
thresh_img2 = image_filt;
thresh_img2(thresh_img2 < 2 * stdMap2) = 0;
% imagesc(stdMap2)

%% 仅保留像素数目达到 thresh 个的部分
neighbour = 8;
% 使用二值图像标记连通区域
labeled_image = bwlabel(thresh_img2 > 0, neighbour); % 标记连通区域
region_props = regionprops(labeled_image, 'Area'); % 获取各个区域的像素数目
thresh2 = 200;
mask = ismember(labeled_image, find([region_props.Area] >= thresh2));
result = thresh_img2 .* mask; % 筛选结果

%% 空间域滤波
sigma = 0.5;
result_filt = imgaussfilt(result, sigma);

end

%%
% figure('Position', [200 50 1500 350])
% subplot(131)
% imagesc(image)
% subplot(132)
% imagesc(image_filt)
% subplot(133)
% imagesc(result)