function TIFF = ThreshTIFF(TIFF, PARM_CROP)
%% 边框区域
blk_area = sum(TIFF.cutrgb, 3) == 0;
%% 滤波
image_len = size(TIFF.cutdata, 1);
% TIFF.cutdata = medfilt2(TIFF.cutdata);
cutoffFrequency = image_len / 8; % 设置截止频率，数值越小模糊效果越强
% 应用高斯低通滤波
TIFF.filterdata = gaussianLowPassFilter(TIFF.cutdata, cutoffFrequency);
TIFF.filterdata(blk_area) = nan;
%% 剔除低值
temp = TIFF.filterdata;
std_avg = std(temp(:), 'omitnan');
% thresh = prctile(temp, percent); % percent = 82 百分比阈值
thresh1 = PARM_CROP.percent * std_avg;
TIFF.threshdata = TIFF.filterdata;
TIFF.threshdata(TIFF.threshdata < thresh1) = 0;
%
% subplot(131)
% imagesc(TIFF.cutdata)
% axis square
% subplot(132)
% axis square
% imagesc(TIFF.filterdata)
% axis square
% subplot(133)
% imagesc(TIFF.threshdata)
% axis square
%% 二值提取
% 20邻域版
% DISTANCE = 1; % DISTANCE 距离小于该数值的像素被认为是连通的
% neighbour = 4; % 使用20邻域处理
% distances = bwdist(TIFF.threshdata > 0); % 计算到每个非零像素的距离
% connected = distances <= DISTANCE; % 距离小于某一数值的像素被认为是连通的
% % 使用二值图像标记连通区域
% labeled_image = bwlabel(connected, neighbour); % 标记连通区域
% region_props = regionprops(labeled_image, 'Area'); % 获取各个区域的像素数目

% 8邻域版
neighbour2 = 8;
% 使用二值图像标记连通区域
labeled_image = bwlabel(TIFF.threshdata > 0, neighbour2); % 标记连通区域
region_props = regionprops(labeled_image, 'Area'); % 获取各个区域的像素数目

TIFF.mask = ismember(labeled_image, find([region_props.Area] >= PARM_CROP.thresh));
TIFF.maskdata = TIFF.threshdata .* TIFF.mask; % 筛选结果
%% 赋值
TIFF.finalmask = TIFF.maskdata ~= 0;

end